/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.common.network;

import com.google.common.collect.ImmutableList;
import com.mrcrayfish.guns.Config;
import com.mrcrayfish.guns.GunMod;
import com.mrcrayfish.guns.common.Gun;
import com.mrcrayfish.guns.common.ProjectileManager;
import com.mrcrayfish.guns.common.ShootTracker;
import com.mrcrayfish.guns.common.SpreadTracker;
import com.mrcrayfish.guns.common.container.AttachmentContainer;
import com.mrcrayfish.guns.common.container.WorkbenchContainer;
import com.mrcrayfish.guns.crafting.WorkbenchRecipe;
import com.mrcrayfish.guns.crafting.WorkbenchRecipes;
import com.mrcrayfish.guns.entity.ProjectileEntity;
import com.mrcrayfish.guns.event.GunFireEvent;
import com.mrcrayfish.guns.init.ModEnchantments;
import com.mrcrayfish.guns.init.ModSyncedDataKeys;
import com.mrcrayfish.guns.interfaces.IProjectileFactory;
import com.mrcrayfish.guns.item.GunItem;
import com.mrcrayfish.guns.item.IColored;
import com.mrcrayfish.guns.network.PacketHandler;
import com.mrcrayfish.guns.network.message.MessageBulletTrail;
import com.mrcrayfish.guns.network.message.MessageGunSound;
import com.mrcrayfish.guns.network.message.MessageShoot;
import com.mrcrayfish.guns.tileentity.WorkbenchTileEntity;
import com.mrcrayfish.guns.util.GunModifierHelper;
import com.mrcrayfish.guns.util.InventoryUtil;
import com.mrcrayfish.obfuscate.common.data.SyncedPlayerData;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.DyeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;

public class ServerPlayHandler {
    private static final Predicate<LivingEntity> HOSTILE_ENTITIES = entity -> entity.func_184176_by() == SoundCategory.HOSTILE && !((List)Config.COMMON.aggroMobs.exemptEntities.get()).contains(entity.func_200600_R().getRegistryName().toString());

    public static void handleShoot(MessageShoot message, ServerPlayerEntity player) {
        if (!player.func_175149_v()) {
            World world = player.field_70170_p;
            ItemStack heldItem = player.func_184586_b(Hand.MAIN_HAND);
            if (heldItem.func_77973_b() instanceof GunItem && (Gun.hasAmmo(heldItem) || player.func_184812_l_())) {
                GunItem item = (GunItem)heldItem.func_77973_b();
                Gun modifiedGun = item.getModifiedGun(heldItem);
                if (modifiedGun != null) {
                    int level;
                    CompoundNBT tag;
                    boolean silenced;
                    ResourceLocation fireSound;
                    SoundEvent event;
                    if (MinecraftForge.EVENT_BUS.post((Event)new GunFireEvent.Pre((PlayerEntity)player, heldItem))) {
                        return;
                    }
                    player.field_70177_z = message.getRotationYaw();
                    player.field_70125_A = message.getRotationPitch();
                    ShootTracker tracker = ShootTracker.getShootTracker((PlayerEntity)player);
                    if (tracker.hasCooldown(item)) {
                        GunMod.LOGGER.warn(player.func_200200_C_().func_150261_e() + "(" + player.func_110124_au() + ") tried to fire before cooldown finished or server is lagging? Remaining milliseconds: " + tracker.getRemaining(item));
                        return;
                    }
                    tracker.putCooldown(heldItem, item, modifiedGun);
                    if (((Boolean)SyncedPlayerData.instance().get((PlayerEntity)player, ModSyncedDataKeys.RELOADING)).booleanValue()) {
                        SyncedPlayerData.instance().set((PlayerEntity)player, ModSyncedDataKeys.RELOADING, (Object)false);
                    }
                    if (!modifiedGun.getGeneral().isAlwaysSpread() && modifiedGun.getGeneral().getSpread() > 0.0f) {
                        SpreadTracker.get((PlayerEntity)player).update((PlayerEntity)player, item);
                    }
                    int count = modifiedGun.getGeneral().getProjectileAmount();
                    Gun.Projectile projectileProps = modifiedGun.getProjectile();
                    ProjectileEntity[] spawnedProjectiles = new ProjectileEntity[count];
                    for (int i = 0; i < count; ++i) {
                        IProjectileFactory factory = ProjectileManager.getInstance().getFactory(projectileProps.getItem());
                        ProjectileEntity projectileEntity = factory.create(world, (LivingEntity)player, heldItem, item, modifiedGun);
                        projectileEntity.setWeapon(heldItem);
                        projectileEntity.setAdditionalDamage(Gun.getAdditionalDamage(heldItem));
                        world.func_217376_c((Entity)projectileEntity);
                        spawnedProjectiles[i] = projectileEntity;
                        projectileEntity.func_70071_h_();
                    }
                    if (!projectileProps.isVisible()) {
                        MessageBulletTrail messageBulletTrail = new MessageBulletTrail(spawnedProjectiles, projectileProps, player.func_145782_y());
                        PacketHandler.getPlayChannel().send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), ((Double)Config.COMMON.network.projectileTrackingRange.get()).doubleValue(), player.field_70170_p.func_201675_m().func_186058_p())), (Object)messageBulletTrail);
                    }
                    MinecraftForge.EVENT_BUS.post((Event)new GunFireEvent.Post((PlayerEntity)player, heldItem));
                    if (((Boolean)Config.COMMON.aggroMobs.enabled.get()).booleanValue()) {
                        double radius = GunModifierHelper.getModifiedFireSoundRadius(heldItem, (Double)Config.COMMON.aggroMobs.range.get());
                        double x = player.func_226277_ct_();
                        double y = player.func_226278_cu_() + 0.5;
                        double z = player.func_226281_cx_();
                        AxisAlignedBB box = new AxisAlignedBB(x - radius, y - radius, z - radius, x + radius, y + radius, z + radius);
                        radius *= radius;
                        for (LivingEntity entity : world.func_175647_a(LivingEntity.class, box, HOSTILE_ENTITIES)) {
                            double dz;
                            double dy;
                            double dx = x - entity.func_226277_ct_();
                            if (!(dx * dx + (dy = y - entity.func_226278_cu_()) * dy + (dz = z - entity.func_226281_cx_()) * dz <= radius)) continue;
                            entity.func_70604_c((LivingEntity)((Boolean)Config.COMMON.aggroMobs.angerHostileMobs.get() != false ? player : entity));
                        }
                    }
                    if ((event = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(fireSound = (silenced = GunModifierHelper.isSilencedFire(heldItem)) ? modifiedGun.getSounds().getSilencedFire() : modifiedGun.getSounds().getFire())) != null) {
                        double posX = player.func_226277_ct_();
                        double posY = player.func_226278_cu_() + (double)player.func_70047_e();
                        double posZ = player.func_226281_cx_();
                        float volume = GunModifierHelper.getFireSoundVolume(heldItem);
                        float pitch = 0.9f + world.field_73012_v.nextFloat() * 0.2f;
                        double radius = GunModifierHelper.getModifiedFireSoundRadius(heldItem, (Double)Config.SERVER.gunShotMaxDistance.get());
                        boolean muzzle = modifiedGun.getDisplay().getFlash() != null;
                        MessageGunSound messageSound = new MessageGunSound(event, SoundCategory.PLAYERS, (float)posX, (float)posY, (float)posZ, volume, pitch, player.func_145782_y(), muzzle);
                        PacketDistributor.TargetPoint targetPoint = new PacketDistributor.TargetPoint(posX, posY, posZ, radius, player.field_70170_p.func_201675_m().func_186058_p());
                        PacketHandler.getPlayChannel().send(PacketDistributor.NEAR.with(() -> targetPoint), (Object)messageSound);
                    }
                    if (!(player.func_184812_l_() || (tag = heldItem.func_196082_o()).func_74767_n("IgnoreAmmo") || (level = EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)ModEnchantments.RECLAIMED.get()), (ItemStack)heldItem)) != 0 && player.field_70170_p.field_73012_v.nextInt(4 - MathHelper.func_76125_a((int)level, (int)1, (int)2)) == 0)) {
                        tag.func_74768_a("AmmoCount", Math.max(0, tag.func_74762_e("AmmoCount") - 1));
                    }
                }
            } else {
                world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187750_dc, SoundCategory.BLOCKS, 0.3f, 0.8f);
            }
        }
    }

    public static void handleCraft(ServerPlayerEntity player, ResourceLocation id, BlockPos pos) {
        WorkbenchContainer workbench;
        World world = player.field_70170_p;
        if (player.field_71070_bA instanceof WorkbenchContainer && (workbench = (WorkbenchContainer)player.field_71070_bA).getPos().equals((Object)pos)) {
            WorkbenchRecipe recipe = WorkbenchRecipes.getRecipeById(world, id);
            if (recipe == null) {
                return;
            }
            ImmutableList<ItemStack> materials = recipe.getMaterials();
            if (materials != null) {
                ItemStack stack2;
                for (ItemStack stack2 : materials) {
                    if (InventoryUtil.hasItemStack((PlayerEntity)player, stack2)) continue;
                    return;
                }
                for (ItemStack stack2 : materials) {
                    InventoryUtil.removeItemStack((PlayerEntity)player, stack2);
                }
                WorkbenchTileEntity workbenchTileEntity = workbench.getWorkbench();
                stack2 = recipe.getItem();
                ItemStack dyeStack = (ItemStack)workbenchTileEntity.getInventory().get(0);
                if (dyeStack.func_77973_b() instanceof DyeItem) {
                    DyeItem dyeItem = (DyeItem)dyeStack.func_77973_b();
                    int color = dyeItem.func_195962_g().getColorValue();
                    if (stack2.func_77973_b() instanceof IColored && ((IColored)stack2.func_77973_b()).canColor(stack2)) {
                        IColored colored = (IColored)stack2.func_77973_b();
                        colored.setColor(stack2, color);
                        workbenchTileEntity.getInventory().set(0, (Object)ItemStack.field_190927_a);
                    }
                }
                world.func_217376_c((Entity)new ItemEntity(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.125, (double)pos.func_177952_p() + 0.5, stack2));
            }
        }
    }

    public static void handleUnload(ServerPlayerEntity player) {
        CompoundNBT tag;
        ItemStack stack = player.func_184614_ca();
        if (stack.func_77973_b() instanceof GunItem && (tag = stack.func_77978_p()) != null && tag.func_150297_b("AmmoCount", 3)) {
            int count = tag.func_74762_e("AmmoCount");
            tag.func_74768_a("AmmoCount", 0);
            GunItem gunItem = (GunItem)stack.func_77973_b();
            Gun gun = gunItem.getModifiedGun(stack);
            ResourceLocation id = gun.getProjectile().getItem();
            Item item = (Item)ForgeRegistries.ITEMS.getValue(id);
            if (item == null) {
                return;
            }
            int maxStackSize = item.func_77639_j();
            int stacks = count / maxStackSize;
            for (int i = 0; i < stacks; ++i) {
                ServerPlayHandler.spawnAmmo(player, new ItemStack((IItemProvider)item, maxStackSize));
            }
            int remaining = count % maxStackSize;
            if (remaining > 0) {
                ServerPlayHandler.spawnAmmo(player, new ItemStack((IItemProvider)item, count));
            }
        }
    }

    private static void spawnAmmo(ServerPlayerEntity player, ItemStack stack) {
        player.field_71071_by.func_70441_a(stack);
        if (stack.func_190916_E() > 0) {
            player.field_70170_p.func_217376_c((Entity)new ItemEntity(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), stack.func_77946_l()));
        }
    }

    public static void handleAttachments(ServerPlayerEntity player) {
        ItemStack heldItem = player.func_184614_ca();
        if (heldItem.func_77973_b() instanceof GunItem) {
            NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)new SimpleNamedContainerProvider((windowId, playerInventory, player1) -> new AttachmentContainer(windowId, playerInventory, heldItem), (ITextComponent)new TranslationTextComponent("container.cgm.attachments", new Object[0])));
        }
    }
}

