/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.crafting;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mrcrayfish.guns.crafting.WorkbenchRecipe;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class WorkbenchRecipeSerializer
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<WorkbenchRecipe> {
    public WorkbenchRecipe read(ResourceLocation recipeId, JsonObject json) {
        ImmutableList.Builder builder = ImmutableList.builder();
        JsonArray input = JSONUtils.func_151214_t((JsonObject)json, (String)"materials");
        for (int i = 0; i < input.size(); ++i) {
            JsonObject itemObject = input.get(i).getAsJsonObject();
            ItemStack stack = ShapedRecipe.func_199798_a((JsonObject)itemObject);
            builder.add((Object)stack);
        }
        if (!json.has("result")) {
            throw new JsonSyntaxException("Missing vehicle entry");
        }
        JsonObject resultObject = JSONUtils.func_152754_s((JsonObject)json, (String)"result");
        ItemStack resultItem = ShapedRecipe.func_199798_a((JsonObject)resultObject);
        return new WorkbenchRecipe(recipeId, resultItem, (ImmutableList<ItemStack>)builder.build());
    }

    @Nullable
    public WorkbenchRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
        ItemStack result = buffer.func_150791_c();
        ImmutableList.Builder builder = ImmutableList.builder();
        int size = buffer.func_150792_a();
        for (int i = 0; i < size; ++i) {
            builder.add((Object)buffer.func_150791_c());
        }
        return new WorkbenchRecipe(recipeId, result, (ImmutableList<ItemStack>)builder.build());
    }

    public void write(PacketBuffer buffer, WorkbenchRecipe recipe) {
        buffer.func_150788_a(recipe.getItem());
        buffer.func_150787_b(recipe.getMaterials().size());
        for (ItemStack stack : recipe.getMaterials()) {
            buffer.func_150788_a(stack);
        }
    }
}

