/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.item;

import com.mrcrayfish.guns.common.Gun;
import com.mrcrayfish.guns.common.NetworkGunManager;
import com.mrcrayfish.guns.enchantment.EnchantmentTypes;
import com.mrcrayfish.guns.item.IColored;
import com.mrcrayfish.guns.util.GunEnchantmentHelper;
import com.mrcrayfish.guns.util.GunModifierHelper;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.KeybindTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class GunItem
extends Item
implements IColored {
    private WeakHashMap<CompoundNBT, Gun> modifiedGunCache = new WeakHashMap();
    private Gun gun = new Gun();

    public GunItem(Item.Properties properties) {
        super(properties);
    }

    public void setGun(NetworkGunManager.Supplier supplier) {
        this.gun = supplier.getGun();
    }

    public Gun getGun() {
        return this.gun;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flag) {
        Gun modifiedGun = this.getModifiedGun(stack);
        Item ammo = (Item)ForgeRegistries.ITEMS.getValue(modifiedGun.getProjectile().getItem());
        if (ammo != null) {
            tooltip.add(new TranslationTextComponent("info.cgm.ammo_type", new Object[]{new TranslationTextComponent(ammo.func_77658_a(), new Object[0]).func_211708_a(TextFormatting.WHITE)}).func_211708_a(TextFormatting.GRAY));
        }
        String additionalDamageText = "";
        CompoundNBT tagCompound = stack.func_77978_p();
        if (tagCompound != null && tagCompound.func_150297_b("AdditionalDamage", 99)) {
            float additionalDamage = tagCompound.func_74760_g("AdditionalDamage");
            if ((additionalDamage += GunModifierHelper.getAdditionalDamage(stack)) > 0.0f) {
                additionalDamageText = TextFormatting.GREEN + " +" + ItemStack.field_111284_a.format(additionalDamage);
            } else if (additionalDamage < 0.0f) {
                additionalDamageText = TextFormatting.RED + " " + ItemStack.field_111284_a.format(additionalDamage);
            }
        }
        float damage = modifiedGun.getProjectile().getDamage();
        damage = GunModifierHelper.getModifiedProjectileDamage(stack, damage);
        damage = GunEnchantmentHelper.getAcceleratorDamage(stack, damage);
        tooltip.add(new TranslationTextComponent("info.cgm.damage", new Object[]{TextFormatting.WHITE + ItemStack.field_111284_a.format(damage) + additionalDamageText}).func_211708_a(TextFormatting.GRAY));
        if (tagCompound != null) {
            if (tagCompound.func_74767_n("IgnoreAmmo")) {
                tooltip.add(new TranslationTextComponent("info.cgm.ignore_ammo", new Object[0]).func_211708_a(TextFormatting.AQUA));
            } else {
                int ammoCount = tagCompound.func_74762_e("AmmoCount");
                tooltip.add(new TranslationTextComponent("info.cgm.ammo", new Object[]{TextFormatting.WHITE.toString() + ammoCount + "/" + GunEnchantmentHelper.getAmmoCapacity(stack, modifiedGun)}).func_211708_a(TextFormatting.GRAY));
            }
        }
        tooltip.add(new TranslationTextComponent("info.cgm.attachment_help", new Object[]{new KeybindTextComponent("key.cgm.attachments").getString().toUpperCase(Locale.ENGLISH)}).func_211708_a(TextFormatting.YELLOW));
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        return true;
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> stacks) {
        if (this.func_194125_a(group)) {
            ItemStack stack = new ItemStack((IItemProvider)this);
            stack.func_196082_o().func_74768_a("AmmoCount", this.gun.getGeneral().getMaxAmmo());
            stacks.add((Object)stack);
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        CompoundNBT tagCompound = stack.func_196082_o();
        Gun modifiedGun = this.getModifiedGun(stack);
        return !tagCompound.func_74767_n("IgnoreAmmo") && tagCompound.func_74762_e("AmmoCount") != GunEnchantmentHelper.getAmmoCapacity(stack, modifiedGun);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        CompoundNBT tagCompound = stack.func_196082_o();
        Gun modifiedGun = this.getModifiedGun(stack);
        return 1.0 - (double)tagCompound.func_74762_e("AmmoCount") / (double)GunEnchantmentHelper.getAmmoCapacity(stack, modifiedGun);
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return Objects.requireNonNull(TextFormatting.AQUA.func_211163_e());
    }

    public Gun getModifiedGun(ItemStack stack) {
        CompoundNBT tagCompound = stack.func_77978_p();
        if (tagCompound != null && tagCompound.func_150297_b("Gun", 10)) {
            return this.modifiedGunCache.computeIfAbsent(tagCompound, item -> {
                if (tagCompound.func_74767_n("Custom")) {
                    return Gun.create(tagCompound.func_74775_l("Gun"));
                }
                Gun gunCopy = this.gun.copy();
                gunCopy.deserializeNBT(tagCompound.func_74775_l("Gun"));
                return gunCopy;
            });
        }
        return this.gun;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment.field_77351_y == EnchantmentTypes.SEMI_AUTO_GUN) {
            Gun modifiedGun = this.getModifiedGun(stack);
            return !modifiedGun.getGeneral().isAuto();
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public boolean func_77616_k(ItemStack stack) {
        return this.getItemStackLimit(stack) == 1;
    }

    public int func_77619_b() {
        return 5;
    }
}

