/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.particles;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.registries.ForgeRegistries;

public class BulletHoleData
implements IParticleData {
    public static final IParticleData.IDeserializer<BulletHoleData> DESERIALIZER = new IParticleData.IDeserializer<BulletHoleData>(){

        public BulletHoleData deserialize(ParticleType<BulletHoleData> particleType, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            Direction direction = Direction.func_176739_a((String)reader.readString());
            if (direction == null) {
                direction = Direction.NORTH;
            }
            reader.expect(' ');
            int x = reader.readInt();
            reader.expect(' ');
            int y = reader.readInt();
            reader.expect(' ');
            int z = reader.readInt();
            return new BulletHoleData(particleType, direction, new BlockPos(x, y, z));
        }

        public BulletHoleData read(ParticleType<BulletHoleData> particleType, PacketBuffer buffer) {
            return new BulletHoleData(particleType, (Direction)buffer.func_179257_a(Direction.class), buffer.func_179259_c());
        }
    };
    private final ParticleType<BulletHoleData> particleType;
    private final Direction direction;
    private final BlockPos pos;

    public BulletHoleData(ParticleType<BulletHoleData> particleType, Direction direction, BlockPos pos) {
        this.particleType = particleType;
        this.direction = direction;
        this.pos = pos;
    }

    public ParticleType<?> func_197554_b() {
        return this.particleType;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public void func_197553_a(PacketBuffer buffer) {
        buffer.func_179249_a((Enum)this.direction);
        buffer.func_179255_a(this.pos);
    }

    public String func_197555_a() {
        return ForgeRegistries.PARTICLE_TYPES.getKey(this.func_197554_b()) + " " + this.direction.func_176610_l();
    }
}

