/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.common;

import com.mrcrayfish.guns.common.DelayedTask;
import com.mrcrayfish.guns.common.Gun;
import com.mrcrayfish.guns.init.ModSyncedDataKeys;
import com.mrcrayfish.guns.item.GunItem;
import com.mrcrayfish.guns.network.PacketHandler;
import com.mrcrayfish.guns.network.message.MessageGunSound;
import com.mrcrayfish.guns.util.GunEnchantmentHelper;
import com.mrcrayfish.obfuscate.common.data.SyncedPlayerData;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="cgm")
public class ReloadTracker {
    private static final Map<PlayerEntity, ReloadTracker> RELOAD_TRACKER_MAP = new WeakHashMap<PlayerEntity, ReloadTracker>();
    private int startTick;
    private int slot;
    private ItemStack stack;
    private Gun gun;

    private ReloadTracker(PlayerEntity player) {
        this.startTick = player.field_70173_aa;
        this.slot = player.field_71071_by.field_70461_c;
        this.stack = player.field_71071_by.func_70448_g();
        this.gun = ((GunItem)this.stack.func_77973_b()).getModifiedGun(this.stack);
    }

    private boolean isSameWeapon(PlayerEntity player) {
        return !this.stack.func_190926_b() && player.field_71071_by.field_70461_c == this.slot && player.field_71071_by.func_70448_g() == this.stack;
    }

    private boolean isWeaponFull() {
        CompoundNBT tag = this.stack.func_196082_o();
        return tag.func_74762_e("AmmoCount") >= GunEnchantmentHelper.getAmmoCapacity(this.stack, this.gun);
    }

    private boolean hasNoAmmo(PlayerEntity player) {
        return Gun.findAmmo(player, this.gun.getProjectile().getItem()).func_190926_b();
    }

    private boolean canReload(PlayerEntity player) {
        int deltaTicks = player.field_70173_aa - this.startTick;
        int interval = GunEnchantmentHelper.getReloadInterval(this.stack);
        return deltaTicks > 0 && deltaTicks % interval == 0;
    }

    private void increaseAmmo(PlayerEntity player) {
        SoundEvent event;
        ItemStack ammo = Gun.findAmmo(player, this.gun.getProjectile().getItem());
        if (!ammo.func_190926_b()) {
            int amount = Math.min(ammo.func_190916_E(), this.gun.getGeneral().getReloadAmount());
            CompoundNBT tag = this.stack.func_77978_p();
            if (tag != null) {
                int maxAmmo = GunEnchantmentHelper.getAmmoCapacity(this.stack, this.gun);
                amount = Math.min(amount, maxAmmo - tag.func_74762_e("AmmoCount"));
                tag.func_74768_a("AmmoCount", tag.func_74762_e("AmmoCount") + amount);
            }
            ammo.func_190918_g(amount);
        }
        if ((event = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(this.gun.getSounds().getReload())) != null) {
            player.field_70170_p.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_() + 1.0, player.func_226281_cx_(), event, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START && !event.player.field_70170_p.field_72995_K) {
            PlayerEntity player = event.player;
            if (((Boolean)SyncedPlayerData.instance().get(player, ModSyncedDataKeys.RELOADING)).booleanValue()) {
                ReloadTracker tracker;
                if (!RELOAD_TRACKER_MAP.containsKey(player)) {
                    if (!(player.field_71071_by.func_70448_g().func_77973_b() instanceof GunItem)) {
                        SyncedPlayerData.instance().set(player, ModSyncedDataKeys.RELOADING, (Object)false);
                        return;
                    }
                    RELOAD_TRACKER_MAP.put(player, new ReloadTracker(player));
                }
                if (!(tracker = RELOAD_TRACKER_MAP.get(player)).isSameWeapon(player) || tracker.isWeaponFull() || tracker.hasNoAmmo(player)) {
                    RELOAD_TRACKER_MAP.remove(player);
                    SyncedPlayerData.instance().set(player, ModSyncedDataKeys.RELOADING, (Object)false);
                    return;
                }
                if (tracker.canReload(player)) {
                    tracker.increaseAmmo(player);
                    if (tracker.isWeaponFull() || tracker.hasNoAmmo(player)) {
                        RELOAD_TRACKER_MAP.remove(player);
                        SyncedPlayerData.instance().set(player, ModSyncedDataKeys.RELOADING, (Object)false);
                        PlayerEntity finalPlayer = player;
                        Gun gun = tracker.gun;
                        DelayedTask.runAfter(4, () -> {
                            SoundEvent cockEvent = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(gun.getSounds().getCock());
                            if (cockEvent != null && finalPlayer.func_70089_S()) {
                                MessageGunSound messageSound = new MessageGunSound(cockEvent, SoundCategory.PLAYERS, (float)finalPlayer.func_226277_ct_(), (float)(finalPlayer.func_226278_cu_() + 1.0), (float)finalPlayer.func_226281_cx_(), 1.0f, 1.0f, finalPlayer.func_145782_y(), false);
                                PacketHandler.getPlayChannel().send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)finalPlayer), (Object)messageSound);
                            }
                        });
                    }
                }
            } else if (RELOAD_TRACKER_MAP.containsKey(player)) {
                RELOAD_TRACKER_MAP.remove(player);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerEvent.PlayerLoggedOutEvent event) {
        MinecraftServer server = event.getPlayer().func_184102_h();
        if (server != null) {
            server.execute(() -> RELOAD_TRACKER_MAP.remove(event.getPlayer()));
        }
    }
}

