/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.common;

import com.mrcrayfish.guns.Config;
import com.mrcrayfish.guns.init.ModSyncedDataKeys;
import com.mrcrayfish.guns.item.GunItem;
import com.mrcrayfish.obfuscate.common.data.SyncedPlayerData;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableLong;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="cgm")
public class SpreadTracker {
    private static final Map<PlayerEntity, SpreadTracker> TRACKER_MAP = new WeakHashMap<PlayerEntity, SpreadTracker>();
    private final Map<GunItem, Pair<MutableLong, MutableInt>> SPREAD_TRACKER_MAP = new HashMap<GunItem, Pair<MutableLong, MutableInt>>();

    public void update(PlayerEntity player, GunItem item) {
        Pair entry = this.SPREAD_TRACKER_MAP.computeIfAbsent(item, gun -> Pair.of((Object)new MutableLong(-1L), (Object)new MutableInt()));
        MutableLong lastFire = (MutableLong)entry.getLeft();
        if (lastFire.getValue() != -1L) {
            MutableInt spreadCount = (MutableInt)entry.getRight();
            long deltaTime = System.currentTimeMillis() - lastFire.getValue();
            if (deltaTime < (long)((Integer)Config.COMMON.projectileSpread.spreadThreshold.get()).intValue()) {
                if (spreadCount.getValue() < (Integer)Config.COMMON.projectileSpread.maxCount.get()) {
                    spreadCount.increment();
                    if (spreadCount.getValue() < (Integer)Config.COMMON.projectileSpread.maxCount.get() && !((Boolean)SyncedPlayerData.instance().get(player, ModSyncedDataKeys.AIMING)).booleanValue()) {
                        spreadCount.increment();
                    }
                }
            } else {
                spreadCount.setValue(0);
            }
        }
        lastFire.setValue(System.currentTimeMillis());
    }

    public float getSpread(GunItem item) {
        Pair<MutableLong, MutableInt> entry = this.SPREAD_TRACKER_MAP.get(item);
        if (entry != null) {
            return (float)((MutableInt)entry.getRight()).getValue().intValue() / (float)((Integer)Config.COMMON.projectileSpread.maxCount.get()).intValue();
        }
        return 0.0f;
    }

    public static SpreadTracker get(PlayerEntity player) {
        return TRACKER_MAP.computeIfAbsent(player, player1 -> new SpreadTracker());
    }

    @SubscribeEvent
    public static void onPlayerDisconnect(PlayerEvent.PlayerLoggedOutEvent event) {
        MinecraftServer server = event.getPlayer().func_184102_h();
        if (server != null) {
            server.execute(() -> TRACKER_MAP.remove(event.getPlayer()));
        }
    }
}

