/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.network.message;

import com.google.common.base.MoreObjects;
import com.mrcrayfish.guns.client.network.ClientPlayHandler;
import com.mrcrayfish.guns.common.Gun;
import com.mrcrayfish.guns.entity.ProjectileEntity;
import com.mrcrayfish.guns.network.message.IMessage;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class MessageBulletTrail
implements IMessage {
    private int[] entityIds;
    private Vector3d[] positions;
    private Vector3d[] motions;
    private ItemStack item;
    private int trailColor;
    private double trailLengthMultiplier;
    private int life;
    private double gravity;
    private int shooterId;

    public MessageBulletTrail() {
    }

    public MessageBulletTrail(ProjectileEntity[] spawnedProjectiles, Gun.Projectile projectileProps, int shooterId) {
        this.positions = new Vector3d[spawnedProjectiles.length];
        this.motions = new Vector3d[spawnedProjectiles.length];
        this.entityIds = new int[spawnedProjectiles.length];
        for (int i = 0; i < spawnedProjectiles.length; ++i) {
            ProjectileEntity projectile = spawnedProjectiles[i];
            this.positions[i] = projectile.func_213303_ch();
            this.motions[i] = projectile.func_213322_ci();
            this.entityIds[i] = projectile.func_145782_y();
        }
        this.item = (ItemStack)MoreObjects.firstNonNull((Object)new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(projectileProps.getItem())), (Object)ItemStack.field_190927_a);
        this.trailColor = projectileProps.getTrailColor();
        this.trailLengthMultiplier = projectileProps.getTrailLengthMultiplier();
        this.life = projectileProps.getLife();
        this.gravity = spawnedProjectiles[0].getModifiedGravity();
        this.shooterId = shooterId;
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.entityIds.length);
        for (int i = 0; i < this.entityIds.length; ++i) {
            buffer.writeInt(this.entityIds[i]);
            Vector3d position = this.positions[i];
            buffer.writeDouble(position.field_72450_a);
            buffer.writeDouble(position.field_72448_b);
            buffer.writeDouble(position.field_72449_c);
            Vector3d motion = this.motions[i];
            buffer.writeDouble(motion.field_72450_a);
            buffer.writeDouble(motion.field_72448_b);
            buffer.writeDouble(motion.field_72449_c);
        }
        buffer.func_150788_a(this.item);
        buffer.func_150787_b(this.trailColor);
        buffer.writeDouble(this.trailLengthMultiplier);
        buffer.writeInt(this.life);
        buffer.writeDouble(this.gravity);
        buffer.writeInt(this.shooterId);
    }

    @Override
    public void decode(PacketBuffer buffer) {
        int size = buffer.readInt();
        this.entityIds = new int[size];
        this.positions = new Vector3d[size];
        this.motions = new Vector3d[size];
        for (int i = 0; i < size; ++i) {
            this.entityIds[i] = buffer.readInt();
            this.positions[i] = new Vector3d(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
            this.motions[i] = new Vector3d(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        }
        this.item = buffer.func_150791_c();
        this.trailColor = buffer.func_150792_a();
        this.trailLengthMultiplier = buffer.readDouble();
        this.life = buffer.readInt();
        this.gravity = buffer.readDouble();
        this.shooterId = buffer.readInt();
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> ClientPlayHandler.handleMessageBulletTrail(this));
        supplier.get().setPacketHandled(true);
    }

    public int getCount() {
        return this.entityIds.length;
    }

    public int[] getEntityIds() {
        return this.entityIds;
    }

    public Vector3d[] getPositions() {
        return this.positions;
    }

    public Vector3d[] getMotions() {
        return this.motions;
    }

    public int getTrailColor() {
        return this.trailColor;
    }

    public double getTrailLengthMultiplier() {
        return this.trailLengthMultiplier;
    }

    public int getLife() {
        return this.life;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public double getGravity() {
        return this.gravity;
    }

    public int getShooterId() {
        return this.shooterId;
    }
}

