/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.client;

import com.mrcrayfish.framework.network.message.IMessage;
import com.mrcrayfish.guns.GunMod;
import com.mrcrayfish.guns.client.CustomGunManager;
import com.mrcrayfish.guns.client.GunButtonBindings;
import com.mrcrayfish.guns.client.KeyBinds;
import com.mrcrayfish.guns.client.SpecialModels;
import com.mrcrayfish.guns.client.handler.AimingHandler;
import com.mrcrayfish.guns.client.handler.BulletTrailRenderingHandler;
import com.mrcrayfish.guns.client.handler.ControllerHandler;
import com.mrcrayfish.guns.client.handler.CrosshairHandler;
import com.mrcrayfish.guns.client.handler.GunRenderingHandler;
import com.mrcrayfish.guns.client.handler.PlayerModelHandler;
import com.mrcrayfish.guns.client.handler.RecoilHandler;
import com.mrcrayfish.guns.client.handler.ReloadHandler;
import com.mrcrayfish.guns.client.handler.ShootingHandler;
import com.mrcrayfish.guns.client.handler.SoundHandler;
import com.mrcrayfish.guns.client.render.gun.ModelOverrides;
import com.mrcrayfish.guns.client.render.gun.model.GrenadeLauncherModel;
import com.mrcrayfish.guns.client.render.gun.model.MiniGunModel;
import com.mrcrayfish.guns.client.render.gun.model.SimpleModel;
import com.mrcrayfish.guns.client.screen.AttachmentScreen;
import com.mrcrayfish.guns.client.screen.WorkbenchScreen;
import com.mrcrayfish.guns.client.util.PropertyHelper;
import com.mrcrayfish.guns.debug.IEditorMenu;
import com.mrcrayfish.guns.debug.client.screen.EditorScreen;
import com.mrcrayfish.guns.enchantment.EnchantmentTypes;
import com.mrcrayfish.guns.init.ModBlocks;
import com.mrcrayfish.guns.init.ModContainers;
import com.mrcrayfish.guns.init.ModItems;
import com.mrcrayfish.guns.item.GunItem;
import com.mrcrayfish.guns.item.IColored;
import com.mrcrayfish.guns.item.attachment.IAttachment;
import com.mrcrayfish.guns.network.PacketHandler;
import com.mrcrayfish.guns.network.message.C2SMessageAttachments;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.gui.components.OptionsList;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.MouseSettingsScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.CreativeModeTabEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="cgm", value={Dist.CLIENT})
public class ClientHandler {
    private static Field mouseOptionsField;

    public static void setup() {
        MinecraftForge.EVENT_BUS.register((Object)AimingHandler.get());
        MinecraftForge.EVENT_BUS.register((Object)BulletTrailRenderingHandler.get());
        MinecraftForge.EVENT_BUS.register((Object)CrosshairHandler.get());
        MinecraftForge.EVENT_BUS.register((Object)GunRenderingHandler.get());
        MinecraftForge.EVENT_BUS.register((Object)RecoilHandler.get());
        MinecraftForge.EVENT_BUS.register((Object)ReloadHandler.get());
        MinecraftForge.EVENT_BUS.register((Object)ShootingHandler.get());
        MinecraftForge.EVENT_BUS.register((Object)SoundHandler.get());
        MinecraftForge.EVENT_BUS.register((Object)new PlayerModelHandler());
        if (GunMod.controllableLoaded) {
            MinecraftForge.EVENT_BUS.register((Object)new ControllerHandler());
            GunButtonBindings.register();
        }
        ClientHandler.setupRenderLayers();
        ClientHandler.registerColors();
        ClientHandler.registerModelOverrides();
        ClientHandler.registerScreenFactories();
    }

    private static void setupRenderLayers() {
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.WORKBENCH.get()), (RenderType)RenderType.m_110463_());
    }

    private static void registerColors() {
        ItemColor color = (stack, index) -> {
            ItemStack renderingWeapon;
            if (!IColored.isDyeable(stack)) {
                return -1;
            }
            if (index == 0 && stack.m_41782_() && stack.m_41783_().m_128425_("Color", 3)) {
                return stack.m_41783_().m_128451_("Color");
            }
            if (index == 0 && stack.m_41720_() instanceof IAttachment && (renderingWeapon = GunRenderingHandler.get().getRenderingWeapon()) != null) {
                return Minecraft.m_91087_().getItemColors().m_92676_(renderingWeapon, index);
            }
            if (index == 2) {
                return PropertyHelper.getReticleColor(stack);
            }
            return -1;
        };
        ForgeRegistries.ITEMS.forEach(item -> {
            if (item instanceof IColored) {
                Minecraft.m_91087_().getItemColors().m_92689_(color, new ItemLike[]{item});
            }
        });
    }

    private static void registerModelOverrides() {
        ModelOverrides.register((Item)ModItems.ASSAULT_RIFLE.get(), new SimpleModel(SpecialModels.ASSAULT_RIFLE::getModel));
        ModelOverrides.register((Item)ModItems.BAZOOKA.get(), new SimpleModel(SpecialModels.BAZOOKA::getModel));
        ModelOverrides.register((Item)ModItems.GRENADE_LAUNCHER.get(), new GrenadeLauncherModel());
        ModelOverrides.register((Item)ModItems.HEAVY_RIFLE.get(), new SimpleModel(SpecialModels.HEAVY_RIFLE::getModel));
        ModelOverrides.register((Item)ModItems.MACHINE_PISTOL.get(), new SimpleModel(SpecialModels.MACHINE_PISTOL::getModel));
        ModelOverrides.register((Item)ModItems.MINI_GUN.get(), new MiniGunModel());
        ModelOverrides.register((Item)ModItems.PISTOL.get(), new SimpleModel(SpecialModels.PISTOL::getModel));
        ModelOverrides.register((Item)ModItems.RIFLE.get(), new SimpleModel(SpecialModels.RIFLE::getModel));
        ModelOverrides.register((Item)ModItems.SHOTGUN.get(), new SimpleModel(SpecialModels.SHOTGUN::getModel));
    }

    private static void registerScreenFactories() {
        MenuScreens.m_96206_((MenuType)((MenuType)ModContainers.WORKBENCH.get()), WorkbenchScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModContainers.ATTACHMENTS.get()), AttachmentScreen::new);
    }

    @SubscribeEvent
    public static void onScreenInit(ScreenEvent.Init.Post event) {
        Screen screen = event.getScreen();
        if (screen instanceof MouseSettingsScreen) {
            MouseSettingsScreen screen2 = (MouseSettingsScreen)screen;
            if (mouseOptionsField == null) {
                mouseOptionsField = ObfuscationReflectionHelper.findField(MouseSettingsScreen.class, (String)"f_96218_");
                mouseOptionsField.setAccessible(true);
            }
            try {
                screen = (OptionsList)mouseOptionsField.get(screen2);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public static void onKeyPressed(InputEvent.Key event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null && mc.f_91080_ == null && event.getAction() == 1 && KeyBinds.KEY_ATTACHMENTS.m_90857_()) {
            PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageAttachments());
        }
    }

    public static void onRegisterReloadListener(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)((ResourceManagerReloadListener)manager -> PropertyHelper.resetCache()));
    }

    public static void registerAdditional(ModelEvent.RegisterAdditional event) {
        event.register(new ResourceLocation("cgm", "special/test"));
    }

    public static void onRegisterCreativeTab(CreativeModeTabEvent.Register event) {
        event.registerCreativeModeTab(new ResourceLocation("cgm", "creative_tab"), builder -> {
            builder.m_257941_((Component)Component.m_237115_((String)"itemGroup.cgm"));
            builder.m_257737_(() -> {
                ItemStack stack = new ItemStack((ItemLike)ModItems.PISTOL.get());
                stack.m_41784_().m_128379_("IgnoreAmmo", true);
                return stack;
            });
            builder.m_257501_((flags, output) -> {
                ModItems.REGISTER.getEntries().forEach(registryObject -> {
                    Object patt8944$temp = registryObject.get();
                    if (patt8944$temp instanceof GunItem) {
                        GunItem item = (GunItem)patt8944$temp;
                        ItemStack stack = new ItemStack((ItemLike)item);
                        stack.m_41784_().m_128405_("AmmoCount", item.getGun().getGeneral().getMaxAmmo());
                        output.m_246342_(stack);
                        return;
                    }
                    output.m_246326_((ItemLike)registryObject.get());
                });
                CustomGunManager.fill(output);
                for (Enchantment enchantment : ForgeRegistries.ENCHANTMENTS) {
                    if (enchantment.f_44672_ != EnchantmentTypes.GUN && enchantment.f_44672_ != EnchantmentTypes.SEMI_AUTO_GUN) continue;
                    output.m_246267_(EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance(enchantment, enchantment.m_6586_())), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
                }
            });
        });
    }

    public static Screen createEditorScreen(IEditorMenu menu) {
        return new EditorScreen(Minecraft.m_91087_().f_91080_, menu);
    }
}

