/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.mojang.brigadier.CommandDispatcher;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.block.DispenserBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.command.CommandSource;
import net.minecraft.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootConditionType;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.champions.api.IChampionsApi;
import top.theillusivec4.champions.api.impl.ChampionsApiImpl;
import top.theillusivec4.champions.client.ClientEventHandler;
import top.theillusivec4.champions.client.affix.ClientAffixEventsHandler;
import top.theillusivec4.champions.client.config.ClientChampionsConfig;
import top.theillusivec4.champions.client.renderer.ChampionsRenderer;
import top.theillusivec4.champions.common.affix.core.AffixManager;
import top.theillusivec4.champions.common.capability.ChampionCapability;
import top.theillusivec4.champions.common.config.ChampionsConfig;
import top.theillusivec4.champions.common.item.ChampionEggItem;
import top.theillusivec4.champions.common.loot.EntityIsChampion;
import top.theillusivec4.champions.common.network.NetworkHandler;
import top.theillusivec4.champions.common.rank.RankManager;
import top.theillusivec4.champions.common.registry.ChampionsRegistry;
import top.theillusivec4.champions.common.util.EntityManager;
import top.theillusivec4.champions.server.command.ChampionsCommand;

@Mod(value="champions")
public class Champions {
    public static final String MODID = "champions";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final IChampionsApi API = ChampionsApiImpl.getInstance();
    public static boolean gameStagesLoaded = false;

    public Champions() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, ClientChampionsConfig.CLIENT_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, ChampionsConfig.SERVER_SPEC);
        Champions.createServerConfig(ChampionsConfig.RANKS_SPEC, "ranks");
        Champions.createServerConfig(ChampionsConfig.AFFIXES_SPEC, "affixes");
        Champions.createServerConfig(ChampionsConfig.ENTITIES_SPEC, "entities");
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(this::config);
        eventBus.addListener(this::setup);
        eventBus.addListener(this::clientSetup);
        eventBus.addListener(this::postSetup);
        MinecraftForge.EVENT_BUS.addListener(this::registerCommands);
        gameStagesLoaded = ModList.get().isLoaded("gamestages");
    }

    private void setup(FMLCommonSetupEvent evt) {
        ChampionCapability.register();
        NetworkHandler.register();
        AffixManager.register();
        DeferredWorkQueue.runLater(() -> {
            LootConditionType cfr_ignored_0 = (LootConditionType)Registry.func_218322_a((Registry)Registry.field_239704_ba_, (ResourceLocation)new ResourceLocation(MODID, "entity_champion"), (Object)EntityIsChampion.type);
        });
    }

    private void clientSetup(FMLClientSetupEvent evt) {
        MinecraftForge.EVENT_BUS.register((Object)new ClientEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ClientAffixEventsHandler());
        Minecraft.func_71410_x().getItemColors().func_199877_a(ChampionEggItem::getColor, new IItemProvider[]{ChampionsRegistry.EGG});
        ChampionsRenderer.register();
    }

    private void postSetup(FMLLoadCompleteEvent evt) {
        DefaultDispenseItemBehavior dispenseBehavior = new DefaultDispenseItemBehavior(){

            @Nonnull
            public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                Direction direction = (Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a);
                Optional<EntityType<?>> entitytype = ChampionEggItem.getType(stack);
                entitytype.ifPresent(type -> {
                    Entity entity = type.func_220349_b(source.func_197524_h(), stack.func_77978_p(), null, null, source.func_180699_d().func_177972_a(direction), SpawnReason.DISPENSER, true, direction != Direction.UP);
                    if (entity instanceof LivingEntity) {
                        ChampionCapability.getCapability((LivingEntity)entity).ifPresent(champion -> ChampionEggItem.read(champion, stack));
                        source.func_197524_h().func_217376_c(entity);
                        stack.func_190918_g(1);
                    }
                });
                return stack;
            }
        };
        DispenserBlock.func_199774_a((IItemProvider)ChampionsRegistry.EGG, (IDispenseItemBehavior)dispenseBehavior);
    }

    private void registerCommands(RegisterCommandsEvent evt) {
        ChampionsCommand.register((CommandDispatcher<CommandSource>)evt.getDispatcher());
    }

    private void config(ModConfig.ModConfigEvent evt) {
        if (evt.getConfig().getModId().equals(MODID)) {
            if (evt.getConfig().getType() == ModConfig.Type.SERVER) {
                ChampionsConfig.bake();
                ForgeConfigSpec spec = evt.getConfig().getSpec();
                CommentedConfig commentedConfig = evt.getConfig().getConfigData();
                if (spec == ChampionsConfig.RANKS_SPEC) {
                    ChampionsConfig.transformRanks(commentedConfig);
                    RankManager.buildRanks();
                } else if (spec == ChampionsConfig.AFFIXES_SPEC) {
                    ChampionsConfig.transformAffixes(commentedConfig);
                    AffixManager.buildAffixSettings();
                } else if (spec == ChampionsConfig.ENTITIES_SPEC) {
                    ChampionsConfig.transformEntities(commentedConfig);
                    EntityManager.buildEntitySettings();
                }
            } else if (evt.getConfig().getType() == ModConfig.Type.CLIENT) {
                ClientChampionsConfig.bake();
            }
        }
    }

    private static void createServerConfig(ForgeConfigSpec spec, String suffix) {
        String fileName = "champions-" + suffix + ".toml";
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, spec, fileName);
        File defaults = new File(FMLPaths.GAMEDIR.get() + "/defaultconfigs/" + fileName);
        if (!defaults.exists()) {
            try {
                FileUtils.copyInputStreamToFile((InputStream)Objects.requireNonNull(Champions.class.getClassLoader().getResourceAsStream(fileName)), (File)defaults);
            }
            catch (IOException e) {
                LOGGER.error("Error creating default config for " + fileName);
            }
        }
    }
}

