/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.client.renderer;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.model.ShulkerBulletModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import top.theillusivec4.champions.common.entity.AbstractBulletEntity;

public class ColorizedBulletRenderer
extends EntityRenderer<AbstractBulletEntity> {
    private static final ResourceLocation GENERIC_SPARK_TEXTURE = new ResourceLocation("champions", "textures/entity/generic_spark.png");
    private static final RenderType renderType = RenderType.func_228644_e_((ResourceLocation)GENERIC_SPARK_TEXTURE);
    private final ShulkerBulletModel<AbstractBulletEntity> model = new ShulkerBulletModel();
    private final int color;

    public ColorizedBulletRenderer(EntityRendererManager manager, int color) {
        super(manager);
        this.color = color;
    }

    protected int getBlockLight(AbstractBulletEntity p_225624_1_, @Nonnull BlockPos blockPos) {
        return 15;
    }

    public void render(AbstractBulletEntity entity, float entityYaw, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight) {
        matrixStack.func_227860_a_();
        float lvt_7_1_ = MathHelper.func_226167_j_((float)entity.field_70126_B, (float)entity.field_70177_z, (float)partialTicks);
        float lvt_8_1_ = MathHelper.func_219799_g((float)partialTicks, (float)entity.field_70127_C, (float)entity.field_70125_A);
        float lvt_9_1_ = (float)entity.field_70173_aa + partialTicks;
        matrixStack.func_227861_a_(0.0, (double)0.15f, 0.0);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(MathHelper.func_76126_a((float)(lvt_9_1_ * 0.1f)) * 180.0f));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(MathHelper.func_76134_b((float)(lvt_9_1_ * 0.1f)) * 180.0f));
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(MathHelper.func_76126_a((float)(lvt_9_1_ * 0.15f)) * 360.0f));
        float r = (float)(this.color >> 16 & 0xFF) / 255.0f;
        float g = (float)(this.color >> 8 & 0xFF) / 255.0f;
        float b = (float)(this.color & 0xFF) / 255.0f;
        matrixStack.func_227862_a_(-0.5f, -0.5f, 0.5f);
        this.model.func_225597_a_((Entity)entity, 0.0f, 0.0f, 0.0f, lvt_7_1_, lvt_8_1_);
        IVertexBuilder lvt_10_1_ = buffer.getBuffer(this.model.func_228282_a_(GENERIC_SPARK_TEXTURE));
        this.model.func_225598_a_(matrixStack, lvt_10_1_, packedLight, OverlayTexture.field_229196_a_, r, g, b, 0.5f);
        matrixStack.func_227862_a_(1.5f, 1.5f, 1.5f);
        IVertexBuilder lvt_11_1_ = buffer.getBuffer(renderType);
        this.model.func_225598_a_(matrixStack, lvt_11_1_, packedLight, OverlayTexture.field_229196_a_, r, g, b, 0.15f);
        matrixStack.func_227865_b_();
        super.func_225623_a_((Entity)entity, entityYaw, partialTicks, matrixStack, buffer, packedLight);
    }

    @Nonnull
    public ResourceLocation getEntityTexture(@Nonnull AbstractBulletEntity entity) {
        return GENERIC_SPARK_TEXTURE;
    }
}

