/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.client.util;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import top.theillusivec4.champions.api.IChampion;
import top.theillusivec4.champions.client.config.ClientChampionsConfig;
import top.theillusivec4.champions.common.capability.ChampionCapability;

public class HUDHelper {
    private static final ResourceLocation GUI_BAR_TEXTURES = new ResourceLocation("textures/gui/bars.png");
    private static final ResourceLocation GUI_STAR = new ResourceLocation("champions", "textures/gui/staricon.png");

    public static boolean renderHealthBar(MatrixStack matrixStack, LivingEntity livingEntity) {
        return ChampionCapability.getCapability(livingEntity).map(champion -> {
            IChampion.Client clientChampion = champion.getClient();
            return clientChampion.getRank().map(rank -> {
                int num = (Integer)rank.func_76341_a();
                Set<String> affixSet = clientChampion.getAffixes();
                if (num > 0 || affixSet.size() > 0) {
                    String name;
                    int startStarsX;
                    Minecraft client = Minecraft.func_71410_x();
                    int i = client.func_228018_at_().func_198107_o();
                    int k = i / 2 - 91;
                    int j = 21;
                    int xOffset = ClientChampionsConfig.hudXOffset;
                    int yOffset = ClientChampionsConfig.hudYOffset;
                    int color = (Integer)rank.func_76340_b();
                    float r = (float)(color >> 16 & 0xFF) / 255.0f;
                    float g = (float)(color >> 8 & 0xFF) / 255.0f;
                    float b = (float)(color & 0xFF) / 255.0f;
                    RenderSystem.defaultBlendFunc();
                    RenderSystem.color4f((float)r, (float)g, (float)b, (float)1.0f);
                    RenderSystem.enableBlend();
                    client.func_110434_K().func_110577_a(GUI_BAR_TEXTURES);
                    HUDHelper.renderHealthBar(matrixStack, xOffset + k, yOffset + j, livingEntity.func_110143_aJ() / livingEntity.func_110138_aP());
                    client.func_110434_K().func_110577_a(GUI_STAR);
                    if (num <= 18) {
                        startStarsX = xOffset + i / 2 - 5 - 5 * (num - 1);
                        for (int tier = 0; tier < num; ++tier) {
                            AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)startStarsX, (int)(yOffset + 1), (float)0.0f, (float)0.0f, (int)9, (int)9, (int)9, (int)9);
                            startStarsX += 10;
                        }
                    } else {
                        startStarsX = xOffset + i / 2 - 5;
                        String count = "x" + num;
                        AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)(startStarsX - client.field_71466_p.func_78256_a(count) / 2), (int)(yOffset + 1), (float)0.0f, (float)0.0f, (int)9, (int)9, (int)9, (int)9);
                        client.field_71466_p.func_238405_a_(matrixStack, count, (float)(startStarsX + 10) - (float)client.field_71466_p.func_78256_a(count) / 2.0f, (float)(yOffset + 2), 0xFFFFFF);
                    }
                    ITextComponent customName = livingEntity.func_200201_e();
                    if (customName == null) {
                        name = new TranslationTextComponent("rank.champions.title." + num).getString();
                        name = name + " " + livingEntity.func_200200_C_().getString();
                    } else {
                        name = customName.getString();
                    }
                    client.field_71466_p.func_238405_a_(matrixStack, name, (float)xOffset + (float)(i / 2 - client.field_71466_p.func_78256_a(name) / 2), (float)yOffset + (float)(j - 9), color);
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    StringBuilder builder = new StringBuilder();
                    for (String affix : affixSet) {
                        builder.append(new TranslationTextComponent("affix.champions." + affix).getString());
                        builder.append(" ");
                    }
                    String affixes = builder.toString().trim();
                    client.field_71466_p.func_238405_a_(matrixStack, affixes, (float)xOffset + (float)(i / 2 - client.field_71466_p.func_78256_a(affixes) / 2), (float)yOffset + (float)(j + 6), 0xFFFFFF);
                    RenderSystem.disableBlend();
                    return true;
                }
                return false;
            }).orElse(false);
        }).orElse(false);
    }

    private static void renderHealthBar(MatrixStack matrixStack, int x, int y, float percent) {
        AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)x, (int)y, (float)0.0f, (float)60.0f, (int)182, (int)5, (int)256, (int)256);
        int i = (int)(percent * 183.0f);
        if (i > 0) {
            AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)x, (int)y, (float)0.0f, (float)65.0f, (int)i, (int)5, (int)256, (int)256);
        }
    }
}

