/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.affix.core;

import net.minecraft.nbt.CompoundNBT;
import top.theillusivec4.champions.Champions;
import top.theillusivec4.champions.api.IChampion;

public abstract class AffixData {
    private IChampion champion;
    private String identifier;

    protected AffixData() {
    }

    public void readData(IChampion champion, String identifier) {
        this.champion = champion;
        this.identifier = identifier;
        this.readFromNBT(champion.getServer().getData(identifier));
    }

    public abstract void readFromNBT(CompoundNBT var1);

    public abstract CompoundNBT writeToNBT();

    public void saveData() {
        this.champion.getServer().setData(this.identifier, this.writeToNBT());
    }

    public static <T extends AffixData> T getData(IChampion champion, String id, Class<T> clazz) {
        AffixData data = null;
        try {
            data = (AffixData)clazz.newInstance();
            data.readData(champion, id);
        }
        catch (IllegalAccessException | InstantiationException e) {
            Champions.LOGGER.error("Error reading data from class " + clazz.toString());
        }
        return (T)data;
    }

    public static class IntegerData
    extends AffixData {
        public int num;

        @Override
        public void readFromNBT(CompoundNBT tag) {
            this.num = tag.func_74762_e("num");
        }

        @Override
        public CompoundNBT writeToNBT() {
            CompoundNBT compound = new CompoundNBT();
            compound.func_74768_a("num", this.num);
            return compound;
        }
    }

    public static class BooleanData
    extends AffixData {
        public boolean mode;

        @Override
        public void readFromNBT(CompoundNBT tag) {
            this.mode = tag.func_74767_n("mode");
        }

        @Override
        public CompoundNBT writeToNBT() {
            CompoundNBT compound = new CompoundNBT();
            compound.func_74757_a("mode", this.mode);
            return compound;
        }
    }
}

