/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.capability;

import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import top.theillusivec4.champions.api.IAffix;
import top.theillusivec4.champions.api.IChampion;
import top.theillusivec4.champions.common.capability.ChampionCapability;
import top.theillusivec4.champions.common.config.ChampionsConfig;
import top.theillusivec4.champions.common.network.NetworkHandler;
import top.theillusivec4.champions.common.network.SPacketSyncChampion;
import top.theillusivec4.champions.common.rank.Rank;
import top.theillusivec4.champions.common.rank.RankManager;
import top.theillusivec4.champions.common.util.ChampionBuilder;
import top.theillusivec4.champions.common.util.ChampionHelper;

public class CapabilityEventHandler {
    @SubscribeEvent
    public void attachCapabilities(AttachCapabilitiesEvent<Entity> evt) {
        Entity entity = (Entity)evt.getObject();
        if (ChampionHelper.isValidEntity(entity)) {
            evt.addCapability(ChampionCapability.ID, (ICapabilityProvider)ChampionCapability.createProvider((LivingEntity)entity));
        }
    }

    @SubscribeEvent
    public void onSpecialSpawn(LivingSpawnEvent.SpecialSpawn evt) {
        LivingEntity entity = evt.getEntityLiving();
        if (!entity.func_130014_f_().func_201670_d()) {
            ChampionCapability.getCapability(entity).ifPresent(champion -> {
                IChampion.Server serverChampion = champion.getServer();
                if (!serverChampion.getRank().isPresent()) {
                    if (!ChampionsConfig.championSpawners && evt.getSpawner() != null) {
                        serverChampion.setRank(RankManager.getLowestRank());
                    } else {
                        ChampionBuilder.spawn(champion);
                    }
                }
            });
        }
    }

    @SubscribeEvent
    public void startTracking(PlayerEvent.StartTracking evt) {
        Entity entity = evt.getTarget();
        PlayerEntity playerEntity = evt.getPlayer();
        if (entity instanceof LivingEntity && playerEntity instanceof ServerPlayerEntity) {
            ChampionCapability.getCapability((LivingEntity)entity).ifPresent(champion -> {
                IChampion.Server serverChampion = champion.getServer();
                NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)playerEntity), (Object)new SPacketSyncChampion(entity.func_145782_y(), serverChampion.getRank().map(Rank::getTier).orElse(0), serverChampion.getRank().map(Rank::getDefaultColor).orElse(0), serverChampion.getAffixes().stream().map(IAffix::getIdentifier).collect(Collectors.toSet())));
            });
        }
    }
}

