/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.loot;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.loot.ILootSerializer;
import net.minecraft.loot.LootConditionType;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameter;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.JSONUtils;
import top.theillusivec4.champions.common.capability.ChampionCapability;
import top.theillusivec4.champions.common.rank.Rank;

public class EntityIsChampion
implements ILootCondition {
    public static LootConditionType type = new LootConditionType((ILootSerializer)new Serializer());
    @Nullable
    private final Integer minTier;
    @Nullable
    private final Integer maxTier;
    private final LootContext.EntityTarget target;

    private EntityIsChampion(@Nullable Integer minTier, @Nullable Integer maxTier, LootContext.EntityTarget targetIn) {
        this.minTier = minTier;
        this.maxTier = maxTier;
        this.target = targetIn;
    }

    @Nonnull
    public Set<LootParameter<?>> func_215855_a() {
        return ImmutableSet.of((Object)this.target.func_216029_a());
    }

    public boolean test(LootContext context) {
        Entity entity = (Entity)context.func_216031_c(this.target.func_216029_a());
        if (entity == null) {
            return false;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            return ChampionCapability.getCapability(livingEntity).map(champion -> {
                int tier = champion.getServer().getRank().map(Rank::getTier).orElse(0);
                boolean aboveMin = this.minTier == null ? tier >= 1 : tier >= this.minTier;
                boolean belowMax = this.maxTier == null || tier <= this.maxTier;
                return aboveMin && belowMax;
            }).orElse(false);
        }
        return false;
    }

    @Nonnull
    public LootConditionType func_230419_b_() {
        return type;
    }

    public static class Serializer
    implements ILootSerializer<EntityIsChampion> {
        public void func_230424_a_(JsonObject json, EntityIsChampion value, JsonSerializationContext context) {
            json.addProperty("maxTier", (Number)value.maxTier);
            json.addProperty("minTier", (Number)value.minTier);
            json.add("entity", context.serialize((Object)value.target));
        }

        @Nonnull
        public EntityIsChampion func_230423_a_(JsonObject json, @Nonnull JsonDeserializationContext context) {
            Integer minTier = json.has("minTier") ? Integer.valueOf(JSONUtils.func_151203_m((JsonObject)json, (String)"minTier")) : null;
            Integer maxTier = json.has("maxTier") ? Integer.valueOf(JSONUtils.func_151203_m((JsonObject)json, (String)"maxTier")) : null;
            return new EntityIsChampion(minTier, maxTier, (LootContext.EntityTarget)JSONUtils.func_188174_a((JsonObject)json, (String)"entity", (JsonDeserializationContext)context, LootContext.EntityTarget.class));
        }
    }
}

