/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.rank;

import com.google.common.collect.ImmutableSortedMap;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import net.minecraft.potion.Effect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraftforge.registries.ForgeRegistries;
import top.theillusivec4.champions.Champions;
import top.theillusivec4.champions.api.IAffix;
import top.theillusivec4.champions.common.config.ChampionsConfig;
import top.theillusivec4.champions.common.config.RanksConfig;
import top.theillusivec4.champions.common.rank.Rank;

public class RankManager {
    private static final TreeMap<Integer, Rank> RANKS = new TreeMap();
    private static final Rank EMPTY_RANK = new Rank();

    public static ImmutableSortedMap<Integer, Rank> getRanks() {
        return ImmutableSortedMap.copyOf(RANKS);
    }

    @Nonnull
    public static Rank getRank(int tier) {
        Rank rank = RANKS.get(tier);
        if (rank != null) {
            return rank;
        }
        if (RANKS.isEmpty()) {
            return EMPTY_RANK;
        }
        return RANKS.firstEntry().getValue();
    }

    public static Rank getLowestRank() {
        return RANKS.isEmpty() ? EMPTY_RANK : RANKS.firstEntry().getValue();
    }

    public static Rank getHighestRank() {
        return RANKS.isEmpty() ? EMPTY_RANK : RANKS.lastEntry().getValue();
    }

    public static void buildRanks() {
        List<RanksConfig.RankConfig> ranks = ChampionsConfig.ranks;
        if (ranks == null) {
            return;
        }
        ranks.forEach(rank -> {
            try {
                Rank newRank = RankManager.getRankFromConfig(rank);
                RANKS.put(newRank.getTier(), newRank);
            }
            catch (IllegalArgumentException e) {
                Champions.LOGGER.error("Invalid attribute found while building rank, skipping...");
            }
        });
    }

    private static Rank getRankFromConfig(RanksConfig.RankConfig rank) throws IllegalArgumentException {
        if (rank.tier == null || rank.numAffixes == null || rank.chance == null || rank.defaultColor == null || rank.growthFactor == null || rank.effects == null || rank.presetAffixes == null) {
            throw new IllegalArgumentException("Missing rank attribute");
        }
        if (rank.tier < 0) {
            throw new IllegalArgumentException("Negative tier");
        }
        int tier = rank.tier;
        if (rank.numAffixes < 0) {
            throw new IllegalArgumentException("Negative number of affixes");
        }
        int numAffixes = rank.numAffixes;
        if (rank.chance <= 0.0) {
            throw new IllegalArgumentException("Non-positive chance");
        }
        double chance = rank.chance;
        int defaultColor = rank.defaultColor;
        if (rank.growthFactor < 0) {
            throw new IllegalArgumentException("Negative growth factor");
        }
        int growthFactor = rank.growthFactor;
        ArrayList<Tuple<Effect, Integer>> effects = new ArrayList<Tuple<Effect, Integer>>();
        rank.effects.forEach(effect -> {
            String[] parsed = effect.split(";");
            Effect found = (Effect)ForgeRegistries.POTIONS.getValue(new ResourceLocation(parsed[0]));
            if (found != null) {
                int amplifier = 0;
                if (parsed.length > 1) {
                    try {
                        amplifier = Integer.parseInt(parsed[1]);
                    }
                    catch (NumberFormatException e) {
                        Champions.LOGGER.error("Found invalid amplifier value for effect, setting to default 1");
                    }
                }
                effects.add(new Tuple((Object)found, (Object)amplifier));
            }
        });
        ArrayList<IAffix> presetAffixes = new ArrayList<IAffix>();
        rank.presetAffixes.forEach(affix -> Champions.API.getAffix((String)affix).ifPresent(presetAffixes::add));
        return new Rank(tier, numAffixes, growthFactor, (float)chance, defaultColor, effects, presetAffixes);
    }
}

