/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.util;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.tileentity.BeaconTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import top.theillusivec4.champions.Champions;
import top.theillusivec4.champions.common.config.ChampionsConfig;
import top.theillusivec4.champions.common.config.ConfigEnums;
import top.theillusivec4.champions.common.integration.gamestages.ChampionsStages;

public class ChampionHelper {
    public static boolean isValidEntity(Entity entity) {
        return entity instanceof LivingEntity && entity instanceof IMob;
    }

    public static boolean checkPotential(LivingEntity livingEntity) {
        return !ChampionHelper.nearActiveBeacon(livingEntity) && ChampionHelper.isValidDimension(livingEntity.func_130014_f_().func_234923_W_().getRegistryName()) && (!Champions.gameStagesLoaded || ChampionsStages.hasChampionStage(livingEntity));
    }

    private static boolean isValidDimension(ResourceLocation resourceLocation) {
        String dimension = resourceLocation.toString();
        if (ChampionsConfig.dimensionPermission == ConfigEnums.Permission.BLACKLIST) {
            return !ChampionsConfig.dimensionList.contains(dimension);
        }
        return ChampionsConfig.dimensionList.contains(dimension);
    }

    private static boolean nearActiveBeacon(LivingEntity livingEntity) {
        int range = ChampionsConfig.beaconProtectionRange;
        if (range <= 0) {
            return false;
        }
        for (TileEntity te : livingEntity.func_130014_f_().field_175730_i) {
            BeaconTileEntity beacon;
            BlockPos pos = te.func_174877_v();
            if (!(Math.sqrt(livingEntity.func_70092_e((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p())) <= (double)range) || !(te instanceof BeaconTileEntity) || (beacon = (BeaconTileEntity)te).func_191979_s() <= 0) continue;
            return true;
        }
        return false;
    }
}

