/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.server.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.BlockPosArgument;
import net.minecraft.command.arguments.EntitySummonArgument;
import net.minecraft.command.arguments.SuggestionProviders;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;
import top.theillusivec4.champions.api.IAffix;
import top.theillusivec4.champions.common.capability.ChampionCapability;
import top.theillusivec4.champions.common.item.ChampionEggItem;
import top.theillusivec4.champions.common.registry.ChampionsRegistry;
import top.theillusivec4.champions.common.util.ChampionBuilder;
import top.theillusivec4.champions.server.command.AffixArgument;

public class ChampionsCommand {
    public static final SuggestionProvider<CommandSource> MONSTER_ENTITIES = SuggestionProviders.func_197494_a((ResourceLocation)new ResourceLocation("champions", "monster_entities"), (context, builder) -> ISuggestionProvider.func_201725_a(ForgeRegistries.ENTITIES.getValues().stream().filter(type -> type.func_220339_d() == EntityClassification.MONSTER), (SuggestionsBuilder)builder, EntityType::func_200718_a, type -> new TranslationTextComponent(Util.func_200697_a((String)"entity", (ResourceLocation)EntityType.func_200718_a((EntityType)type)))));
    private static final DynamicCommandExceptionType UNKNOWN_ENTITY = new DynamicCommandExceptionType(type -> new TranslationTextComponent("command.champions.egg.unknown_entity", new Object[]{type}));

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        int opPermissionLevel = 2;
        LiteralArgumentBuilder championsCommand = (LiteralArgumentBuilder)Commands.func_197057_a((String)"champions").requires(player -> player.func_197034_c(2));
        championsCommand.then(Commands.func_197057_a((String)"egg").then(Commands.func_197056_a((String)"entity", (ArgumentType)EntitySummonArgument.func_211366_a()).suggests(MONSTER_ENTITIES).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"tier", (ArgumentType)IntegerArgumentType.integer()).executes(context -> ChampionsCommand.createEgg((CommandSource)context.getSource(), EntitySummonArgument.func_211368_a((CommandContext)context, (String)"entity"), IntegerArgumentType.getInteger((CommandContext)context, (String)"tier"), new ArrayList<IAffix>()))).then(Commands.func_197056_a((String)"affixes", (ArgumentType)AffixArgument.affix()).executes(context -> ChampionsCommand.createEgg((CommandSource)context.getSource(), EntitySummonArgument.func_211368_a((CommandContext)context, (String)"entity"), IntegerArgumentType.getInteger((CommandContext)context, (String)"tier"), AffixArgument.getAffixes((CommandContext<CommandSource>)context, "affixes")))))));
        championsCommand.then(Commands.func_197057_a((String)"summon").then(Commands.func_197056_a((String)"entity", (ArgumentType)EntitySummonArgument.func_211366_a()).suggests(MONSTER_ENTITIES).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"tier", (ArgumentType)IntegerArgumentType.integer()).executes(context -> ChampionsCommand.summon((CommandSource)context.getSource(), EntitySummonArgument.func_211368_a((CommandContext)context, (String)"entity"), IntegerArgumentType.getInteger((CommandContext)context, (String)"tier"), new ArrayList<IAffix>()))).then(Commands.func_197056_a((String)"affixes", (ArgumentType)AffixArgument.affix()).executes(context -> ChampionsCommand.summon((CommandSource)context.getSource(), EntitySummonArgument.func_211368_a((CommandContext)context, (String)"entity"), IntegerArgumentType.getInteger((CommandContext)context, (String)"tier"), AffixArgument.getAffixes((CommandContext<CommandSource>)context, "affixes")))))));
        championsCommand.then(Commands.func_197057_a((String)"summonpos").then(Commands.func_197056_a((String)"pos", (ArgumentType)BlockPosArgument.func_197276_a()).then(Commands.func_197056_a((String)"entity", (ArgumentType)EntitySummonArgument.func_211366_a()).suggests(MONSTER_ENTITIES).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"tier", (ArgumentType)IntegerArgumentType.integer()).executes(context -> ChampionsCommand.summon((CommandSource)context.getSource(), BlockPosArgument.func_197274_b((CommandContext)context, (String)"pos"), EntitySummonArgument.func_211368_a((CommandContext)context, (String)"entity"), IntegerArgumentType.getInteger((CommandContext)context, (String)"tier"), new ArrayList<IAffix>()))).then(Commands.func_197056_a((String)"affixes", (ArgumentType)AffixArgument.affix()).executes(context -> ChampionsCommand.summon((CommandSource)context.getSource(), BlockPosArgument.func_197274_b((CommandContext)context, (String)"pos"), EntitySummonArgument.func_211368_a((CommandContext)context, (String)"entity"), IntegerArgumentType.getInteger((CommandContext)context, (String)"tier"), AffixArgument.getAffixes((CommandContext<CommandSource>)context, "affixes"))))))));
        dispatcher.register(championsCommand);
    }

    private static int summon(CommandSource source, ResourceLocation resourceLocation, int tier, Collection<IAffix> affixes) throws CommandSyntaxException {
        return ChampionsCommand.summon(source, null, resourceLocation, tier, affixes);
    }

    private static int summon(CommandSource source, @Nullable BlockPos pos, ResourceLocation resourceLocation, int tier, Collection<IAffix> affixes) throws CommandSyntaxException {
        EntityType entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(resourceLocation);
        if (entityType == null) {
            throw UNKNOWN_ENTITY.create((Object)resourceLocation);
        }
        Entity entity = entityType.func_220349_b(source.func_197023_e(), null, null, null, pos != null ? pos : new BlockPos(source.func_197036_d()), SpawnReason.COMMAND, false, false);
        if (entity instanceof LivingEntity) {
            ChampionCapability.getCapability((LivingEntity)entity).ifPresent(champion -> ChampionBuilder.spawnPreset(champion, tier, new ArrayList<IAffix>(affixes)));
            source.func_197023_e().func_217376_c(entity);
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.champions.summon.success", new Object[]{new TranslationTextComponent("rank.champions.title." + tier).getString() + " " + entity.func_145748_c_().getString()}), true);
        }
        return 1;
    }

    private static int createEgg(CommandSource source, ResourceLocation resourceLocation, int tier, Collection<IAffix> affixes) throws CommandSyntaxException {
        EntityType entity = (EntityType)ForgeRegistries.ENTITIES.getValue(resourceLocation);
        if (entity == null) {
            throw UNKNOWN_ENTITY.create((Object)resourceLocation);
        }
        if (source.func_197022_f() instanceof ServerPlayerEntity) {
            ServerPlayerEntity playerEntity = (ServerPlayerEntity)source.func_197022_f();
            ItemStack egg = new ItemStack((IItemProvider)ChampionsRegistry.EGG);
            ChampionEggItem.write(egg, resourceLocation, tier, affixes);
            ItemHandlerHelper.giveItemToPlayer((PlayerEntity)playerEntity, (ItemStack)egg, (int)playerEntity.field_71071_by.field_70461_c);
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.champions.egg.success", new Object[]{egg.func_200301_q()}), true);
        }
        return 1;
    }
}

