/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.defaultRewards;

import chanceCubes.rewards.defaultRewards.BossBaseReward;
import chanceCubes.util.RewardsUtil;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import java.util.Map;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.monster.BlazeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.SmallFireballEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class BossBlazeReward
extends BossBaseReward {
    public BossBlazeReward() {
        super("demonic_blaze");
    }

    @Override
    public void spawnBoss(final ServerWorld world, BlockPos pos, final PlayerEntity player, Map<String, Object> settings) {
        final BlazeEntity blaze = (BlazeEntity)EntityType.field_200792_f.func_200721_a((World)world);
        blaze.func_200203_b((ITextComponent)new StringTextComponent("Demonic Blaze"));
        blaze.func_70634_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        blaze.func_110148_a(Attributes.field_233818_a_).func_111128_a(this.getBossHealthDynamic(player, settings));
        blaze.func_70606_j(blaze.func_110138_aP());
        Scheduler.scheduleTask(new Task("blaze_abilities", -1, 20){

            @Override
            public void callback() {
            }

            @Override
            public void update() {
                if (!blaze.func_70089_S()) {
                    Scheduler.removeTask(this);
                    return;
                }
                if (RewardsUtil.rand.nextInt(10) == 4) {
                    BossBlazeReward.this.goInvisible(blaze);
                }
                if (RewardsUtil.rand.nextInt(10) == 4) {
                    BossBlazeReward.this.setGroundOnFire((World)world, player.func_233580_cy_());
                }
                if (RewardsUtil.rand.nextInt(3) == 4) {
                    BossBlazeReward.this.shootFireballs((World)world, blaze, player);
                }
            }
        });
        world.func_217376_c((Entity)blaze);
        super.trackEntities(new Entity[]{blaze});
        super.trackedPlayers(player);
    }

    private void goInvisible(BlazeEntity blaze) {
        blaze.func_195064_c(new EffectInstance(Effects.field_76441_p, 5));
    }

    private void setGroundOnFire(World world, BlockPos playerPos) {
        for (int xOff = -1; xOff <= 1; ++xOff) {
            for (int zOff = -1; zOff <= 1; ++zOff) {
                BlockPos offPos = playerPos.func_177982_a(xOff, 0, zOff);
                RewardsUtil.placeBlock(Blocks.field_150480_ab.func_176223_P(), world, offPos);
            }
        }
    }

    private void shootFireballs(World world, BlazeEntity blaze, PlayerEntity player) {
        double d1 = player.func_226277_ct_() - blaze.func_226277_ct_();
        double d2 = player.func_174813_aQ().field_72338_b + (double)(player.func_213302_cg() / 2.0f) - (blaze.func_226278_cu_() + (double)(blaze.func_213302_cg() / 2.0f));
        double d3 = player.func_226281_cx_() - blaze.func_226281_cx_();
        for (int i = 0; i < 5; ++i) {
            SmallFireballEntity entitysmallfireball = new SmallFireballEntity(world, (LivingEntity)blaze, d1 + blaze.func_70681_au().nextGaussian(), d2, d3 + blaze.func_70681_au().nextGaussian());
            entitysmallfireball.func_233580_cy_().func_177963_a(0.0, blaze.func_226278_cu_() + (double)(blaze.func_213302_cg() / 2.0f) + 0.5, 0.0);
            world.func_217376_c((Entity)entitysmallfireball);
        }
    }

    @Override
    public void onBossFightEnd(ServerWorld world, BlockPos pos, PlayerEntity player) {
    }
}

