/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.defaultRewards;

import chanceCubes.CCubesCore;
import chanceCubes.blocks.CCubesBlocks;
import chanceCubes.config.CCubesSettings;
import chanceCubes.parsers.RewardParser;
import chanceCubes.registry.global.GlobalCCRewardRegistry;
import chanceCubes.registry.player.PlayerCCRewardRegistry;
import chanceCubes.rewards.defaultRewards.BaseCustomReward;
import chanceCubes.rewards.defaultRewards.BasicReward;
import chanceCubes.rewards.defaultRewards.StreamerReward;
import chanceCubes.util.CustomEntry;
import chanceCubes.util.HTTPUtil;
import chanceCubes.util.RewardsUtil;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.UsernameCache;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;
import org.apache.logging.log4j.Level;

public class CustomUserReward
extends BaseCustomReward {
    private String userName;
    private UUID uuid;
    private String type;
    private List<BasicReward> customRewards;

    public static void getCustomUserReward(UUID uuid) {
        JsonObject contentCreatorStuff;
        JsonElement userRewards;
        JsonElement users;
        if (!((Boolean)CCubesSettings.userSpecificRewards.get()).booleanValue()) {
            return;
        }
        try {
            users = HTTPUtil.getWebFile("GET", "https://api.theprogrammingturkey.com/chance_cubes/custom_rewards/UserList.json", new CustomEntry[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            CCubesCore.logger.log(Level.ERROR, "Chance Cubes failed to get the list of users with custom rewards!");
            return;
        }
        String userName = "";
        String type = "";
        String twitch = "";
        for (JsonElement userElem : users.getAsJsonArray()) {
            JsonObject user = userElem.getAsJsonObject();
            if (!user.get("UUID").getAsString().equalsIgnoreCase(uuid.toString())) continue;
            userName = user.get("Name").getAsString();
            type = user.get("Type").getAsString();
            if (!user.has("Twitch")) continue;
            twitch = user.get("Twitch").getAsString();
        }
        if (userName.equals("")) {
            CCubesCore.logger.log(Level.INFO, "No custom rewards detected for the current user!");
            return;
        }
        try {
            userRewards = HTTPUtil.getWebFile("GET", "https://api.theprogrammingturkey.com/chance_cubes/custom_rewards/users/" + userName + ".json", new CustomEntry[0]);
            contentCreatorStuff = HTTPUtil.getWebFile("GET", "https://api.theprogrammingturkey.com/chance_cubes/custom_rewards/ContentCreators.json", new CustomEntry[0]).getAsJsonObject();
        }
        catch (Exception e) {
            CCubesCore.logger.log(Level.ERROR, "Chance Cubes failed to get the custom list for " + userName + "!");
            CCubesCore.logger.log(Level.ERROR, e.getMessage());
            return;
        }
        ArrayList<BasicReward> customRewards = new ArrayList<BasicReward>();
        for (Map.Entry reward : userRewards.getAsJsonObject().entrySet()) {
            customRewards.add(RewardParser.parseReward(reward).getKey());
        }
        String userNameFinal = userName;
        String typeFinal = type;
        String twitchFinal = twitch;
        MinecraftServer server = (MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
        server.execute(() -> {
            GlobalCCRewardRegistry.DEFAULT.registerReward(new CustomUserReward(userNameFinal, uuid, typeFinal, customRewards));
            GlobalCCRewardRegistry.DEFAULT.getPlayerRewardRegistry(uuid.toString()).enableReward("chancecubes:cr_" + userNameFinal);
            ServerPlayerEntity player = server.func_184103_al().func_177451_a(uuid);
            if (player == null) {
                return;
            }
            Style ccStyle = Style.field_240709_b_.func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.DARK_AQUA));
            if (contentCreatorStuff.get("Active").getAsBoolean() && !twitchFinal.trim().equals("")) {
                PlayerCCRewardRegistry.streamerReward.put(uuid, new StreamerReward(twitchFinal, contentCreatorStuff.get("T").getAsString(), contentCreatorStuff.getAsJsonArray("Options")));
            }
            if (contentCreatorStuff.get("Messages").getAsJsonArray().size() > 0) {
                for (JsonElement messageElem : contentCreatorStuff.get("Messages").getAsJsonArray()) {
                    String message = messageElem.getAsJsonObject().get("message").getAsString();
                    message = message.replace("%username%", userNameFinal);
                    RewardsUtil.sendMessageToPlayer((PlayerEntity)player, (ITextComponent)new StringTextComponent(message).func_230530_a_(ccStyle));
                }
            } else {
                RewardsUtil.sendMessageToPlayer((PlayerEntity)player, (ITextComponent)new StringTextComponent("Seems you have some custom Chance Cubes rewards " + userNameFinal + "....").func_230530_a_(ccStyle));
                RewardsUtil.sendMessageToPlayer((PlayerEntity)player, (ITextComponent)new StringTextComponent("Let the fun begin! >:)").func_230530_a_(ccStyle));
            }
        });
    }

    public CustomUserReward(String un, UUID uuid, String type, List<BasicReward> rewards) {
        super("chancecubes:cr_" + un, 0);
        this.userName = un;
        this.uuid = uuid;
        this.type = type;
        this.customRewards = rewards;
    }

    @Override
    public void trigger(final ServerWorld world, final BlockPos pos, final PlayerEntity player, final Map<String, Object> settings) {
        if (!UsernameCache.getLastKnownUsername((UUID)this.uuid).equalsIgnoreCase(player.func_200200_C_().func_150261_e())) {
            RewardsUtil.sendMessageToPlayer(player, "Hey you aren't " + this.userName + "! You can't have their reward! Try again!");
            ItemEntity itemEnt = new ItemEntity((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), new ItemStack((IItemProvider)CCubesBlocks.CHANCE_CUBE, 1));
            world.func_217376_c((Entity)itemEnt);
            return;
        }
        RewardsUtil.sendMessageToPlayer(player, "Selecting best (possibly deadly) reward for " + this.type + " " + this.userName);
        Scheduler.scheduleTask(new Task("Custom Reward", 100){

            @Override
            public void callback() {
                ((BasicReward)CustomUserReward.this.customRewards.get(world.field_73012_v.nextInt(CustomUserReward.this.customRewards.size()))).trigger(world, pos, player, settings);
            }
        });
    }

    public UUID getUuid() {
        return this.uuid;
    }
}

