/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.chesttracker;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import red.jackf.chesttracker.tracker.Location;

@Environment(value=EnvType.CLIENT)
public final class GsonHandler {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().serializeNulls().disableHtmlEscaping().registerTypeHierarchyAdapter(class_2561.class, (Object)new class_2561.class_2562()).registerTypeHierarchyAdapter(class_2583.class, (Object)new class_2583.class_2584()).registerTypeAdapter(new TypeToken<class_2338>(){}.getType(), (Object)new BlockPosSerializer()).registerTypeAdapter(new TypeToken<Location>(){}.getType(), (Object)new LocationSerializer()).registerTypeAdapter(new TypeToken<class_1799>(){}.getType(), (Object)new ItemStackSerializer()).create();

    private GsonHandler() {
    }

    public static Gson get() {
        return GSON;
    }

    private static class BlockPosSerializer
    implements JsonDeserializer<class_2338>,
    JsonSerializer<class_2338> {
        private BlockPosSerializer() {
        }

        public class_2338 deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject object = json.getAsJsonObject();
            return new class_2338(object.get("x").getAsInt(), object.get("y").getAsInt(), object.get("z").getAsInt());
        }

        public JsonElement serialize(class_2338 src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject object = new JsonObject();
            object.addProperty("x", (Number)src.method_10263());
            object.addProperty("y", (Number)src.method_10264());
            object.addProperty("z", (Number)src.method_10260());
            return object;
        }
    }

    private static class ItemStackSerializer
    implements JsonDeserializer<class_1799>,
    JsonSerializer<class_1799> {
        private ItemStackSerializer() {
        }

        public class_1799 deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject object = json.getAsJsonObject();
            try {
                return class_1799.method_7915((class_2487)class_2522.method_10718((String)object.get("stack").getAsString()));
            }
            catch (Exception e) {
                throw new JsonParseException("Could not read item tag", (Throwable)e);
            }
        }

        public JsonElement serialize(class_1799 src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject object = new JsonObject();
            object.addProperty("stack", src.method_7953(new class_2487()).toString());
            return object;
        }
    }

    private static class LocationSerializer
    implements JsonDeserializer<Location>,
    JsonSerializer<Location> {
        private LocationSerializer() {
        }

        public Location deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject object = json.getAsJsonObject();
            class_2338 pos = (class_2338)GSON.fromJson((JsonElement)object.getAsJsonObject("position"), class_2338.class);
            class_2561 name = object.has("name") ? (class_2561)GSON.fromJson((JsonElement)object.getAsJsonObject("name"), class_2561.class) : null;
            List<class_1799> items = (List<class_1799>)GSON.fromJson((JsonElement)object.getAsJsonArray("items"), new TypeToken<List<class_1799>>(){}.getType());
            class_243 nameOffset = object.has("nameOffset") ? (class_243)GSON.fromJson((JsonElement)object.getAsJsonObject("nameOffset"), class_243.class) : null;
            Boolean favourite = (Boolean)GSON.fromJson((JsonElement)object.getAsJsonPrimitive("favourite"), Boolean.class);
            items = items.stream().filter(Objects::nonNull).collect(Collectors.toList());
            return new Location(pos, name, nameOffset, items, favourite);
        }

        public JsonElement serialize(Location src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject object = new JsonObject();
            object.add("position", GSON.toJsonTree((Object)src.getPosition()));
            if (src.getName() != null) {
                object.add("name", GSON.toJsonTree((Object)src.getName()));
            }
            object.add("items", GSON.toJsonTree(src.getItems()));
            if (src.getNameOffset() != null) {
                object.add("nameOffset", GSON.toJsonTree((Object)src.getNameOffset()));
            }
            object.add("favourite", GSON.toJsonTree((Object)src.isFavourite()));
            return object;
        }
    }
}

