/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.chesttracker.config;

import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_465;
import red.jackf.chesttracker.config.ButtonDisplayTypeFunctions;

@Environment(value=EnvType.CLIENT)
public enum ButtonDisplayType {
    ABOVE_RIGHT(ButtonDisplayTypeFunctions.rightX, ButtonDisplayTypeFunctions.aboveY, false),
    ABOVE_LEFT(ButtonDisplayTypeFunctions.leftX, ButtonDisplayTypeFunctions.aboveY, false),
    TOP_RIGHT(ButtonDisplayTypeFunctions.rightX, ButtonDisplayTypeFunctions.topY, false),
    MIDDLE_RIGHT(FabricLoader.getInstance().isModLoaded("inventoryprofiles") ? ButtonDisplayTypeFunctions.rightXInvProfShift : ButtonDisplayTypeFunctions.rightX, ButtonDisplayTypeFunctions.middleY, false),
    BOTTOM_RIGHT(ButtonDisplayTypeFunctions.rightX, ButtonDisplayTypeFunctions.bottomRightY, false),
    BOTTOM_LEFT(ButtonDisplayTypeFunctions.leftX, ButtonDisplayTypeFunctions.bottomLeftY, false),
    TOP_LEFT_VERTICAL(ButtonDisplayTypeFunctions.leftVertX, ButtonDisplayTypeFunctions.topLeftVertY, true),
    BOTTOM_LEFT_VERTICAL(ButtonDisplayTypeFunctions.leftVertX, ButtonDisplayTypeFunctions.bottomLeftVertY, true);

    private final Function<class_465<?>, Integer> getX;
    private final Function<class_465<?>, Integer> getY;
    private final boolean vertical;

    private ButtonDisplayType(Function<class_465<?>, Integer> getX, Function<class_465<?>, Integer> getY, boolean vertical) {
        this.getX = getX;
        this.getY = getY;
        this.vertical = vertical;
    }

    public int getX(class_465<?> screen) {
        return this.getX.apply(screen);
    }

    public int getY(class_465<?> screen) {
        return this.getY.apply(screen);
    }

    public boolean isVertical() {
        return this.vertical;
    }

    public static ButtonDisplayType getAppropriateDefault() {
        FabricLoader loader = FabricLoader.getInstance();
        if (loader.isModLoaded("inventoryprofiles")) {
            if (loader.isModLoaded("techreborn")) {
                return BOTTOM_LEFT_VERTICAL;
            }
            return TOP_LEFT_VERTICAL;
        }
        return TOP_RIGHT;
    }
}

