/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.chesttracker.gui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import red.jackf.chesttracker.gui.WClearedTextField;
import red.jackf.chesttracker.gui.WGhostSlot;
import red.jackf.chesttracker.tracker.Location;
import red.jackf.chesttracker.tracker.LocationStorage;
import spinnery.client.screen.BaseScreen;
import spinnery.widget.WAbstractWidget;
import spinnery.widget.WButton;
import spinnery.widget.WInterface;
import spinnery.widget.WPanel;
import spinnery.widget.WTextField;
import spinnery.widget.WVerticalScrollableContainer;
import spinnery.widget.api.Color;
import spinnery.widget.api.Position;
import spinnery.widget.api.Size;
import spinnery.widget.api.WPositioned;

@Environment(value=EnvType.CLIENT)
public class ItemManagerScreen
extends BaseScreen {
    private final int width = 178;
    private final int height = 167;
    private final WPanel mainPanel;
    private final WVerticalScrollableContainer scrollArea;
    private final WButton resetButton;
    private List<class_1799> list;
    private final WTextField searchField;
    private final WButton verifyButton;
    private boolean resetConfirm = false;
    private final Color RED = Color.of((Number)(class_124.field_1061.method_532() != null ? class_124.field_1061.method_532() : -8421377));
    private final Color DEFAULT = new Color(255, 255, 255, 255);

    public ItemManagerScreen() {
        WInterface mainInterface = this.getInterface();
        this.mainPanel = (WPanel)((WPanel)mainInterface.createChild(WPanel::new, Position.ORIGIN, Size.of((float)178.0f, (float)167.0f))).setLabel((class_2561)new class_2588("chesttracker.gui.title"));
        this.mainPanel.center();
        this.mainPanel.setPosition(this.mainPanel.getPosition().add(-6.0f, 0.0f, 0.0f));
        this.scrollArea = ((WVerticalScrollableContainer)this.mainPanel.createChild(WVerticalScrollableContainer::new, Position.of((WPositioned)this.mainPanel).add(3.0f, 22.0f, 0.0f), Size.of((float)182.0f, (float)141.0f))).setDivisionSpace(1.0f).setHasFade(false).setScrollbarWidth(8.0f);
        this.searchField = (WTextField)this.mainPanel.createChild(WClearedTextField::new, Position.of((float)(this.mainPanel.getX() + 178.0f - 98.0f), (float)(this.mainPanel.getY() + 4.0f), (float)0.0f), Size.of((float)94.0f, (float)18.0f));
        this.searchField.setFixedLength(Integer.valueOf(15));
        this.searchField.setText("Filter...");
        this.searchField.setOnMouseClicked((widget, mouseX, mouseY, mouseButton) -> this.update());
        this.verifyButton = (WButton)this.mainPanel.createChild(WButton::new, Position.of((WPositioned)this.mainPanel).add(2.0f, -16.0f, 0.0f), Size.of((float)60.0f, (float)13.0f));
        this.verifyButton.setLabel((class_2561)new class_2588("chesttracker.gui.verify_button"));
        this.resetButton = (WButton)this.mainPanel.createChild(WButton::new, Position.of((WPositioned)this.mainPanel).add(72.0f, -16.0f, 0.0f), Size.of((float)60.0f, (float)13.0f));
        this.resetButton.setLabel((class_2561)new class_2588("chesttracker.gui.reset_button"));
        LocationStorage storage = LocationStorage.get();
        this.resetButton.setOnMouseClicked((widget, mouseX, mouseY, mouseButton) -> {
            if (this.resetConfirm) {
                this.resetConfirm = false;
                if (storage != null) {
                    LocationStorage.WorldStorage worldStorage = storage.getStorage(class_310.method_1551().field_1687.method_27983().method_29177());
                    if (class_437.method_25442()) {
                        worldStorage.clear();
                    } else {
                        worldStorage.removeIf((Predicate<? super Location>)((Predicate<Location>)location -> location.isFavourite() == false));
                    }
                    this.list = worldStorage.getItems();
                    this.update();
                }
            } else {
                this.resetConfirm = true;
            }
        });
        if (storage != null) {
            LocationStorage.WorldStorage worldStorage = storage.getStorage(class_310.method_1551().field_1687.method_27983().method_29177());
            this.list = worldStorage.getItems();
            this.verifyButton.setOnMouseClicked((widget, mouseX, mouseY, mouseButton) -> {
                if (mouseButton == 0) {
                    worldStorage.verify();
                    this.list = worldStorage.getItems();
                    this.update();
                }
            });
        } else {
            this.list = Collections.EMPTY_LIST;
        }
        this.searchField.setOnCharTyped((widget, charTyped, keycode) -> this.update());
        this.searchField.setOnKeyPressed((widget, keyPressed, character, keyModifier) -> {
            switch (keyPressed) {
                case 259: 
                case 261: {
                    this.update();
                }
            }
        });
        this.setChildren(this.list);
    }

    private void update() {
        List<class_1799> stacks = this.list.stream().filter(stack -> stack.method_7964().getString().toLowerCase().contains(this.searchField.getText().toLowerCase())).collect(Collectors.toList());
        this.setChildren(stacks);
    }

    private void setChildren(List<class_1799> slots) {
        this.scrollArea.getWidgets().clear();
        if (slots.size() == 0) {
            return;
        }
        ArrayList<WGhostSlot> tempSlots = new ArrayList<WGhostSlot>(9);
        for (int i = 0; i < slots.size(); ++i) {
            WGhostSlot slot = new WGhostSlot(slots.get(i), Position.of((WPositioned)Position.ORIGIN), this.scrollArea);
            tempSlots.add(slot);
            if (tempSlots.size() != 9 && i != slots.size() - 1) continue;
            this.scrollArea.addRow((WAbstractWidget[])tempSlots.toArray(new WGhostSlot[0]));
            tempSlots.clear();
        }
    }

    public int getX() {
        return (int)this.mainPanel.getX();
    }

    public int getY() {
        return (int)this.mainPanel.getY();
    }

    public int getWidth() {
        return 185;
    }

    public int getHeight() {
        return 167;
    }

    public void method_25410(class_310 client, int width, int height) {
        super.method_25410(client, width, height);
        this.mainPanel.center();
        this.mainPanel.setPosition(this.mainPanel.getPosition().add(-6.0f, 0.0f, 0.0f));
        this.searchField.setPosition(Position.of((float)(this.mainPanel.getX() + (float)width - 98.0f), (float)(this.mainPanel.getY() + 4.0f), (float)100.0f));
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float tick) {
        List tooltip;
        super.method_25394(matrices, mouseX, mouseY, tick);
        this.scrollArea.getWidgets().forEach(w -> {
            if (w instanceof WGhostSlot) {
                WGhostSlot slot = (WGhostSlot)((Object)w);
                if (w.isWithinBounds((float)mouseX, (float)mouseY) && this.scrollArea.isWithinBounds((float)mouseX, (float)mouseY)) {
                    slot.hover = true;
                    this.method_25409(matrices, slot.item, mouseX, mouseY);
                } else {
                    slot.hover = false;
                }
            }
        });
        if (this.resetConfirm) {
            this.resetButton.setLabel((class_2561)new class_2588("chesttracker.gui.reset_button_confirm"));
        } else if (class_437.method_25442()) {
            this.resetButton.setLabel((class_2561)new class_2588("chesttracker.gui.reset_button_shift"));
        } else {
            this.resetButton.setLabel((class_2561)new class_2588("chesttracker.gui.reset_button"));
        }
        this.resetButton.overrideStyle("label.color", (Object)(class_437.method_25442() ? this.RED : this.DEFAULT));
        if (this.verifyButton.isWithinBounds((float)mouseX, (float)mouseY)) {
            tooltip = Arrays.stream(new class_2588("chesttracker.gui.verify_button_tooltip").getString().split("\n")).map(class_2585::new).collect(Collectors.toList());
            this.method_25417(matrices, tooltip, mouseX, mouseY);
        }
        if (this.resetButton.isWithinBounds((float)mouseX, (float)mouseY)) {
            tooltip = Arrays.stream(new class_2588(this.resetConfirm ? "chesttracker.gui.reset_button_confirm_tooltip" : (class_437.method_25442() ? "chesttracker.gui.reset_button_tooltip_shift" : "chesttracker.gui.reset_button_tooltip")).getString().split("\n")).map(class_2585::new).collect(Collectors.toList());
            this.method_25417(matrices, tooltip, mouseX, mouseY);
        }
    }

    public boolean method_25404(int keyCode, int character, int keyModifier) {
        if (super.method_25404(keyCode, character, keyModifier)) {
            return true;
        }
        if (!this.searchField.isActive() && class_310.method_1551().field_1690.field_1822.method_1417(keyCode, character)) {
            if (class_310.method_1551().field_1724 != null) {
                class_310.method_1551().field_1724.method_7346();
            }
            return true;
        }
        return true;
    }
}

