/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.chesttracker.render;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.stream.Collectors;
import net.minecraft.class_1159;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4668;
import net.minecraft.class_5348;
import red.jackf.chesttracker.ChestTracker;
import red.jackf.chesttracker.mixins.AccessorRenderPhase;
import red.jackf.chesttracker.tracker.LinkedBlocksHandler;
import red.jackf.chesttracker.tracker.Location;
import red.jackf.chesttracker.tracker.LocationStorage;

public class RenderManager {
    private static final RenderManager INSTANCE = new RenderManager();
    private final List<PositionData> positionsToRender = new ArrayList<PositionData>();
    public static final Map<class_265, List<class_238>> CACHED_SHAPES = new HashMap<class_265, List<class_238>>();

    public static RenderManager getInstance() {
        return INSTANCE;
    }

    private RenderManager() {
    }

    public void addRenderList(List<Location> newList, long time) {
        this.positionsToRender.addAll(newList.stream().map(loc -> {
            double x = loc.getPosition().method_10263();
            double y = loc.getPosition().method_10264();
            double z = loc.getPosition().method_10260();
            return new PositionData(time, loc.getPosition(), class_310.method_1551().field_1687 != null ? this.getShapeFromList(LinkedBlocksHandler.getLinked((class_1937)class_310.method_1551().field_1687, loc.getPosition())).method_1096(-x, -y, -z).method_1097() : class_259.method_1077());
        }).collect(Collectors.toList()));
    }

    private class_265 getShapeFromList(List<class_2338> locations) {
        class_265 base = class_259.method_1073();
        for (class_2338 pos : locations) {
            base = class_259.method_1084((class_265)base, (class_265)class_259.method_1077().method_1096((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260()));
        }
        return base;
    }

    public List<PositionData> getPositionsToRender() {
        return this.positionsToRender;
    }

    public void optimizedDrawShapeOutline(class_4587 matrixStack, class_4588 vertexConsumer, class_265 voxelShape, double x, double y, double z, float r, float g, float b, float a) {
        if (!CACHED_SHAPES.containsKey(voxelShape)) {
            ArrayList boxes = new ArrayList();
            voxelShape.method_1104((minX, minY, minZ, maxX, maxY, maxZ) -> boxes.add(new class_238(minX, minY, minZ, maxX, maxY, maxZ)));
            CACHED_SHAPES.put(voxelShape, boxes);
        }
        class_1159 matrix = matrixStack.method_23760().method_23761();
        List<class_238> shape = CACHED_SHAPES.get(voxelShape);
        for (class_238 box : shape) {
            vertexConsumer.method_22918(matrix, (float)(box.field_1323 + x), (float)(box.field_1322 + y), (float)(box.field_1321 + z)).method_22915(r, g, b, a).method_1344();
            vertexConsumer.method_22918(matrix, (float)(box.field_1320 + x), (float)(box.field_1325 + y), (float)(box.field_1324 + z)).method_22915(r, g, b, a).method_1344();
        }
    }

    public void drawTextInWorld(class_4587 matrixStack, class_4597 vertexConsumers, class_4184 camera, int light, class_243 pos, class_2561 text, boolean force) {
        double d;
        class_243 renderPos = camera.method_19326().method_22882().method_1019(pos);
        if (force && (d = (double)class_3532.method_15368((double)(renderPos.field_1352 * renderPos.field_1352 + renderPos.field_1351 * renderPos.field_1351 + renderPos.field_1350 * renderPos.field_1350))) > 4.0) {
            renderPos = renderPos.method_1021(4.0 / d);
        }
        matrixStack.method_22903();
        matrixStack.method_22904(renderPos.field_1352, renderPos.field_1351, renderPos.field_1350);
        matrixStack.method_22907(class_310.method_1551().method_1561().method_24197());
        matrixStack.method_22905(-0.025f, -0.025f, 0.025f);
        class_1159 matrix4f = matrixStack.method_23760().method_23761();
        float g = class_310.method_1551().field_1690.method_19343(0.25f);
        int j = (int)(g * 255.0f) << 24;
        class_327 textRenderer = class_310.method_1551().method_1561().method_3949();
        float h = -textRenderer.method_27525((class_5348)text) / 2;
        textRenderer.method_22942((class_5348)text, h, 0.0f, -1, false, matrix4f, vertexConsumers, true, j, light);
        textRenderer.method_22942((class_5348)text, h, 0.0f, -1, false, matrix4f, vertexConsumers, false, 0, light);
        matrixStack.method_22909();
    }

    public static class_4668.class_4677 getDynamicLineWidth() {
        class_4668.class_4677 layer = new class_4668.class_4677(OptionalDouble.empty());
        ((AccessorRenderPhase)layer).setName("line_width_dynamic");
        ((AccessorRenderPhase)layer).setBeginAction(() -> RenderSystem.lineWidth((float)ChestTracker.CONFIG.visualOptions.borderWidth));
        ((AccessorRenderPhase)layer).setEndAction(() -> RenderSystem.lineWidth((float)1.0f));
        return layer;
    }

    public void renderNames(class_4587 matrices, class_4597.class_4598 entityVertexConsumers, class_4184 camera) {
        LocationStorage storage = LocationStorage.get();
        if (storage == null) {
            return;
        }
        assert (class_310.method_1551().field_1687 != null);
        List renderedPositions = this.positionsToRender.stream().map(data -> ((PositionData)data).pos).collect(Collectors.toList());
        for (Location location : storage.getStorage(class_310.method_1551().field_1687.method_27983().method_29177())) {
            if (location.getName() == null) continue;
            if (renderedPositions.contains(location.getPosition())) {
                RenderManager.getInstance().drawTextInWorld(matrices, (class_4597)entityVertexConsumers, camera, 0xF000F0, class_243.method_24954((class_2382)location.getPosition()).method_1031(0.5, 1.5, 0.5).method_1019(location.hasNameOffset() ? location.getNameOffset() : class_243.field_1353), location.getName(), true);
                continue;
            }
            if (location.getName() == null || !(camera.method_19326().method_1025(class_243.method_24954((class_2382)location.getPosition())) <= (double)(ChestTracker.CONFIG.visualOptions.nameRenderRange * ChestTracker.CONFIG.visualOptions.nameRenderRange))) continue;
            RenderManager.getInstance().drawTextInWorld(matrices, (class_4597)entityVertexConsumers, camera, 0xF000F0, class_243.method_24954((class_2382)location.getPosition()).method_1031(0.5, 1.5, 0.5).method_1019(location.hasNameOffset() ? location.getNameOffset() : class_243.field_1353), location.getName(), false);
        }
    }

    public static class PositionData {
        private final long startTime;
        private final class_2338 pos;
        private final class_265 shape;

        public PositionData(long startTime, class_2338 pos, class_265 shape) {
            this.startTime = startTime;
            this.pos = pos;
            this.shape = shape;
        }

        public class_2338 getPos() {
            return this.pos;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public class_265 getShape() {
            return this.shape;
        }
    }
}

