/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.chesttracker.tracker;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2791;
import net.minecraft.class_2812;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5218;
import net.minecraft.class_634;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import red.jackf.chesttracker.ChestTracker;
import red.jackf.chesttracker.GsonHandler;
import red.jackf.chesttracker.tracker.LinkedBlocksHandler;
import red.jackf.chesttracker.tracker.Location;

@Environment(value=EnvType.CLIENT)
public class LocationStorage {
    private static final Path ROOT_DIR = Paths.get(class_310.method_1551().field_1697.getAbsolutePath(), new String[0]).resolve("chesttracker");
    private static final Gson GSON = GsonHandler.get();
    @Nullable
    private static LocationStorage currentStorage = null;
    private final String savePath;
    private Map<String, WorldStorage> storage = new HashMap<String, WorldStorage>();

    private LocationStorage(String savePath) {
        this.savePath = savePath;
        this.load();
    }

    public Path getFilePath() {
        return ROOT_DIR.resolve(this.savePath + ".json");
    }

    @Nullable
    public static LocationStorage get() {
        class_310 client = class_310.method_1551();
        class_634 handler = client.method_1562();
        String path = "";
        if (handler != null && handler.method_2872().method_10758()) {
            path = client.method_1576() != null ? "singleplayer-" + client.method_1576().method_27050(class_5218.field_24188).getParent().getFileName() : (client.method_1589() ? "realms-currentlyunsupportedsorry" : "multiplayer-" + LocationStorage.getUsefulFileString(handler.method_2872().method_10755()));
        }
        if (path.equals("")) {
            return null;
        }
        if (currentStorage == null || !LocationStorage.currentStorage.savePath.equals(path)) {
            if (currentStorage != null) {
                currentStorage.save();
            }
            currentStorage = new LocationStorage(path);
        }
        return currentStorage;
    }

    public void closeDown() {
        this.save();
        currentStorage = null;
    }

    private void save() {
        File folder = new File(ROOT_DIR.toUri());
        if (!folder.mkdirs()) {
            File targetFile = new File(this.getFilePath().toUri());
            try {
                FileWriter writer = new FileWriter(targetFile);
                GSON.toJson(this.storage, (Appendable)writer);
                writer.flush();
                writer.close();
            }
            catch (IOException e) {
                ChestTracker.LOGGER.error("Error saving to file", (Throwable)e);
            }
        } else {
            ChestTracker.LOGGER.error("Could not create folder at " + folder.getAbsolutePath() + ".");
        }
    }

    private void load() {
        File folder = new File(ROOT_DIR.toUri());
        if (!folder.mkdirs()) {
            File targetFile = new File(this.getFilePath().toUri());
            if (targetFile.exists()) {
                try {
                    this.storage = (Map)GSON.fromJson((Reader)new FileReader(targetFile), new TypeToken<Map<String, WorldStorage>>(){}.getType());
                }
                catch (Throwable e) {
                    ChestTracker.LOGGER.error("Error loading from file", e);
                }
            } else {
                ChestTracker.LOGGER.info("Creating new storage at " + targetFile);
            }
        } else {
            ChestTracker.LOGGER.error("Could not create folder at " + folder.getAbsolutePath() + ".");
        }
        if (this.storage == null) {
            this.storage = new HashMap<String, WorldStorage>();
        }
    }

    public void mergeItems(class_2338 pos, class_1937 world, List<class_1799> items, class_2561 title, Boolean favourite) {
        WorldStorage storage = this.storage.computeIfAbsent(world.method_27983().method_29177().toString(), worldRegistryKey -> new WorldStorage());
        List<class_2338> positions = LinkedBlocksHandler.getLinked(world, pos);
        class_243 offset = LocationStorage.centerOf(positions).method_1020(class_243.method_24954((class_2382)pos));
        Location location = new Location(pos, title, positions.size() == 1 ? null : offset, items, favourite);
        positions.stream().map(storage.lookupMap::get).filter(Objects::nonNull).forEach(storage::remove);
        storage.add(location);
    }

    private static class_243 centerOf(List<class_2338> positions) {
        class_243 result = class_243.field_1353;
        for (class_2338 pos : positions) {
            result = result.method_1019(class_243.method_24954((class_2382)pos));
        }
        return result.method_1021(1.0 / (double)positions.size());
    }

    public List<Location> findItems(class_2960 worldId, class_1799 toFind) {
        WorldStorage storage = this.getStorage(worldId);
        List<Location> results = storage.stream().filter(location -> location.getItems().stream().anyMatch(itemStack -> LocationStorage.stacksEqual(itemStack, toFind))).collect(Collectors.toList());
        storage.verifyItems(results);
        return results;
    }

    public WorldStorage getStorage(class_2960 worldId) {
        return this.storage.computeIfAbsent(worldId.toString(), worldRegistryKey -> new WorldStorage());
    }

    private static boolean stacksEqual(class_1799 candidate, class_1799 toFind) {
        if (candidate == null) {
            ChestTracker.LOGGER.warn("Candidate was null!");
            return false;
        }
        if (toFind == null) {
            ChestTracker.LOGGER.warn("ToFind was null!");
            return false;
        }
        return candidate.method_7909() == toFind.method_7909();
    }

    private static String getUsefulFileString(@NotNull SocketAddress address) {
        if (address instanceof InetSocketAddress) {
            InetSocketAddress inet = (InetSocketAddress)address;
            return inet.getAddress().getHostAddress() + (inet.getPort() == 25565 ? "" : "-" + inet.getPort());
        }
        return address.toString().replace(':', '-').replace('/', '-');
    }

    public String toString() {
        return "LocationStorage{savePath='" + this.savePath + '\'' + ", storage=" + this.storage + '}';
    }

    public static class WorldStorage
    extends HashSet<Location> {
        private final Map<class_2338, Location> lookupMap = new HashMap<class_2338, Location>();
        private static final Comparator<class_1799> sorter = Comparator.comparingInt(class_1799::method_7947).reversed().thenComparing(itemStack -> itemStack.method_7964().getString());

        @Override
        public boolean remove(Object o) {
            this.removeFromMap((Location)o);
            return super.remove(o);
        }

        private void removeFromMap(Location loc) {
            for (class_2338 pos : LinkedBlocksHandler.getLinked((class_1937)class_310.method_1551().field_1687, loc.getPosition())) {
                this.lookupMap.remove(pos);
            }
        }

        @Override
        public void clear() {
            this.lookupMap.clear();
            super.clear();
        }

        @Nullable
        public Location lookupFast(class_2338 pos) {
            for (class_2338 pos2 : LinkedBlocksHandler.getLinked((class_1937)class_310.method_1551().field_1687, pos)) {
                if (!this.lookupMap.containsKey(pos2)) continue;
                return this.lookupMap.get(pos2);
            }
            return null;
        }

        @Override
        public boolean removeIf(@NotNull Predicate<? super Location> filter) {
            boolean removed = false;
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                Location loc = (Location)iterator.next();
                if (!filter.test(loc)) continue;
                this.removeFromMap(loc);
                iterator.remove();
                removed = true;
            }
            return removed;
        }

        @Override
        public boolean add(Location location) {
            this.lookupMap.put(location.getPosition(), location);
            return super.add(location);
        }

        public void verifyItems(Collection<Location> list) {
            if (class_310.method_1551().field_1687 != null) {
                Iterator<Location> iterator = list.iterator();
                while (iterator.hasNext()) {
                    Location location = iterator.next();
                    class_2791 chunk = class_310.method_1551().field_1687.method_22350(location.getPosition());
                    if (chunk instanceof class_2812 || chunk.method_8320(location.getPosition()).method_26204().method_26161()) continue;
                    iterator.remove();
                }
            }
        }

        public void verify() {
            this.verifyItems(this);
        }

        public List<class_1799> getItems() {
            HashMap result = new HashMap();
            this.forEach(location -> location.getItems().forEach(itemStack -> result.merge(itemStack.method_7909(), itemStack.method_7947(), Integer::sum)));
            return result.keySet().stream().map(item -> new class_1799((class_1935)item, ((Integer)result.get(item)).intValue())).sorted(sorter).collect(Collectors.toList());
        }
    }
}

