/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.chesttracker.tracker;

import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_638;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import red.jackf.chesttracker.ChestTracker;
import red.jackf.chesttracker.config.InteractRememberType;
import red.jackf.chesttracker.config.LibGuiHandler;
import red.jackf.chesttracker.gui.FavouriteButton;
import red.jackf.chesttracker.render.RenderManager;
import red.jackf.chesttracker.tracker.Location;
import red.jackf.chesttracker.tracker.LocationStorage;

@Environment(value=EnvType.CLIENT)
public class Tracker {
    private static final Tracker TRACKER = new Tracker();
    @Nullable
    private class_2338 lastInteractedPos = null;

    public void setLastPos(class_2338 newPos) {
        this.lastInteractedPos = newPos == null ? null : newPos.method_10062();
    }

    public static Tracker getInstance() {
        return TRACKER;
    }

    public <T extends class_1703> void handleScreen(class_465<T> screen) {
        if (this.lastInteractedPos == null) {
            return;
        }
        if (class_310.method_1551().field_1724 == null || class_310.method_1551().field_1687 == null) {
            return;
        }
        String className = screen.getClass().getSimpleName();
        if (ChestTracker.CONFIG.miscOptions.debugPrint.booleanValue()) {
            ChestTracker.sendDebugMessage((class_1657)class_310.method_1551().field_1724, (class_2561)(this.validScreenToTrack((class_437)screen) ? new class_2588("chesttracker.gui_class_name_tracked", new Object[]{className}).method_27692(class_124.field_1060) : new class_2588("chesttracker.gui_class_name_not_tracked", new Object[]{className}).method_27692(class_124.field_1061)));
        }
        if (!this.validScreenToTrack((class_437)screen)) {
            return;
        }
        class_1703 handler = screen.method_17577();
        List<class_1799> items = handler.field_7761.stream().filter(slot -> !(slot.field_7871 instanceof class_1661)).filter(class_1735::method_7681).map(class_1735::method_7677).filter(Objects::nonNull).collect(Collectors.toList());
        LocationStorage storage = LocationStorage.get();
        if (storage == null) {
            return;
        }
        storage.mergeItems(this.lastInteractedPos, class_310.method_1551().field_1724.field_6002, items, this.getTitle(screen, class_310.method_1551().field_1687, this.lastInteractedPos, screen.method_25440()), FavouriteButton.current.isActive());
        this.lastInteractedPos = null;
    }

    @Nullable
    private class_2561 getTitle(class_465<?> screen, class_638 world, class_2338 pos, class_2561 title) {
        if (LibGuiHandler.cancel(screen)) {
            return null;
        }
        if (title instanceof class_2588) {
            return null;
        }
        class_2586 be = world.method_8321(pos);
        if (be instanceof class_3908) {
            return title;
        }
        return null;
    }

    public void handleInteract(class_1657 player, class_1937 world, class_1268 hand, class_3965 hitResult) {
        boolean blockHasBE = world.method_8320(hitResult.method_17777()).method_26204().method_26161();
        if ((ChestTracker.CONFIG.miscOptions.blockInteractionType == InteractRememberType.ALL || blockHasBE) && !this.ignoreDueToConfig(class_2378.field_11146.method_10221((Object)world.method_8320(hitResult.method_17777()).method_26204()))) {
            Tracker.getInstance().setLastPos(hitResult.method_17777());
        }
        if (ChestTracker.CONFIG.miscOptions.debugPrint.booleanValue()) {
            ChestTracker.sendDebugMessage(player, (class_2561)new class_2588("chesttracker.block_clicked_" + (blockHasBE ? "be_provider" : "not_be_provider"), new Object[]{class_2378.field_11146.method_10221((Object)world.method_8320(hitResult.method_17777()).method_26204())}).method_27692(blockHasBE ? class_124.field_1060 : class_124.field_1054));
        }
    }

    private boolean ignoreDueToConfig(class_2960 id) {
        return ChestTracker.CONFIG.ignoredBlocks.ignoredBlockList.stream().anyMatch(s -> {
            try {
                boolean matches = Pattern.matches(".*" + s + ".*", id.toString());
                if (matches && ChestTracker.CONFIG.miscOptions.debugPrint.booleanValue() && class_310.method_1551().field_1724 != null) {
                    ChestTracker.sendDebugMessage((class_1657)class_310.method_1551().field_1724, (class_2561)new class_2588("chesttracker.not_tracked_due_to_ignore_list", new Object[]{s}).method_27692(class_124.field_1061));
                }
                return matches;
            }
            catch (Exception ex) {
                ChestTracker.LOGGER.error("Regex pattern " + s + " failed to compile! Check your syntax.");
                return false;
            }
        });
    }

    @Nullable
    public class_2338 getLastInteractedPos() {
        return this.lastInteractedPos;
    }

    @NotNull
    public class_1269 searchForItem(class_1799 toFind) {
        List<Location> results;
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || client.field_1687 == null) {
            return class_1269.field_5811;
        }
        LocationStorage storage = LocationStorage.get();
        if (storage == null) {
            return class_1269.field_5811;
        }
        if (ChestTracker.CONFIG.miscOptions.debugPrint.booleanValue()) {
            ChestTracker.sendDebugMessage((class_1657)client.field_1724, (class_2561)new class_2588("chesttracker.searching_for_item", new Object[]{toFind}).method_27692(class_124.field_1060));
        }
        if ((results = storage.findItems(client.field_1724.field_17892.method_29287().method_29177(), toFind)).size() > 0) {
            RenderManager.getInstance().addRenderList(results, client.field_1687.method_8510());
            client.field_1724.method_7346();
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public boolean validScreenToTrack(class_437 s) {
        return s instanceof class_465 && !ChestTracker.CONFIG.trackedScreens.blocklist.contains(s.getClass().getSimpleName()) && this.lastInteractedPos != null;
    }
}

