/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.cinderscapes.command;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.terraformersmc.cinderscapes.init.CinderscapesBiomes;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import net.fabricmc.fabric.api.registry.CommandRegistry;
import net.minecraft.class_124;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2874;

public class MapBiomesCommand {
    private static final Map<class_1959, Integer> BIOME2COLOR = new HashMap<class_1959, Integer>();
    private static DecimalFormat numberFormat = new DecimalFormat("#.00");

    public static void register() {
        CommandRegistry.INSTANCE.register(false, dispatcher -> {
            LiteralArgumentBuilder builder = (LiteralArgumentBuilder)class_2170.method_9247((String)"mapbiomes").requires(source -> source.method_9259(2));
            builder.executes(context -> {
                MapBiomesCommand.execute((class_2168)context.getSource());
                return 1;
            });
            dispatcher.register(builder);
        });
    }

    private static void execute(class_2168 source) {
        if (source.method_9225().method_29287() != class_2874.field_24754) {
            source.method_9226((class_2561)new class_2585("Please run this in the nether."), false);
            return;
        }
        HashMap<class_1959, Integer> biomeCount = new HashMap<class_1959, Integer>();
        BufferedImage img = new BufferedImage(2048, 2048, 1);
        int progressUpdate = img.getHeight() / 8;
        for (int x = 0; x < img.getHeight(); ++x) {
            for (int z = 0; z < img.getWidth(); ++z) {
                class_1959 b = source.method_9225().method_16359(x * 4, 0, z * 4);
                Integer color = BIOME2COLOR.get(b);
                if (color == null) {
                    color = 0xFFFFFF;
                }
                if (!biomeCount.containsKey(b)) {
                    biomeCount.put(b, 0);
                } else {
                    biomeCount.put(b, (Integer)biomeCount.get(b) + 1);
                }
                img.setRGB(x, z, color);
            }
            if (x % progressUpdate != 0) continue;
            source.method_9226((class_2561)new class_2588((double)x / (double)img.getHeight() * 100.0 + "% Done mapping"), true);
        }
        source.method_9226((class_2561)new class_2585("Approximate biome-block counts within an 8192x8192 region"), true);
        int totalCount = biomeCount.values().stream().mapToInt(i -> i).sum();
        biomeCount.forEach((biome, integer) -> source.method_9226((class_2561)new class_2588(biome.method_8689()).method_27693(": " + integer * 16 + class_124.field_1080 + " (" + numberFormat.format((double)integer.intValue() / (double)totalCount * 100.0) + "%)"), true));
        Path p = Paths.get("biomemap.png", new String[0]);
        try {
            ImageIO.write((RenderedImage)img, "png", p.toAbsolutePath().toFile());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        BIOME2COLOR.put(class_1972.field_9461, 0xFF7700);
        BIOME2COLOR.put(class_1972.field_22075, 945033);
        BIOME2COLOR.put(class_1972.field_22077, 0xEE0000);
        BIOME2COLOR.put(class_1972.field_22076, 4580351);
        BIOME2COLOR.put(class_1972.field_23859, 0x949494);
        BIOME2COLOR.put(CinderscapesBiomes.QUARTZ_CANYON, 0xFFFFFF);
        BIOME2COLOR.put(CinderscapesBiomes.BLACKSTONE_SHALES, 0x303030);
        BIOME2COLOR.put(CinderscapesBiomes.LUMINOUS_GROVE, 3291816);
    }
}

