/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.cinderscapes.feature;

import com.terraformersmc.cinderscapes.init.CinderscapesBlocks;
import com.terraformersmc.cinderscapes.util.shapelib.MathHelper;
import com.terraformersmc.cinderscapes.util.shapelib.Quaternion;
import com.terraformersmc.cinderscapes.util.shapelib.Shape;
import com.terraformersmc.cinderscapes.util.shapelib.Shapes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_265;
import net.minecraft.class_2794;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_5138;
import net.minecraft.class_5281;

public class DeadTreeFeature
extends class_3031<class_3111> {
    public DeadTreeFeature() {
        super(class_3111.field_24893);
    }

    public boolean generate(class_5281 world, class_5138 accessor, class_2794 generator, Random random, class_2338 pos, class_3111 config) {
        if (world.method_8320(pos.method_10074()).method_26204() == CinderscapesBlocks.ASH) {
            pos = pos.method_10074();
        }
        if (!class_2248.method_9501((class_265)world.method_8320(pos.method_10074()).method_26220((class_1922)world, pos.method_10074()), (class_2350)class_2350.field_11036)) {
            return false;
        }
        if (world.method_8320(pos.method_10074()).method_26204() == class_2246.field_10092 || world.method_8320(pos.method_10074()).method_26204() == CinderscapesBlocks.SCORCHED_STEM) {
            return false;
        }
        Shape shape = new Shape();
        boolean good = this.recursiveTree(world, pos, new ArrayList<Quaternion>(), 3, 3, random, shape);
        if (good) {
            shape.fill(CinderscapesBlocks.SCORCHED_STEM.method_9564(), world);
            return true;
        }
        return false;
    }

    private boolean recursiveTree(class_5281 world, class_2338 pos, List<Quaternion> previousRotations, int startingPoint, int recursionLevel, Random random, Shape toBuild) {
        if (recursionLevel == 0) {
            return true;
        }
        boolean allGood = true;
        float zAngle = random.nextFloat() * 30.0f + 15.0f;
        float yAngle = random.nextFloat() * 360.0f;
        if (recursionLevel == startingPoint) {
            zAngle = 0.0f;
            yAngle = 0.0f;
        }
        int height = random.nextInt(2) + Math.round(MathHelper.map(recursionLevel, startingPoint, 0.0f, 6.0f, 2.0f));
        ArrayList<Quaternion> rotations = new ArrayList<Quaternion>(previousRotations);
        rotations.add(new Quaternion(0.0f, yAngle, zAngle, true));
        class_2338 endPoint = Quaternion.of(0.0f, 0.0f, height, 0.0f).rotateBy(rotations).toBlockPos().method_10081((class_2382)pos);
        Shape line = Shapes.line(pos, endPoint);
        if (line.isSafeWhitelist(world, Arrays.asList(class_2246.field_10124.method_9564(), CinderscapesBlocks.ASH.method_9564()))) {
            toBuild.join(line);
            int amount = random.nextInt(3) + 2;
            for (int i = 0; i < amount; ++i) {
                allGood = allGood && this.recursiveTree(world, endPoint, rotations, startingPoint, recursionLevel - 1, random, toBuild);
            }
        } else {
            allGood = false;
        }
        return allGood;
    }
}

