/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.cinderscapes.util.shapelib;

import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1158;
import net.minecraft.class_2338;

public class Quaternion {
    public static final Quaternion NONE = new Quaternion(1.0f, 0.0f, 0.0f, 0.0f);
    private float w;
    private float i;
    private float j;
    private float k;

    public Quaternion(float w, float i, float j, float k) {
        this.w = w;
        this.i = i;
        this.j = j;
        this.k = k;
    }

    public Quaternion(class_1158 q) {
        this(q.method_4924(), q.method_4921(), q.method_4922(), q.method_4923());
    }

    public Quaternion(Quaternion q) {
        this(q.getW(), q.getI(), q.getJ(), q.getK());
    }

    public Quaternion(class_2338 pos) {
        this(0.0f, (float)pos.method_10263() + 0.5f, (float)pos.method_10264() + 0.5f, (float)pos.method_10260() + 0.5f);
    }

    public Quaternion(float xrot, float yrot, float zrot, boolean degrees) {
        if (degrees) {
            xrot = (float)((double)xrot * (Math.PI / 180));
            yrot = (float)((double)yrot * (Math.PI / 180));
            zrot = (float)((double)zrot * (Math.PI / 180));
        }
        float f = (float)Math.sin(0.5 * (double)xrot);
        float g = (float)Math.cos(0.5 * (double)xrot);
        float h = (float)Math.sin(0.5 * (double)yrot);
        float a = (float)Math.cos(0.5 * (double)yrot);
        float b = (float)Math.sin(0.5 * (double)zrot);
        float c = (float)Math.cos(0.5 * (double)zrot);
        this.i = f * a * c + g * h * b;
        this.j = g * h * c - f * a * b;
        this.k = f * h * c + g * a * b;
        this.w = g * a * c - f * h * b;
    }

    public static Quaternion of(float w, float i, float j, float k) {
        return new Quaternion(w, i, j, k);
    }

    public static Quaternion of(class_1158 q) {
        return new Quaternion(q);
    }

    public static Quaternion of(class_2338 pos) {
        return new Quaternion(pos);
    }

    public Quaternion copy() {
        return new Quaternion(this);
    }

    public class_2338 toBlockPos() {
        return new class_2338(Math.round(this.i), Math.round(this.j), Math.round(this.k));
    }

    public float getW() {
        return this.w;
    }

    public float getI() {
        return this.i;
    }

    public float getJ() {
        return this.j;
    }

    public float getK() {
        return this.k;
    }

    public Quaternion add(Quaternion addend) {
        this.w += addend.w;
        this.i += addend.i;
        this.j += addend.j;
        this.k += addend.k;
        return this;
    }

    public static Quaternion add(Quaternion q1, Quaternion q2) {
        return new Quaternion(q1.w + q2.w, q1.i + q2.i, q1.j + q2.j, q1.k + q2.k);
    }

    public Quaternion sub(Quaternion subtrahend) {
        this.w -= subtrahend.w;
        this.i -= subtrahend.i;
        this.j -= subtrahend.j;
        this.k -= subtrahend.k;
        return this;
    }

    public static Quaternion sub(Quaternion minuend, Quaternion subtrahend) {
        return new Quaternion(minuend.w - subtrahend.w, minuend.i - subtrahend.i, minuend.j - subtrahend.j, minuend.k - subtrahend.k);
    }

    public Quaternion mul(Quaternion multiplier) {
        float w = this.w * multiplier.w - this.i * multiplier.i - this.j * multiplier.j - this.k * multiplier.k;
        float i = this.w * multiplier.i + this.i * multiplier.w + this.j * multiplier.k - this.k * multiplier.j;
        float j = this.w * multiplier.j - this.i * multiplier.k + this.j * multiplier.w + this.k * multiplier.i;
        float k = this.w * multiplier.k + this.i * multiplier.j - this.j * multiplier.i + this.k * multiplier.w;
        this.w = w;
        this.i = i;
        this.j = j;
        this.k = k;
        return this;
    }

    public static Quaternion mul(Quaternion multiplicand, Quaternion multiplier) {
        return new Quaternion(multiplicand.w * multiplier.w - multiplicand.i * multiplier.i - multiplicand.j * multiplier.j - multiplicand.k * multiplier.k, multiplicand.w * multiplier.i + multiplicand.i * multiplier.w + multiplicand.j * multiplier.k - multiplicand.k * multiplier.j, multiplicand.w * multiplier.j - multiplicand.i * multiplier.k + multiplicand.j * multiplier.w + multiplicand.k * multiplier.i, multiplicand.w * multiplier.k + multiplicand.i * multiplier.j - multiplicand.j * multiplier.i + multiplicand.k * multiplier.w);
    }

    public Quaternion div(Quaternion divisor) {
        float commonDenominator = divisor.w * divisor.w + divisor.i * divisor.i + divisor.j * divisor.j + divisor.k * divisor.k;
        float w = (divisor.w * this.w + divisor.i * this.i + divisor.j * this.j + divisor.k * this.k) / commonDenominator;
        float i = (divisor.w * this.i - divisor.i * this.w - divisor.j * this.k + divisor.k * this.j) / commonDenominator;
        float j = (divisor.w * this.j + divisor.i * this.k - divisor.j * this.w - divisor.k * this.i) / commonDenominator;
        float k = (divisor.w * this.k - divisor.i * this.j + divisor.j * this.i - divisor.k * this.w) / commonDenominator;
        this.w = w;
        this.i = i;
        this.j = j;
        this.k = k;
        return this;
    }

    public static Quaternion div(Quaternion dividend, Quaternion divisor) {
        float commonDenominator = divisor.w * divisor.w + divisor.i * divisor.i + divisor.j * divisor.j + divisor.k * divisor.k;
        return new Quaternion((divisor.w * dividend.w + divisor.i * dividend.i + divisor.j * dividend.j + divisor.k * dividend.k) / commonDenominator, (divisor.w * dividend.i - divisor.i * dividend.w - divisor.j * dividend.k + divisor.k * dividend.j) / commonDenominator, (divisor.w * dividend.j + divisor.i * dividend.k - divisor.j * dividend.w - divisor.k * dividend.i) / commonDenominator, (divisor.w * dividend.k - divisor.i * dividend.j + divisor.j * dividend.i - divisor.k * dividend.w) / commonDenominator);
    }

    public Quaternion conjugate() {
        return new Quaternion(this.w, -this.i, -this.j, -this.k);
    }

    public Quaternion conjugate(Quaternion q) {
        return new Quaternion(q.w, -q.i, -q.j, -q.k);
    }

    public boolean isUnit() {
        return this.w * this.w + this.i * this.i + this.j * this.j + this.k * this.k == 1.0f;
    }

    public boolean isPure() {
        return this.w == 0.0f;
    }

    public Quaternion rotateBy(Quaternion q) {
        Quaternion base = q.copy();
        Quaternion conjugate = base.conjugate();
        base.mul(this);
        base.mul(conjugate);
        this.set(base);
        return this;
    }

    public Quaternion rotateBy(Quaternion ... q) {
        return this.rotateBy(Arrays.asList(q));
    }

    public Quaternion rotateBy(List<Quaternion> q) {
        q.forEach(this::rotateBy);
        return this;
    }

    private void set(Quaternion q) {
        this.w = q.w;
        this.i = q.i;
        this.j = q.j;
        this.k = q.k;
    }

    public String toString() {
        return String.format("Quaternion{w=%f, i=%f, j=%f, k=%f}", Float.valueOf(this.w), Float.valueOf(this.i), Float.valueOf(this.j), Float.valueOf(this.k));
    }
}

