/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.cinderscapes.util.shapelib;

import com.terraformersmc.cinderscapes.util.shapelib.Quaternion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_5281;

public class Shape
extends ArrayList<class_2338> {
    public Shape rotateBy(Quaternion q) {
        Shape shape = new Shape();
        this.forEach((? super E pos) -> shape.add(Quaternion.of(pos).rotateBy(q).toBlockPos()));
        return shape;
    }

    public Shape rotateBy(Quaternion q, class_2338 pos) {
        return this.translateBy(new class_2338(-pos.method_10263(), -pos.method_10264(), -pos.method_10260())).rotateBy(q).translateBy(pos);
    }

    public Shape translateBy(class_2338 pos) {
        Shape shape = new Shape();
        this.forEach((? super E ipos) -> shape.add(ipos.method_10081((class_2382)pos)));
        return shape;
    }

    public Shape translateDown(int i) {
        return this.translateBy(new class_2338(0, -i, 0));
    }

    public Shape translateUp(int i) {
        return this.translateBy(new class_2338(0, i, 0));
    }

    public Shape translateNorth(int i) {
        return this.translateBy(new class_2338(0, 0, -i));
    }

    public Shape translateSouth(int i) {
        return this.translateBy(new class_2338(0, 0, i));
    }

    public Shape translateWest(int i) {
        return this.translateBy(new class_2338(-i, 0, 0));
    }

    public Shape translateEast(int i) {
        return this.translateBy(new class_2338(i, 0, 0));
    }

    public void fill(class_2680 state, class_5281 world) {
        this.forEach((? super E pos) -> world.method_8652(pos, state, 0));
    }

    public void fillUpdate(class_2680 state, class_5281 world) {
        this.forEach((? super E pos) -> {
            world.method_8652(pos, state, 2);
            world.method_8408(pos, state.method_26204());
        });
    }

    public void fillWhitelist(class_2680 state, class_5281 world, List<class_2680> whitelist) {
        this.forEach((? super E pos) -> {
            class_2680 currentState = world.method_8320(pos);
            if (whitelist.contains(currentState)) {
                world.method_8652(pos, state, 0);
            }
        });
    }

    public void fillBlacklist(class_2680 state, class_5281 world, List<class_2680> blacklist) {
        this.forEach((? super E pos) -> {
            class_2680 currentState = world.method_8320(pos);
            if (!blacklist.contains(currentState)) {
                world.method_8652(pos, state, 0);
            }
        });
    }

    public void fillIfAir(class_2680 state, class_5281 world) {
        this.forEach((? super E pos) -> {
            class_2680 currentState = world.method_8320(pos);
            if (currentState.method_26215()) {
                world.method_8652(pos, state, 0);
            }
        });
    }

    public boolean fillIfSafeWhitelist(class_2680 state, class_5281 world, List<class_2680> whitelist) {
        boolean safe = true;
        for (class_2338 pos : this) {
            class_2680 currentState = world.method_8320(pos);
            if (whitelist.contains(currentState)) continue;
            safe = false;
        }
        if (safe) {
            this.fill(state, world);
        }
        return safe;
    }

    public boolean isSafeWhitelist(class_5281 world, List<class_2680> whitelist) {
        boolean safe = true;
        for (class_2338 pos : this) {
            class_2680 currentState = world.method_8320(pos);
            if (whitelist.contains(currentState)) continue;
            safe = false;
        }
        return safe;
    }

    @Override
    public boolean add(class_2338 pos) {
        return this.contains(pos) || super.add(pos);
    }

    @Override
    public boolean addAll(Collection<? extends class_2338> blocks) {
        blocks.forEach(this::add);
        return true;
    }

    public Shape copy() {
        Shape shape = new Shape();
        shape.addAll(this);
        return shape;
    }

    public Shape join(Shape s) {
        this.addAll(s);
        return this;
    }

    public Shape subtract(Shape s) {
        s.forEach(this::remove);
        return this;
    }

    public Shape intersect(Shape s) {
        Shape shape = new Shape();
        s.forEach((? super E pos) -> {
            if (this.contains(pos)) {
                shape.add((class_2338)pos);
            }
        });
        return shape;
    }

    public Shape inverseIntersect(Shape s) {
        Shape intersect = this.copy();
        intersect.intersect(s);
        Shape join = this.copy();
        join.join(s);
        return join.subtract(intersect);
    }
}

