/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.cinderscapes.util.shapelib;

import com.terraformersmc.cinderscapes.util.shapelib.MathHelper;
import com.terraformersmc.cinderscapes.util.shapelib.Quaternion;
import com.terraformersmc.cinderscapes.util.shapelib.Shape;
import net.minecraft.class_2338;
import net.minecraft.class_2382;

public class Shapes {
    public static Shape line(float x1, float y1, float z1, float x2, float y2, float z2) {
        Shape shape = new Shape();
        float dx = x2 - x1;
        float dy = y2 - y1;
        float dz = z2 - z1;
        float dt = MathHelper.max(Math.abs(dx), Math.abs(dy), Math.abs(dz));
        float dxdt = dx / dt;
        float dydt = dy / dt;
        float dzdt = dz / dt;
        int t = 0;
        while ((float)t <= dt) {
            shape.add(new class_2338(Math.round(x1 + dxdt * (float)t), Math.round(y1 + dydt * (float)t), Math.round(z1 + dzdt * (float)t)));
            ++t;
        }
        return shape;
    }

    public static Shape line(class_2338 start, class_2338 end) {
        return Shapes.line(start.method_10263(), start.method_10264(), start.method_10260(), end.method_10263(), end.method_10264(), end.method_10260());
    }

    public static Shape line(class_2338 end) {
        return Shapes.line(class_2338.field_10980, end);
    }

    public static Shape line(class_2338 origin, float distance, Quaternion rotation) {
        return Shapes.line(origin, origin.method_10081((class_2382)Quaternion.of(new class_2338((double)distance, 0.0, 0.0)).rotateBy(rotation).toBlockPos()));
    }

    public static Shape line(float distance, Quaternion rotation) {
        return Shapes.line(class_2338.field_10980, distance, rotation);
    }

    public static Shape ellipseShell(float width, float height, Quaternion q) {
        Shape shape = new Shape();
        float a = width / 2.0f;
        float b = height / 2.0f;
        float r = Math.max(a, b);
        float thetaStep = 1.0f / r;
        float theta = 0.0f;
        while ((double)theta <= Math.PI * 2) {
            shape.add(new class_2338((double)Math.round((double)a * Math.cos(theta) * (double)(q.getW() * q.getW() + q.getI() * q.getI() - q.getJ() * q.getJ() - q.getK() * q.getK()) + (double)b * Math.sin(theta) * (double)(2.0f * q.getW() * q.getJ() + 2.0f * q.getK() * q.getI())), (double)Math.round((double)a * Math.cos(theta) * (double)(2.0f * q.getI() * q.getJ() + 2.0f * q.getW() * q.getK()) + (double)b * Math.sin(theta) * (double)(2.0f * q.getJ() * q.getK() - 2.0f * q.getI() * q.getW())), (double)Math.round((double)b * Math.sin(theta) * (double)(q.getW() * q.getW() - q.getI() * q.getI() - q.getJ() * q.getJ() + q.getK() * q.getK()) + (double)a * Math.cos(theta) * (double)(2.0f * q.getI() * q.getK() - 2.0f * q.getJ() * q.getW()))));
            theta += thetaStep;
        }
        return shape;
    }

    public static Shape ellipseSolid(float width, float height, Quaternion q) {
        Shape shape = new Shape();
        float rstep = Math.max(width, height);
        int i = 0;
        while ((float)i < rstep) {
            shape.join(Shapes.ellipseShell(MathHelper.map(Math.min((float)i, rstep), 0.0f, rstep, width, 0.0f), MathHelper.map(Math.min((float)i, rstep), 0.0f, rstep, height, 0.0f), q));
            ++i;
        }
        return shape;
    }

    public static Shape rectShell(int width, int height) {
        Shape shape = new Shape();
        for (int x = -(width / 2); x < width / 2; ++x) {
            shape.add(new class_2338(x, 0, height / 2));
            shape.add(new class_2338(x, 0, -(height / 2)));
        }
        for (int z = -(width / 2); z < width / 2; ++z) {
            shape.add(new class_2338(width / 2, 0, z));
            shape.add(new class_2338(-(width / 2), 0, z));
        }
        return shape;
    }

    public static Shape squareShell(int size) {
        return Shapes.rectShell(size, size);
    }

    public static Shape rectSolid(int width, int height) {
        Shape shape = new Shape();
        for (int x = -(width / 2); x < width / 2; ++x) {
            for (int z = -(width / 2); z < width / 2; ++z) {
                shape.add(new class_2338(x, 0, z));
            }
        }
        return shape;
    }

    public static Shape squareSolid(int size) {
        return Shapes.rectSolid(size, size);
    }

    public static Shape ellipseShell(float width, float height) {
        Shape shape = new Shape();
        float r = Math.max(width / 2.0f, height / 2.0f);
        float thetaStep = 1.0f / r;
        float theta = 0.0f;
        while ((double)theta < Math.PI * 2) {
            shape.add(new class_2338((double)(width / 2.0f) * Math.cos(theta), 0.0, (double)(height / 2.0f) * Math.sin(theta)));
            theta += thetaStep;
        }
        return shape;
    }

    public static Shape circleShell(float radius) {
        return Shapes.ellipseShell(radius * 2.0f, radius * 2.0f);
    }

    public static Shape ellipseSolid(float width, float height) {
        Shape shape = new Shape();
        int x = (int)(-(width / 2.0f));
        while ((float)x < width / 2.0f) {
            int z = (int)(-(height / 2.0f));
            while ((float)z < height / 2.0f) {
                if ((float)(x * x) / (width / 2.0f * (width / 2.0f)) + (float)(z * z) / (height / 2.0f * (height / 2.0f)) <= 1.0f) {
                    shape.add(new class_2338(Math.round(x), 0, Math.round(z)));
                }
                ++z;
            }
            ++x;
        }
        return shape;
    }

    public static Shape circleSolid(float radius) {
        return Shapes.ellipseSolid(radius * 2.0f, radius * 2.0f);
    }

    public static Shape coneSolid(float baseRadius, int height) {
        Shape shape = new Shape();
        for (int y = 0; y < height; ++y) {
            float radius = baseRadius - baseRadius / (float)height * (float)y;
            shape.addAll(Shapes.circleSolid(radius).translateUp(y));
        }
        return shape;
    }

    public static Shape coneSolidRotated(float baseRadius, int height, Quaternion q) {
        Shape shape = new Shape();
        Quaternion endPoint = new Quaternion(0.0f, 0.0f, (float)height, 0.0f);
        endPoint.rotateBy(q);
        float dt = 2.0f * Math.max(Math.abs(endPoint.getI()), Math.max(Math.abs(endPoint.getJ()), Math.abs(endPoint.getK())));
        float dxdt = endPoint.getI() / dt;
        float dydt = endPoint.getJ() / dt;
        float dzdt = endPoint.getK() / dt;
        int t = 0;
        while ((float)t <= dt) {
            float x = dxdt * (float)t;
            float y = dydt * (float)t;
            float z = dzdt * (float)t;
            float radius = MathHelper.map(t, 0.0f, dt, baseRadius, 0.0f);
            float radiusStep = 0.5f;
            for (float iRadius = radius; iRadius > 0.0f; iRadius -= radiusStep) {
                float thetaStep = 1.0f / (float)Math.max((double)iRadius, 1.0E-7);
                float theta = 0.0f;
                while ((double)theta < Math.PI * 2) {
                    shape.add(new class_2338((double)Math.round((double)x + (double)iRadius * Math.cos(theta) * (double)(q.getW() * q.getW() + q.getI() * q.getI() - q.getJ() * q.getJ() - q.getK() * q.getK()) + (double)iRadius * Math.sin(theta) * (double)(2.0f * q.getW() * q.getJ() + 2.0f * q.getK() * q.getI())), (double)Math.round((double)y + (double)iRadius * Math.cos(theta) * (double)(2.0f * q.getI() * q.getJ() + 2.0f * q.getW() * q.getK()) + (double)iRadius * Math.sin(theta) * (double)(2.0f * q.getJ() * q.getK() - 2.0f * q.getI() * q.getW())), (double)Math.round((double)z + (double)iRadius * Math.sin(theta) * (double)(q.getW() * q.getW() - q.getI() * q.getI() - q.getJ() * q.getJ() + q.getK() * q.getK()) + (double)iRadius * Math.cos(theta) * (double)(2.0f * q.getI() * q.getK() - 2.0f * q.getJ() * q.getW()))));
                    theta += thetaStep;
                }
            }
            ++t;
        }
        return shape;
    }

    public static Shape ellipsoidSolidRoatated(float a, float b, float c, Quaternion q) {
        Shape shape = new Shape();
        Quaternion startPoint = new Quaternion(0.0f, 0.0f, -c, 0.0f);
        Quaternion endPoint = new Quaternion(0.0f, 0.0f, c, 0.0f);
        startPoint.rotateBy(q);
        endPoint.rotateBy(q);
        float dx = endPoint.getI() - startPoint.getI();
        float dy = endPoint.getJ() - startPoint.getJ();
        float dz = endPoint.getK() - startPoint.getK();
        float dt = 2.0f * Math.max(dx, Math.max(dy, dz));
        float dxdt = dx / dt;
        float dydt = dy / dt;
        float dzdt = dz / dt;
        for (float t = 0.0f; t <= dt; t += 1.0f) {
            float x = dxdt * t;
            float y = dydt * t;
            float z = dzdt * t;
            float centerDist = MathHelper.map(t, 0.0f, dt, -c, c);
            float ta = (float)Math.sqrt(a * a - a * a * (centerDist * centerDist) / (c * c));
            float tb = (float)Math.sqrt(b * b - b * b * (centerDist * centerDist) / (c * c));
            shape.join(Shapes.ellipseSolid(2.0f * ta, 2.0f * tb, q).translateBy(new class_2338((double)x, (double)y, (double)z)));
        }
        return shape;
    }
}

