/*
 * Decompiled with CFR 0.152.
 */
package tfar.classicbar.overlays.modoverlays;

import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import tfar.classicbar.Color;
import tfar.classicbar.ColorUtils;
import tfar.classicbar.ModUtils;
import tfar.classicbar.config.ModConfig;
import tfar.classicbar.overlays.IBarOverlay;
import thebetweenlands.api.capability.IDecayCapability;
import thebetweenlands.common.config.BetweenlandsConfig;
import thebetweenlands.common.registries.CapabilityRegistry;

public class DecayRenderer
implements IBarOverlay {
    private static final ResourceLocation DECAY_BAR_TEXTURE = new ResourceLocation("thebetweenlands:textures/gui/decay_bar.png");
    public boolean side;

    @Override
    public IBarOverlay setSide(boolean side) {
        this.side = side;
        return this;
    }

    @Override
    public boolean rightHandSide() {
        return this.side;
    }

    @Override
    public boolean shouldRender(EntityPlayer player) {
        return BetweenlandsConfig.WORLD_AND_DIMENSION.dimensionId == player.field_71093_bK;
    }

    @Override
    public void renderBar(EntityPlayer player, int width, int height) {
        IDecayCapability decayCap = (IDecayCapability)player.getCapability(CapabilityRegistry.CAPABILITY_DECAY, null);
        double decay = 20 - decayCap.getDecayStats().getDecayLevel();
        int xStart = width / 2 + 10;
        int yStart = height - this.getSidedOffset();
        ModUtils.mc.field_71424_I.func_76320_a("decay");
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        Color.reset();
        ModUtils.drawTexturedModalRect(xStart, yStart, 0, 0, 81, 9);
        float f = xStart + 79 - ModUtils.getWidth(decay, 20.0);
        ColorUtils.hex2Color("#81552D").color2Gl();
        ModUtils.drawTexturedModalRect(f, yStart + 1, 1, 10, ModUtils.getWidth(decay, 20.0), 7);
        GlStateManager.func_179121_F();
        ModUtils.mc.field_71424_I.func_76319_b();
    }

    @Override
    public boolean shouldRenderText() {
        return ModConfig.numbers.showThirstNumbers;
    }

    @Override
    public void renderText(EntityPlayer player, int width, int height) {
        IDecayCapability decayCap = (IDecayCapability)player.getCapability(CapabilityRegistry.CAPABILITY_DECAY, null);
        double decay = 20 - decayCap.getDecayStats().getDecayLevel();
        int h1 = (int)Math.floor(decay);
        int c = Integer.decode("#81552D");
        if (ModConfig.numbers.showPercent) {
            h1 = (int)decay * 5;
        }
        int xStart = width / 2 + 10;
        int yStart = height - this.getSidedOffset();
        ModUtils.drawStringOnHUD(h1 + "", xStart + 9 * (ModConfig.general.displayIcons ? 1 : 0) + 82, yStart - 1, c);
    }

    @Override
    public void renderIcon(EntityPlayer player, int width, int height) {
        int xStart = width / 2 + 10;
        int yStart = height - this.getSidedOffset();
        ModUtils.mc.func_110434_K().func_110577_a(DECAY_BAR_TEXTURE);
        ModUtils.drawTexturedModalRect(xStart + 82, yStart, 18, 0, 9, 9);
        ModUtils.drawTexturedModalRect(xStart + 82, yStart, 0, 0, 9, 9);
    }

    @Override
    public String name() {
        return "decay";
    }
}

