/*
 * Decompiled with CFR 0.152.
 */
package tfar.classicbar.overlays.modoverlays;

import baubles.api.BaublesApi;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;
import tfar.classicbar.Color;
import tfar.classicbar.ColorUtils;
import tfar.classicbar.ModUtils;
import tfar.classicbar.config.ModConfig;
import tfar.classicbar.overlays.IBarOverlay;

public class TiaraBarRenderer
implements IBarOverlay {
    @GameRegistry.ObjectHolder(value="botania:flighttiara")
    public static final Item tiara = null;
    private static final ResourceLocation ICON_BOTANIA = new ResourceLocation("botania", "textures/gui/hudicons.png");
    public boolean side;

    @Override
    public IBarOverlay setSide(boolean side) {
        this.side = side;
        return this;
    }

    @Override
    public boolean rightHandSide() {
        return this.side;
    }

    @Override
    public boolean shouldRender(EntityPlayer player) {
        int i1 = BaublesApi.isBaubleEquipped((EntityPlayer)player, (Item)tiara);
        if (i1 == -1) {
            return false;
        }
        NBTTagCompound nbt = BaublesApi.getBaublesHandler((EntityPlayer)player).getStackInSlot(i1).func_77978_p();
        return nbt != null;
    }

    @Override
    public void renderBar(EntityPlayer player, int width, int height) {
        int i1 = BaublesApi.isBaubleEquipped((EntityPlayer)player, (Item)tiara);
        ItemStack stack = BaublesApi.getBaublesHandler((EntityPlayer)player).getStackInSlot(i1);
        NBTTagCompound nbt = stack.func_77978_p();
        int timeLeft = nbt.func_74762_e("timeLeft");
        int dashCooldown = nbt.func_74762_e("dashCooldown");
        int xStart = width / 2 + 10;
        int yStart = height - this.getSidedOffset();
        ModUtils.mc.field_71424_I.func_76320_a("flight");
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ModUtils.drawTexturedModalRect(xStart, yStart, 0, 0, 81, 9);
        if (dashCooldown > 0) {
            int i4 = xStart - ModUtils.getWidth(dashCooldown, 80.0) + 81;
            ModUtils.drawTexturedModalRect(i4, yStart, 81 - ModUtils.getWidth(dashCooldown, 80.0), 18, ModUtils.getWidth(dashCooldown, 80.0), 9);
        }
        ColorUtils.hex2Color(ModConfig.mods.flightBarColor).color2Gl();
        float f = xStart + 79 - ModUtils.getWidth(timeLeft, 1200.0);
        ModUtils.drawTexturedModalRect(f, yStart + 1, 1, 10, ModUtils.getWidth(timeLeft, 1200.0), 7);
        GlStateManager.func_179121_F();
        ModUtils.mc.field_71424_I.func_76319_b();
    }

    @Override
    public boolean shouldRenderText() {
        return ModConfig.numbers.showTiaraNumbers;
    }

    @Override
    public void renderText(EntityPlayer player, int width, int height) {
        int i1 = BaublesApi.isBaubleEquipped((EntityPlayer)player, (Item)tiara);
        ItemStack stack = BaublesApi.getBaublesHandler((EntityPlayer)player).getStackInSlot(i1);
        NBTTagCompound nbt = stack.func_77978_p();
        int timeLeft = nbt.func_74762_e("timeLeft");
        int xStart = width / 2 + 10;
        int yStart = height - this.getSidedOffset();
        int i2 = timeLeft / 20;
        if (ModConfig.numbers.showPercent) {
            i2 = timeLeft / 12;
        }
        int i3 = ModConfig.general.displayIcons ? 1 : 0;
        int c = Integer.decode(ModConfig.mods.flightBarColor);
        ModUtils.drawStringOnHUD(i2 + "", xStart + 9 * i3 + 82, yStart - 1, c);
    }

    @Override
    public void renderIcon(EntityPlayer player, int width, int height) {
        int xStart = width / 2 + 10;
        int yStart = height - this.getSidedOffset();
        int i1 = BaublesApi.isBaubleEquipped((EntityPlayer)player, (Item)tiara);
        ItemStack stack = BaublesApi.getBaublesHandler((EntityPlayer)player).getStackInSlot(i1);
        ModUtils.mc.func_110434_K().func_110577_a(ICON_BOTANIA);
        Color.reset();
        if (ModConfig.general.displayIcons) {
            ModUtils.drawTexturedModalRect(xStart + 81, yStart, Math.max(stack.func_77952_i() * 9 - 9, 0), 0, 9, 9);
        }
    }

    @Override
    public String name() {
        return "flighttiara";
    }
}

