/*
 * Decompiled with CFR 0.152.
 */
package tfar.classicbar.overlays.modoverlays;

import de.teamlapen.vampirism.api.entity.player.vampire.IBloodStats;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.util.Helper;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import tfar.classicbar.Color;
import tfar.classicbar.ColorUtils;
import tfar.classicbar.ModUtils;
import tfar.classicbar.config.ModConfig;
import tfar.classicbar.overlays.IBarOverlay;

public class VampireRenderer
implements IBarOverlay {
    private static final ResourceLocation VAMPIRISM_ICONS = new ResourceLocation("vampirism:textures/gui/icons.png");
    public boolean side;

    @Override
    public IBarOverlay setSide(boolean side) {
        this.side = side;
        return this;
    }

    @Override
    public boolean rightHandSide() {
        return this.side;
    }

    @Override
    public boolean shouldRender(EntityPlayer player) {
        return Helper.isVampire((Entity)player);
    }

    @Override
    public void renderBar(EntityPlayer player, int width, int height) {
        IBloodStats stats = VampirePlayer.get((EntityPlayer)player).getBloodStats();
        double blood = stats.getBloodLevel();
        int maxBlood = stats.getMaxBlood();
        int xStart = width / 2 + 10;
        int yStart = height - this.getSidedOffset();
        ModUtils.mc.field_71424_I.func_76320_a("blood");
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        Color.reset();
        ModUtils.drawTexturedModalRect(xStart, yStart, 0, 0, 81, 9);
        float f = xStart + 79 - ModUtils.getWidth(blood, maxBlood);
        ColorUtils.hex2Color("#FF0000").color2Gl();
        ModUtils.drawTexturedModalRect(f, yStart + 1, 1, 10, ModUtils.getWidth(blood, maxBlood), 7);
        GlStateManager.func_179121_F();
        ModUtils.mc.field_71424_I.func_76319_b();
    }

    @Override
    public boolean shouldRenderText() {
        return ModConfig.numbers.showThirstNumbers;
    }

    @Override
    public void renderText(EntityPlayer player, int width, int height) {
        int blood;
        IBloodStats stats = VampirePlayer.get((EntityPlayer)player).getBloodStats();
        int h1 = blood = stats.getBloodLevel();
        int c = Integer.decode("#FF0000");
        if (ModConfig.numbers.showPercent) {
            h1 = blood * 5;
        }
        int xStart = width / 2 + 10;
        int yStart = height - this.getSidedOffset();
        ModUtils.drawStringOnHUD(h1 + "", xStart + 9 * (ModConfig.general.displayIcons ? 1 : 0) + 82, yStart - 1, c);
    }

    @Override
    public void renderIcon(EntityPlayer player, int width, int height) {
        int xStart = width / 2 + 10;
        int yStart = height - this.getSidedOffset();
        ModUtils.mc.func_110434_K().func_110577_a(VAMPIRISM_ICONS);
        GlStateManager.func_179147_l();
        ModUtils.drawTexturedModalRect(xStart + 82, yStart, 0, 0, 9, 9);
        ModUtils.drawTexturedModalRect(xStart + 82, yStart, 9, 0, 9, 9);
    }

    @Override
    public String name() {
        return "blood";
    }
}

