/*
 * Decompiled with CFR 0.152.
 */
package tfar.classicbar.overlays.vanillaoverlays;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ISpecialArmor;
import tfar.classicbar.Color;
import tfar.classicbar.ColorUtils;
import tfar.classicbar.ModUtils;
import tfar.classicbar.config.ModConfig;
import tfar.classicbar.overlays.IBarOverlay;

public class ArmorRenderer
implements IBarOverlay {
    private float armorAlpha = 1.0f;
    private static EntityEquipmentSlot[] armorList = new EntityEquipmentSlot[]{EntityEquipmentSlot.HEAD, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.FEET};
    public boolean side;

    @Override
    public IBarOverlay setSide(boolean side) {
        this.side = side;
        return this;
    }

    @Override
    public boolean rightHandSide() {
        return this.side;
    }

    @Override
    public boolean shouldRender(EntityPlayer player) {
        return ArmorRenderer.calculateArmorValue() >= 1;
    }

    @Override
    public void renderBar(EntityPlayer player, int width, int height) {
        int warningAmount;
        double armor = ArmorRenderer.calculateArmorValue();
        int n = warningAmount = ModConfig.general.overlays.lowArmorWarning ? ArmorRenderer.getDamagedAmount(player) : 0;
        if (warningAmount > 0) {
            this.armorAlpha = (int)(Minecraft.func_71386_F() / 250L) % 2;
        }
        int xStart = width / 2 - 91;
        int yStart = height - this.getSidedOffset();
        ModUtils.mc.field_71424_I.func_76320_a("armor");
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        int index = (int)Math.min(Math.ceil(armor / 20.0) - 1.0, (double)(ModConfig.colors.advancedColors.armorColorValues.length - 1));
        armor -= (double)warningAmount;
        if (armor + (double)warningAmount <= 20.0) {
            if (!ModConfig.general.overlays.fullArmorBar) {
                ModUtils.drawScaledBar(armor + (double)warningAmount, 20.0, xStart, yStart, true);
            } else {
                ModUtils.drawTexturedModalRect(xStart, yStart, 0, 0, 81, 9);
            }
            ColorUtils.hex2Color(ModConfig.colors.advancedColors.armorColorValues[0]).color2Gl();
            ModUtils.drawTexturedModalRect(xStart + 1, yStart + 1, 1, 10, ModUtils.getWidth(armor, 20.0), 7);
            ColorUtils.hex2Color(ModConfig.colors.advancedColors.armorColorValues[0]).color2Gla(this.armorAlpha);
            ModUtils.drawTexturedModalRect(xStart + 1, yStart + 1, 1, 10, ModUtils.getWidth(armor + (double)warningAmount, 20.0), 7);
        } else {
            ModUtils.drawTexturedModalRect(xStart, yStart, 0, 0, 81, 9);
            if (warningAmount != 0 || index < ModConfig.colors.advancedColors.armorColorValues.length && (armor + (double)warningAmount) % 20.0 != 0.0) {
                ColorUtils.hex2Color(ModConfig.colors.advancedColors.armorColorValues[index - 1]).color2Gl();
                ModUtils.drawTexturedModalRect(xStart + 1, yStart + 1, 1, 10, 79, 7);
                ColorUtils.hex2Color(ModConfig.colors.advancedColors.armorColorValues[index]).color2Gl();
                ModUtils.drawTexturedModalRect(xStart + 1, yStart + 1, 1, 10, ModUtils.getWidth(armor % 20.0, 20.0), 7);
            } else {
                ColorUtils.hex2Color(ModConfig.colors.advancedColors.armorColorValues[index]).color2Gl();
                ModUtils.drawTexturedModalRect(xStart + 1, yStart + 1, 1, 10, 79, 7);
            }
            if (warningAmount > 0 && (int)Math.ceil(((double)warningAmount + armor) / 20.0) == (int)Math.ceil(armor / 20.0)) {
                ColorUtils.hex2Color(ModConfig.colors.advancedColors.armorColorValues[index]).color2Gla(this.armorAlpha);
                ModUtils.drawTexturedModalRect(xStart + 1, yStart, 1, 10, ModUtils.getWidth(armor + (double)warningAmount - (double)(index * 20), 20.0), 7);
            }
        }
        Color.reset();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
        ModUtils.mc.field_71424_I.func_76319_b();
    }

    @Override
    public boolean shouldRenderText() {
        return ModConfig.numbers.showArmorNumbers;
    }

    public static int getDamagedAmount(EntityPlayer player) {
        int warningAmount = 0;
        for (EntityEquipmentSlot slot : armorList) {
            ItemStack stack = player.func_184582_a(slot);
            if (!(stack.func_77973_b() instanceof ItemArmor)) continue;
            int max = stack.func_77958_k();
            int current = stack.func_77952_i();
            int percentage = 100;
            if (max != 0) {
                percentage = 100 * (max - current) / max;
            }
            if (percentage >= 5) continue;
            warningAmount += ((ItemArmor)stack.func_77973_b()).func_82812_d().func_78044_b(slot);
        }
        return warningAmount;
    }

    @Override
    public void renderText(EntityPlayer player, int width, int height) {
        int xStart = width / 2 - 91;
        int yStart = height - this.getSidedOffset();
        double armor = ArmorRenderer.calculateArmorValue();
        int index = (int)Math.min(Math.ceil(armor / 20.0) - 1.0, (double)(ModConfig.colors.advancedColors.armorColorValues.length - 1));
        int warningAmount = ArmorRenderer.getDamagedAmount(player);
        int i1 = (int)Math.floor(armor + (double)warningAmount);
        int i3 = ModConfig.general.displayIcons ? 1 : 0;
        int c = Integer.decode(ModConfig.colors.advancedColors.armorColorValues[index]);
        if (ModConfig.numbers.showPercent) {
            i1 = (int)(armor + (double)warningAmount) * 5;
        }
        int i2 = ModUtils.getStringLength(i1 + "");
        ModUtils.drawStringOnHUD(i1 + "", xStart - 9 * i3 - i2 + -5, yStart - 1, c);
    }

    @Override
    public void renderIcon(EntityPlayer player, int width, int height) {
        ModUtils.mc.func_110434_K().func_110577_a(Gui.field_110324_m);
        int xStart = width / 2 - 91;
        int yStart = height - this.getSidedOffset();
        Color.reset();
        ModUtils.drawTexturedModalRect(xStart - 10, yStart, 43, 9, 9, 9);
    }

    @Override
    public String name() {
        return "armor";
    }

    private static int calculateArmorValue() {
        int currentArmorValue = ModUtils.mc.field_71439_g.func_70658_aO();
        for (ItemStack itemStack : ModUtils.mc.field_71439_g.func_184193_aE()) {
            if (!(itemStack.func_77973_b() instanceof ISpecialArmor)) continue;
            ISpecialArmor specialArmor = (ISpecialArmor)itemStack.func_77973_b();
            currentArmorValue += specialArmor.getArmorDisplay((EntityPlayer)ModUtils.mc.field_71439_g, itemStack, 0);
        }
        return currentArmorValue;
    }
}

