/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.climaticbiome.biomes;

import jaredbgreat.climaticbiome.biomes.basic.ActiveVolcano;
import jaredbgreat.climaticbiome.biomes.basic.CoolPlains;
import jaredbgreat.climaticbiome.biomes.basic.MontaneForest;
import jaredbgreat.climaticbiome.biomes.basic.Pinewoods;
import jaredbgreat.climaticbiome.biomes.basic.Scrub;
import jaredbgreat.climaticbiome.biomes.basic.SubtropicalMountains;
import jaredbgreat.climaticbiome.biomes.basic.TropicalForest;
import jaredbgreat.climaticbiome.biomes.basic.TropicalMountains;
import jaredbgreat.climaticbiome.biomes.basic.WarmForest;
import jaredbgreat.climaticbiome.biomes.basic.Wetland;
import jaredbgreat.climaticbiome.biomes.basic.WindsweptPlains;
import jaredbgreat.climaticbiome.biomes.pseudo.PseudoBiomes;
import jaredbgreat.climaticbiome.configuration.ConfigHandler;
import jaredbgreat.climaticbiome.generation.biome.biomes.GetRiver;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeBeach;
import net.minecraft.world.biome.BiomeHills;
import net.minecraft.world.biome.BiomePlains;
import net.minecraft.world.biome.BiomeRiver;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class ModBiomes {
    public static WarmForest warmForest;
    public static TropicalForest tropicalForest;
    public static WarmForest warmForestHills;
    public static TropicalForest tropicalForestHills;
    public static Pinewoods pineWoods;
    public static Scrub denseScrub;
    public static Scrub dryScrub;
    public static Scrub denseScrubHills;
    public static Scrub dryScrubHills;
    public static BiomePlains coolPlains;
    public static WindsweptPlains windswept;
    public static WindsweptPlains coolWindswept;
    public static CoolPlains coldPlains;
    public static Wetland bog;
    public static Wetland carr;
    public static Wetland marsh;
    public static BiomeBeach coast;
    public static BiomeBeach frozenCoast;
    public static SubtropicalMountains warmMountain;
    public static SubtropicalMountains warmMountainTrees;
    public static TropicalMountains hotMountain;
    public static TropicalMountains hotMountainTrees;
    public static ActiveVolcano activeVolcano;
    public static MontaneForest coolMontaneForest;
    public static MontaneForest warmMontaneForest;
    public static MontaneForest mediMontaneForest;
    public static MontaneForest montaneJungle;
    public static BiomeRiver coolRiver;
    public static BiomeRiver river;
    public static BiomeRiver warmRiver;
    public static BiomeRiver hotRiver;

    public static void createBiomes() {
        if (ConfigHandler.includeForests) {
            ModBiomes.createForests();
        }
        ModBiomes.createScrub();
        if (ConfigHandler.includeMountains) {
            ModBiomes.createMountains();
        }
        if (ConfigHandler.includePlains) {
            ModBiomes.createPlains();
        }
        if (ConfigHandler.includeSwamps) {
            ModBiomes.createSwamps();
        }
        PseudoBiomes.createBiomes();
        if (ConfigHandler.includeRivers) {
            ModBiomes.makeAdvancedRivers();
        }
        ModBiomes.createCoasts();
    }

    private static void createForests() {
        warmForest = new WarmForest();
        ModBiomes.makeMoreUsable((Biome)warmForest);
        tropicalForest = new TropicalForest();
        ModBiomes.makeMoreUsable((Biome)tropicalForest);
        pineWoods = new Pinewoods();
        ModBiomes.makeMoreUsable((Biome)pineWoods);
        warmForestHills = new WarmForest(new Biome.BiomeProperties("Subtropical Forest Hills").func_185410_a(0.8f).func_185395_b(0.85f).func_185398_c(0.45f).func_185400_d(0.3f));
        ModBiomes.makeMoreUsable((Biome)warmForestHills);
        tropicalForestHills = new TropicalForest(new Biome.BiomeProperties("Tropical Forest Hills").func_185410_a(0.9f).func_185395_b(0.7f).func_185398_c(0.45f).func_185400_d(0.3f));
        ModBiomes.makeMoreUsable((Biome)tropicalForestHills);
    }

    private static void createScrub() {
        denseScrub = new Scrub(Scrub.Type.DENSE, new Biome.BiomeProperties("Dense Scrub").func_185410_a(1.0f).func_185395_b(0.1f).func_185398_c(0.125f).func_185400_d(0.05f));
        ModBiomes.makeMoreUsable(denseScrub, true);
        dryScrub = new Scrub(Scrub.Type.DRY, new Biome.BiomeProperties("Dry Scrub").func_185410_a(1.25f).func_185395_b(0.05f).func_185396_a().func_185398_c(0.125f).func_185400_d(0.05f));
        ModBiomes.makeMoreUsable(dryScrub);
        denseScrubHills = new Scrub(Scrub.Type.DENSE, new Biome.BiomeProperties("Dense Scrub Hills").func_185410_a(1.0f).func_185395_b(0.1f).func_185398_c(0.45f).func_185400_d(0.3f));
        ModBiomes.makeMoreUsable(denseScrubHills);
        dryScrubHills = new Scrub(Scrub.Type.DRY, new Biome.BiomeProperties("Dry Scrub Hills").func_185410_a(1.25f).func_185395_b(0.0f).func_185396_a().func_185398_c(0.45f).func_185400_d(0.3f));
        ModBiomes.makeMoreUsable(dryScrubHills);
    }

    private static void createMountains() {
        warmMountain = new SubtropicalMountains(BiomeHills.Type.NORMAL, new Biome.BiomeProperties("Warm Extreme Hills").func_185410_a(0.6f).func_185395_b(0.3f).func_185398_c(1.0f).func_185400_d(0.5f));
        ModBiomes.makeMoreUsable((Biome)warmMountain);
        warmMountainTrees = new SubtropicalMountains(BiomeHills.Type.EXTRA_TREES, new Biome.BiomeProperties("Warm Forested Extreme Hills").func_185410_a(0.6f).func_185395_b(0.65f).func_185398_c(1.0f).func_185400_d(0.5f));
        ModBiomes.makeMoreUsable((Biome)warmMountainTrees);
        hotMountain = new TropicalMountains(BiomeHills.Type.NORMAL, new Biome.BiomeProperties("Tropical Extreme Hills").func_185410_a(0.8f).func_185395_b(0.3f).func_185398_c(1.0f).func_185400_d(0.5f));
        ModBiomes.makeMoreUsable((Biome)warmMountain);
        hotMountainTrees = new TropicalMountains(BiomeHills.Type.EXTRA_TREES, new Biome.BiomeProperties("Tropical Forested Extreme Hills").func_185410_a(0.8f).func_185395_b(0.8f).func_185398_c(1.0f).func_185400_d(0.5f));
        ModBiomes.makeMoreUsable((Biome)hotMountainTrees);
        ModBiomes.makeMoreUsable((Biome)pineWoods);
        if (ConfigHandler.includeVolcano) {
            activeVolcano = new ActiveVolcano(new Biome.BiomeProperties("Active Volcano").func_185410_a(3.0f).func_185395_b(0.5f).func_185398_c(1.5f).func_185400_d(0.5f));
        }
        coolMontaneForest = new MontaneForest(MontaneForest.Type.COOL, new Biome.BiomeProperties("Cool Montane Forest").func_185410_a(0.2f).func_185395_b(0.7f).func_185398_c(1.25f).func_185400_d(0.5f));
        ModBiomes.makeMoreUsable(coolMontaneForest);
        warmMontaneForest = new MontaneForest(MontaneForest.Type.WARM, new Biome.BiomeProperties("Warm Montane Forest").func_185410_a(0.6f).func_185395_b(0.7f).func_185398_c(1.25f).func_185400_d(0.5f));
        ModBiomes.makeMoreUsable(warmMontaneForest);
        montaneJungle = new MontaneForest(MontaneForest.Type.HOT, new Biome.BiomeProperties("Montane Jungle").func_185410_a(0.9f).func_185395_b(1.0f).func_185398_c(1.25f).func_185400_d(0.5f));
        ModBiomes.makeMoreUsable(montaneJungle);
        mediMontaneForest = new MontaneForest(MontaneForest.Type.MEDITERRANIAN, new Biome.BiomeProperties("Dry Montane Forest").func_185410_a(0.7f).func_185395_b(0.5f).func_185398_c(1.25f).func_185400_d(0.5f));
        ModBiomes.makeMoreUsable(mediMontaneForest);
    }

    private static void createPlains() {
        coolPlains = new CoolPlains(false, false, new Biome.BiomeProperties("Cool Plains").func_185410_a(0.5f).func_185395_b(0.5f).func_185398_c(0.125f).func_185400_d(0.05f));
        ModBiomes.makeMoreUsable((Biome)coolPlains);
        BiomeManager.addVillageBiome((Biome)coolPlains, (boolean)true);
        windswept = new WindsweptPlains(new Biome.BiomeProperties("Windswept Plains").func_185410_a(0.8f).func_185395_b(0.3f).func_185398_c(0.125f).func_185400_d(0.0f));
        ModBiomes.makeMoreUsable(windswept);
        BiomeManager.addVillageBiome((Biome)windswept, (boolean)true);
        coolWindswept = new WindsweptPlains(new Biome.BiomeProperties("Cool Windswept Plains").func_185410_a(0.5f).func_185395_b(0.3f).func_185398_c(0.125f).func_185400_d(0.0f));
        ModBiomes.makeMoreUsable(coolWindswept);
        BiomeManager.addVillageBiome((Biome)coolWindswept, (boolean)true);
        coldPlains = new CoolPlains(false, true, new Biome.BiomeProperties("Cold Plains").func_185410_a(0.2f).func_185395_b(0.3f).func_185398_c(0.125f).func_185400_d(0.05f));
        ModBiomes.makeMoreUsable((Biome)coldPlains);
        BiomeManager.addVillageBiome((Biome)coldPlains, (boolean)true);
    }

    private static void createSwamps() {
        bog = new Wetland(Wetland.Type.BOG, new Biome.BiomeProperties("Bog").func_185410_a(0.4f).func_185395_b(0.9f).func_185398_c(-0.2f).func_185400_d(0.1f));
        ModBiomes.makeMoreUsable((Biome)bog);
        carr = new Wetland(Wetland.Type.CARR, new Biome.BiomeProperties("Carr").func_185410_a(0.6f).func_185395_b(0.9f).func_185398_c(-0.2f).func_185400_d(0.1f));
        ModBiomes.makeMoreUsable((Biome)carr);
        marsh = new Wetland(Wetland.Type.MARSH, new Biome.BiomeProperties("Marsh").func_185410_a(0.6f).func_185395_b(0.9f).func_185398_c(-0.2f).func_185400_d(0.1f));
        ModBiomes.makeMoreUsable((Biome)marsh);
    }

    private static void createCoasts() {
        coast = new BiomeBeach(new Biome.BiomeProperties("Coastal Waters").func_185398_c(-0.5f).func_185400_d(0.025f).func_185410_a(0.8f).func_185395_b(0.4f));
        frozenCoast = new BiomeBeach(new Biome.BiomeProperties("Frozen Coastal Waters").func_185398_c(-0.5f).func_185400_d(0.025f).func_185410_a(0.0f).func_185395_b(0.4f).func_185411_b());
    }

    @SubscribeEvent
    public static void registerBiomes(RegistryEvent.Register<Biome> event) {
        if (ConfigHandler.includeForests) {
            ModBiomes.registerForests(event);
        }
        ModBiomes.registerScrub(event);
        if (ConfigHandler.includeMountains) {
            ModBiomes.registerMountains(event);
        }
        if (ConfigHandler.includePlains) {
            ModBiomes.registerPlains(event);
        }
        if (ConfigHandler.includeSwamps) {
            ModBiomes.registerSwamps(event);
        }
        PseudoBiomes.registerBiomes();
        if (ConfigHandler.includeRivers) {
            ModBiomes.registerAdvancedRivers(event);
        }
        ModBiomes.registerCoast(event);
    }

    private static void registerForests(RegistryEvent.Register<Biome> event) {
        event.getRegistry().register(warmForest.setRegistryName("subtropical_forest"));
        event.getRegistry().register(tropicalForest.setRegistryName("tropical_forest"));
        event.getRegistry().register(pineWoods.setRegistryName("pine_swamp"));
        event.getRegistry().register(warmForestHills.setRegistryName("subtropical_forest_hills"));
        event.getRegistry().register(tropicalForestHills.setRegistryName("tropical_forest_hills"));
        BiomeDictionary.addTypes((Biome)warmForest, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.CONIFEROUS});
        BiomeDictionary.addTypes((Biome)tropicalForest, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.HOT});
        BiomeDictionary.addTypes((Biome)pineWoods, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.WET, BiomeDictionary.Type.HOT, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.SAVANNA});
        BiomeDictionary.addTypes((Biome)warmForestHills, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.HILLS});
        BiomeDictionary.addTypes((Biome)tropicalForestHills, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.HOT, BiomeDictionary.Type.HILLS});
    }

    private static void registerScrub(RegistryEvent.Register<Biome> event) {
        event.getRegistry().register(denseScrub.setRegistryName("dense_scrub"));
        event.getRegistry().register(dryScrub.setRegistryName("dry_scrub"));
        event.getRegistry().register(denseScrubHills.setRegistryName("dense_scrub_hills"));
        event.getRegistry().register(dryScrubHills.setRegistryName("dry_scrub_hills"));
        BiomeDictionary.addTypes((Biome)denseScrub, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY});
        BiomeDictionary.addTypes((Biome)dryScrub, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SANDY});
        BiomeDictionary.addTypes((Biome)denseScrubHills, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY, BiomeDictionary.Type.HILLS});
        BiomeDictionary.addTypes((Biome)dryScrubHills, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.SANDY});
    }

    private static void registerMountains(RegistryEvent.Register<Biome> event) {
        event.getRegistry().register(warmMountain.setRegistryName("warm_mountain"));
        event.getRegistry().register(warmMountainTrees.setRegistryName("warm_mountain_trees"));
        event.getRegistry().register(hotMountain.setRegistryName("hot_mountain"));
        event.getRegistry().register(hotMountainTrees.setRegistryName("hot_mountain_trees"));
        if (ConfigHandler.includeVolcano) {
            event.getRegistry().register(activeVolcano.setRegistryName("active_volcano"));
        }
        event.getRegistry().register(coolMontaneForest.setRegistryName("cool_montane_forest"));
        event.getRegistry().register(warmMontaneForest.setRegistryName("warm_montane_forest"));
        event.getRegistry().register(montaneJungle.setRegistryName("montane_jungle"));
        event.getRegistry().register(mediMontaneForest.setRegistryName("dry_montane_forest"));
        BiomeDictionary.addTypes((Biome)warmMountain, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.HILLS, BiomeDictionary.Type.MOUNTAIN});
        BiomeDictionary.addTypes((Biome)warmMountainTrees, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.HILLS, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.FOREST});
        BiomeDictionary.addTypes((Biome)hotMountain, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.HILLS, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.HOT});
        BiomeDictionary.addTypes((Biome)hotMountainTrees, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.HILLS, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.HOT});
        if (ConfigHandler.includeVolcano) {
            BiomeDictionary.addTypes((Biome)activeVolcano, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.HILLS, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.HOT, BiomeDictionary.Type.WASTELAND});
        }
        BiomeDictionary.addTypes((Biome)coolMontaneForest, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.HILLS, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.COLD, BiomeDictionary.Type.FOREST});
        BiomeDictionary.addTypes((Biome)warmMontaneForest, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.HILLS, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.FOREST});
        BiomeDictionary.addTypes((Biome)montaneJungle, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.HILLS, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.HOT, BiomeDictionary.Type.WET});
        BiomeDictionary.addTypes((Biome)mediMontaneForest, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.HILLS, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY});
    }

    private static void registerPlains(RegistryEvent.Register<Biome> event) {
        event.getRegistry().register(coolPlains.setRegistryName("cool_plains"));
        event.getRegistry().register(windswept.setRegistryName("windswept_plains"));
        event.getRegistry().register(coolWindswept.setRegistryName("cool_windswept_plains"));
        event.getRegistry().register(coldPlains.setRegistryName("cold_plains"));
        BiomeDictionary.addTypes((Biome)coolPlains, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.PLAINS});
        BiomeDictionary.addTypes((Biome)windswept, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.PLAINS});
        BiomeDictionary.addTypes((Biome)coolWindswept, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.PLAINS});
        BiomeDictionary.addTypes((Biome)coldPlains, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.COLD});
    }

    private static void registerSwamps(RegistryEvent.Register<Biome> event) {
        event.getRegistry().register(bog.setRegistryName("bog"));
        event.getRegistry().register(carr.setRegistryName("carr"));
        event.getRegistry().register(marsh.setRegistryName("marsh"));
        BiomeDictionary.addTypes((Biome)bog, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.COLD, BiomeDictionary.Type.WET});
        BiomeDictionary.addTypes((Biome)carr, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.WET});
        BiomeDictionary.addTypes((Biome)marsh, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.WET});
    }

    private static void registerCoast(RegistryEvent.Register<Biome> event) {
        event.getRegistry().register(coast.setRegistryName("coastal_waters"));
        event.getRegistry().register(frozenCoast.setRegistryName("frozen_coastal_waters"));
        BiomeDictionary.addTypes((Biome)coast, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.BEACH, BiomeDictionary.Type.OCEAN});
        BiomeDictionary.addTypes((Biome)frozenCoast, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.BEACH, BiomeDictionary.Type.OCEAN, BiomeDictionary.Type.COLD, BiomeDictionary.Type.SNOWY});
    }

    private static void makeMoreUsable(Biome biome) {
        BiomeManager.addSpawnBiome((Biome)biome);
        BiomeManager.addStrongholdBiome((Biome)biome);
    }

    private static void makeMoreUsable(Biome biome, boolean villages) {
        BiomeManager.addSpawnBiome((Biome)biome);
        BiomeManager.addStrongholdBiome((Biome)biome);
        if (villages) {
            BiomeManager.addVillageBiome((Biome)biome, (boolean)villages);
        }
    }

    private static void makeAdvancedRivers() {
        river = new BiomeRiver(new Biome.BiomeProperties("Temporate River").func_185398_c(-0.8f).func_185400_d(0.0f).func_185410_a(0.7f).func_185395_b(0.5f).func_185411_b());
        warmRiver = new BiomeRiver(new Biome.BiomeProperties("Subtropical River").func_185398_c(-0.8f).func_185400_d(0.0f).func_185410_a(0.8f).func_185395_b(0.5f).func_185411_b());
        hotRiver = new BiomeRiver(new Biome.BiomeProperties("Tropical River").func_185398_c(-0.8f).func_185400_d(0.0f).func_185410_a(1.0f).func_185395_b(0.5f).func_185411_b());
    }

    private static void registerAdvancedRivers(RegistryEvent.Register<Biome> event) {
        event.getRegistry().register(river.setRegistryName("temperate_river"));
        event.getRegistry().register(warmRiver.setRegistryName("subtropical_river"));
        event.getRegistry().register(hotRiver.setRegistryName("tropical_river"));
        BiomeDictionary.addTypes((Biome)river, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.RIVER, BiomeDictionary.Type.WATER});
        BiomeDictionary.addTypes((Biome)warmRiver, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.RIVER, BiomeDictionary.Type.WATER});
        BiomeDictionary.addTypes((Biome)hotRiver, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.RIVER, BiomeDictionary.Type.WATER, BiomeDictionary.Type.HOT});
        GetRiver.initAdvanced();
    }

    public static void addToVanilla() {
        if (ConfigHandler.includeForests) {
            ModBiomes.addForests2MC();
        }
        ModBiomes.addScrub2MC();
        if (ConfigHandler.includeMountains) {
            ModBiomes.addMountains2MC();
        }
        if (ConfigHandler.includePlains) {
            ModBiomes.addPlains2MC();
        }
        if (ConfigHandler.includeSwamps) {
            ModBiomes.addSwamps2MC();
        }
    }

    private static void addForests2MC() {
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry((Biome)warmForest, 5));
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry((Biome)tropicalForest, 5));
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry((Biome)warmForestHills, 5));
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry((Biome)tropicalForestHills, 5));
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry((Biome)pineWoods, 5));
    }

    private static void addScrub2MC() {
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.DESERT, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry((Biome)denseScrub, 5));
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.DESERT, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry((Biome)denseScrubHills, 5));
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.DESERT, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry((Biome)dryScrub, 5));
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.DESERT, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry((Biome)dryScrubHills, 5));
    }

    private static void addMountains2MC() {
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry((Biome)warmMountain, 5));
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry((Biome)warmMountainTrees, 5));
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry((Biome)hotMountain, 5));
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry((Biome)hotMountainTrees, 5));
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry((Biome)warmMontaneForest, 5));
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry((Biome)montaneJungle, 5));
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.DESERT, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry((Biome)mediMontaneForest, 5));
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.COOL, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry((Biome)coolMontaneForest, 10));
        if (ConfigHandler.includeVolcano) {
            BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.ICY, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry((Biome)activeVolcano, 1));
            BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.COOL, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry((Biome)activeVolcano, 1));
            BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry((Biome)activeVolcano, 1));
            BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.DESERT, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry((Biome)activeVolcano, 1));
        }
    }

    private static void addPlains2MC() {
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry((Biome)windswept, 5));
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.COOL, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry((Biome)coolPlains, 5));
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.COOL, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry((Biome)coldPlains, 5));
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.COOL, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry((Biome)coolWindswept, 5));
    }

    private static void addSwamps2MC() {
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry((Biome)marsh, 5));
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.COOL, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry((Biome)bog, 5));
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.COOL, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry((Biome)carr, 10));
    }
}

