/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.climaticbiome.biomes;

import jaredbgreat.climaticbiome.biomes.SubBiome;
import jaredbgreat.climaticbiome.configuration.ConfigHandler;

public class SubBiomeRegistry {
    private static SubBiomeRegistry subreg;
    private SubBiome[] data = new SubBiome[384];
    private final int minSize;
    private int capacity = 256;
    private int lowLimit = 0;
    private int length = 0;

    private SubBiomeRegistry() {
        this.minSize = 384;
    }

    public static SubBiomeRegistry getSubBiomeRegistry() {
        if (subreg == null) {
            subreg = new SubBiomeRegistry();
        }
        return subreg;
    }

    private int xorshift(int in) {
        in ^= in << 11;
        in ^= in >> 5;
        in ^= in << 17;
        in ^= in >> 13;
        return in &= Integer.MAX_VALUE;
    }

    private int xorshift(long in) {
        in ^= in << 11;
        in ^= in >> 5;
        in ^= in << 17;
        in ^= in >> 13;
        return (int)((in &= Integer.MAX_VALUE) & 0xFFFFFFFFL);
    }

    public void add(SubBiome item) {
        int bucket = this.xorshift(item.getSubId()) % this.data.length;
        for (int offset = 0; offset < this.data.length; ++offset) {
            int slot = (bucket + offset) % this.data.length;
            if (this.data[slot] == null) {
                this.data[slot] = item;
                if (++this.length > this.capacity) {
                    this.grow();
                }
                return;
            }
            if (this.data[slot].getSubId() != item.getSubId()) continue;
            return;
        }
    }

    public SubBiome get(int id) {
        return this.get(this.expandID(id));
    }

    public SubBiome get(long id) {
        int bucket = this.xorshift(id) % this.data.length;
        for (int offset = 0; offset < this.data.length; ++offset) {
            int slot = (bucket + offset) % this.data.length;
            if (this.data[slot] == null) {
                this.showError((int)id);
                return null;
            }
            if (this.data[slot].getSubId() != id) continue;
            return this.data[slot];
        }
        this.showError((int)id);
        return null;
    }

    private long expandID(long id) {
        return (id & 0xFFL) + ((id & 0xFF00L) << 24);
    }

    private void showError(long id) {
        if (ConfigHandler.badBiomeSpam) {
            System.err.println();
            System.err.println("*******************************************");
            System.err.println("Returning NULL for subbiome id " + id);
            System.err.println("Subbiome " + id + " must be registeerd!");
            System.err.println("*******************************************");
            System.err.println();
        }
    }

    public boolean contains(int id) {
        int bucket = this.xorshift(id) % this.data.length;
        for (int offset = 0; offset < this.data.length; ++offset) {
            int slot = (bucket + offset) % this.data.length;
            if (this.data[slot] == null) {
                return false;
            }
            if (this.data[slot].getSubId() != (long)id) continue;
            return true;
        }
        return false;
    }

    private void grow() {
        SubBiome[] old = this.data;
        SubBiome[] data = new SubBiome[old.length * 3 / 2];
        for (int i = 0; i < old.length; ++i) {
            if (old[i] == null) continue;
            this.rebucket(old[i]);
        }
        this.capacity = data.length * 3 / 4;
        this.lowLimit = (data.length - this.minSize) * 3 / 16;
    }

    private void shrink() {
        SubBiome[] old = this.data;
        SubBiome[] data = new SubBiome[old.length / 2];
        for (int i = 0; i < old.length; ++i) {
            if (old[i] == null) continue;
            this.rebucket(old[i]);
        }
        this.capacity = data.length * 3 / 4;
        this.lowLimit = (data.length - this.minSize) * 3 / 16;
    }

    private void rebucket(SubBiome item) {
        int bucket = this.xorshift(item.getSubId()) % this.data.length;
        for (int offset = 0; offset <= this.data.length; ++offset) {
            int slot = (bucket + offset) % this.data.length;
            if (this.data[slot] != null && !((Object)((Object)this.data[slot])).equals((Object)item)) continue;
            this.data[slot] = item;
            return;
        }
    }
}

