/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.climaticbiome.compat.userdef;

import jaredbgreat.climaticbiome.ClimaticBiomes;
import jaredbgreat.climaticbiome.configuration.ConfigHandler;
import jaredbgreat.climaticbiome.exception.BiomeReadingException;
import jaredbgreat.climaticbiome.generation.biome.BiomeList;
import jaredbgreat.climaticbiome.generation.biome.IBiomeSpecifier;
import jaredbgreat.climaticbiome.generation.biome.IslandBiome;
import jaredbgreat.climaticbiome.generation.biome.LeafBiome;
import jaredbgreat.climaticbiome.generation.biome.MesaDoubleBiome;
import jaredbgreat.climaticbiome.generation.biome.NoiseDoubleBiome;
import jaredbgreat.climaticbiome.generation.biome.SeedDoubleBiome;
import jaredbgreat.climaticbiome.generation.biome.TempDoubleBiome;
import jaredbgreat.climaticbiome.generation.biome.TerrainBiome;
import jaredbgreat.climaticbiome.generation.biome.WetDoubleBiome;
import jaredbgreat.climaticbiome.generation.biome.biomes.GetTaiga;
import jaredbgreat.dldungeons.parser.Tokenizer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.Logger;
import org.jline.utils.Log;

public class BiomeParser {
    private IForgeRegistry biomeReg;
    private String fileDir;
    private HashMap<String, ICommand> commands;
    private BufferedReader reader1;
    private BufferedReader reader2;

    public BiomeParser(IForgeRegistry reg, File dir, String sub) {
        this.biomeReg = reg;
        this.fileDir = dir.toString() + File.separator + "BiomeConfig" + File.separator + sub + File.separator;
        File fd = new File(this.fileDir);
        if (!fd.exists()) {
            fd.mkdirs();
        }
        this.commands = new HashMap();
        this.commands.put("biome", new LeafParse());
        this.commands.put("noise", new NoiseParse());
        this.commands.put("seed", new SeedParse());
        this.commands.put("temp", new TempParse());
        this.commands.put("taiga", new TaigaParse());
        this.commands.put("wetness", new WetParse());
        this.commands.put("island", new IslandParse());
        this.commands.put("plateau", new MesaParse());
        this.commands.put("terrain", new TerrainParse());
    }

    public void makeBiomeList(BiomeList list, String filename) {
        File file = new File(this.fileDir + filename);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return;
        }
        String line = null;
        try {
            this.reader1 = new BufferedReader(new FileReader(file));
            while (this.reader1.ready()) {
                line = this.reader1.readLine().trim();
                if (line.isEmpty() || line.startsWith("#")) continue;
                Tokenizer tokens = new Tokenizer(line, "()");
                String tag = tokens.nextToken().toLowerCase().trim();
                try {
                    IBiomeSpecifier biomeSpec = this.commands.get(tag).parse(tokens.nextToken());
                    if (!biomeSpec.isEmpty()) {
                        list.addItem(biomeSpec);
                        continue;
                    }
                    ClimaticBiomes.logger.error("\nFailed to load biome: \n \t Tag: " + tag + "\n \t Full String: " + line + "\n \t File: " + filename + "\n");
                    if (!ConfigHandler.failfast) continue;
                    throw new BiomeReadingException();
                }
                catch (Exception e) {
                    ClimaticBiomes.logger.error("\nFailed to load biome: \n \t Tag: " + tag + "\n \t Full String: " + line + "\n \t File: " + filename + "\n");
                    e.printStackTrace();
                    throw e;
                }
            }
            this.reader1.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (RuntimeException e) {
            this.reportError(e, file, line);
        }
    }

    public void addSpecialBiomes(BiomeList list, String filename) {
        File file = new File(this.fileDir + filename);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return;
        }
        String line = null;
        try {
            this.reader2 = new BufferedReader(new FileReader(file));
            while (this.reader2.ready()) {
                line = this.reader2.readLine().trim();
                if (line.isEmpty() || line.startsWith("#")) continue;
                Tokenizer tokens = new Tokenizer(line, "()");
                String tag = tokens.nextToken().toLowerCase().trim();
                try {
                    IBiomeSpecifier biomeSpec = this.commands.get(tag).parse(tokens.nextToken());
                    if (!biomeSpec.isEmpty()) {
                        list.addItem(biomeSpec);
                        continue;
                    }
                    if (!ConfigHandler.failfast) continue;
                    ClimaticBiomes.logger.error("\nFailed to load biome: \n \t Tag: " + tag + "\n \t Full String: " + line + "\n \t File: " + filename + "\n");
                    throw new BiomeReadingException();
                }
                catch (Exception e) {
                    ClimaticBiomes.logger.error("\nFailed to load biome: \n \t Tag: " + tag + "\n \t Full String: " + line + "\n \t File: " + filename + "\n");
                    e.printStackTrace();
                    throw e;
                }
            }
            this.reader2.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (RuntimeException e) {
            this.reportError(e, file, line);
        }
    }

    private void reportError(RuntimeException ex, File file, String line) {
        Logger logger = FMLLog.log;
        Log.error((Object[])new Object[]{""});
        Log.error((Object[])new Object[]{"*****************************"});
        Log.error((Object[])new Object[]{"   Error in file: " + file});
        Log.error((Object[])new Object[]{"   " + line});
        Log.error((Object[])new Object[]{"   Caused excpetion: " + ex});
        Log.error((Object[])new Object[]{"*****************************"});
        Log.error((Object[])new Object[]{""});
        throw ex;
    }

    private final class IslandParse
    implements ICommand {
        private IslandParse() {
        }

        @Override
        public IBiomeSpecifier parse(String in) {
            return new IslandBiome(in, BiomeParser.this.biomeReg);
        }
    }

    private final class TerrainParse
    implements ICommand {
        private TerrainParse() {
        }

        @Override
        public IBiomeSpecifier parse(String in) {
            return new TerrainBiome(in, BiomeParser.this.biomeReg);
        }
    }

    private final class LeafParse
    implements ICommand {
        private LeafParse() {
        }

        @Override
        public IBiomeSpecifier parse(String in) {
            return new LeafBiome(in, BiomeParser.this.biomeReg);
        }
    }

    private final class WetParse
    implements ICommand {
        private WetParse() {
        }

        @Override
        public IBiomeSpecifier parse(String in) {
            Tokenizer tokens = new Tokenizer(in, ", \t");
            return new WetDoubleBiome(tokens.nextToken(), Integer.parseInt(tokens.nextToken()), tokens.nextToken(), BiomeParser.this.biomeReg);
        }
    }

    private final class TaigaParse
    implements ICommand {
        private TaigaParse() {
        }

        @Override
        public IBiomeSpecifier parse(String in) {
            Tokenizer tokens = new Tokenizer(in, ", \t");
            return new GetTaiga.TaigaDoubleBiome(tokens.nextToken(), tokens.nextToken(), BiomeParser.this.biomeReg);
        }
    }

    private final class TempParse
    implements ICommand {
        private TempParse() {
        }

        @Override
        public IBiomeSpecifier parse(String in) {
            Tokenizer tokens = new Tokenizer(in, ", \t");
            return new TempDoubleBiome(tokens.nextToken(), Integer.parseInt(tokens.nextToken()), tokens.nextToken(), BiomeParser.this.biomeReg);
        }
    }

    private final class SeedParse
    implements ICommand {
        private SeedParse() {
        }

        @Override
        public IBiomeSpecifier parse(String in) {
            Tokenizer tokens = new Tokenizer(in, ", \t");
            return new SeedDoubleBiome(tokens.nextToken(), Integer.parseInt(tokens.nextToken()), tokens.nextToken(), BiomeParser.this.biomeReg);
        }
    }

    private final class MesaParse
    implements ICommand {
        private MesaParse() {
        }

        @Override
        public IBiomeSpecifier parse(String in) {
            Tokenizer tokens = new Tokenizer(in, ", \t");
            return new MesaDoubleBiome(tokens.nextToken(), Integer.parseInt(tokens.nextToken()), tokens.nextToken(), BiomeParser.this.biomeReg);
        }
    }

    private final class NoiseParse
    implements ICommand {
        private NoiseParse() {
        }

        @Override
        public IBiomeSpecifier parse(String in) {
            Tokenizer tokens = new Tokenizer(in, ", \t");
            return new NoiseDoubleBiome(tokens.nextToken(), Integer.parseInt(tokens.nextToken()), tokens.nextToken(), BiomeParser.this.biomeReg);
        }
    }

    private static interface ICommand {
        public IBiomeSpecifier parse(String var1);
    }
}

