/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.climaticbiome.generation.biome;

import jaredbgreat.climaticbiome.configuration.ClimaticWorldSettings;
import jaredbgreat.climaticbiome.configuration.ConfigHandler;
import jaredbgreat.climaticbiome.generation.biome.IBiomeSpecifier;
import jaredbgreat.climaticbiome.generation.biome.biomes.GetAlpine;
import jaredbgreat.climaticbiome.generation.biome.biomes.GetBeach;
import jaredbgreat.climaticbiome.generation.biome.biomes.GetChaparral;
import jaredbgreat.climaticbiome.generation.biome.biomes.GetColdPlains;
import jaredbgreat.climaticbiome.generation.biome.biomes.GetCoolForest;
import jaredbgreat.climaticbiome.generation.biome.biomes.GetCoolPark;
import jaredbgreat.climaticbiome.generation.biome.biomes.GetCoolPlains;
import jaredbgreat.climaticbiome.generation.biome.biomes.GetDesert;
import jaredbgreat.climaticbiome.generation.biome.biomes.GetForest;
import jaredbgreat.climaticbiome.generation.biome.biomes.GetHotForest;
import jaredbgreat.climaticbiome.generation.biome.biomes.GetJungle;
import jaredbgreat.climaticbiome.generation.biome.biomes.GetOcean;
import jaredbgreat.climaticbiome.generation.biome.biomes.GetPark;
import jaredbgreat.climaticbiome.generation.biome.biomes.GetPlains;
import jaredbgreat.climaticbiome.generation.biome.biomes.GetRiver;
import jaredbgreat.climaticbiome.generation.biome.biomes.GetSavanna;
import jaredbgreat.climaticbiome.generation.biome.biomes.GetSwamp;
import jaredbgreat.climaticbiome.generation.biome.biomes.GetTaiga;
import jaredbgreat.climaticbiome.generation.biome.biomes.GetTundra;
import jaredbgreat.climaticbiome.generation.biome.biomes.GetWarmForest;
import jaredbgreat.climaticbiome.generation.biome.biomes.GetWarmPlains;
import jaredbgreat.climaticbiome.generation.mapgenerator.ChunkTile;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class BiomeClimateTable
implements IBiomeSpecifier {
    private static BiomeClimateTable main;
    private static LandBiomeTable land;
    private IBiomeSpecifier[] table;
    IBiomeSpecifier OCEAN;
    IBiomeSpecifier SWAMP;
    IBiomeSpecifier TUNDRA;
    IBiomeSpecifier CGRASS;
    IBiomeSpecifier GRASS;
    IBiomeSpecifier SGRASS;
    IBiomeSpecifier SAVANNA;
    IBiomeSpecifier TAIGA;
    IBiomeSpecifier PARK;
    IBiomeSpecifier FOREST;
    IBiomeSpecifier SFOREST;
    IBiomeSpecifier TFOREST;
    IBiomeSpecifier JUNGLE;
    IBiomeSpecifier DESERT;
    IBiomeSpecifier SCRUB;
    IBiomeSpecifier ALPINE;
    IBiomeSpecifier FORESTb;
    IBiomeSpecifier GRASSb;
    IBiomeSpecifier PARKb;
    IBiomeSpecifier RIVER;
    GetBeach BEACH;

    private BiomeClimateTable(IBiomeSpecifier ... table) {
        this.table = table;
    }

    private BiomeClimateTable(ClimaticWorldSettings settings) {
        this.init(settings);
    }

    public static BiomeClimateTable getClimateTable(ClimaticWorldSettings settings) {
        main = new BiomeClimateTable(settings);
        return main;
    }

    public static LandBiomeTable getLandTable() {
        if (land == null) {
            land = new LandBiomeTable();
        }
        return land;
    }

    @Override
    public long getBiome(ChunkTile tile) {
        long out;
        Biome outb;
        if (tile.isRiver()) {
            return this.RIVER.getBiome(tile);
        }
        if (tile.getRlBiome() == 0) {
            return this.OCEAN.getBiome(tile);
        }
        if (tile.getTemp() > 7 && (double)(tile.getWet() - tile.getVal()) - tile.getHeight() > 0.0) {
            if ((tile.getBiomeSeed() & 1) == 1) {
                tile.nextBiomeSeed();
                return this.SWAMP.getBiome(tile);
            }
            tile.nextBiomeSeed();
        }
        if ((outb = Biome.func_150568_d((int)((int)(out = this.table[tile.getTemp() * 10 + tile.getWet()].getBiome(tile))))) == null) {
            Logger.getLogger("minecraft").log(Level.SEVERE, "[CLIMATIC_BIOMES] Error! Could not find biome with id " + out + "; returning 0 (Ocean).  (Check your configs.)");
            return 0L;
        }
        if (tile.isBeach()) {
            if (BiomeDictionary.hasType((Biome)outb, (BiomeDictionary.Type)BiomeDictionary.Type.HILLS) || BiomeDictionary.hasType((Biome)outb, (BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN) || tile.isMountain()) {
                return out;
            }
            return this.BEACH.getBiome(tile);
        }
        return out;
    }

    @Override
    public boolean isEmpty() {
        return this.table == null || this.table.length < 250;
    }

    public void init(ClimaticWorldSettings settings) {
        land = BiomeClimateTable.getLandTable();
        this.OCEAN = GetOcean.getOcean(settings);
        this.SWAMP = GetSwamp.getSwamp();
        this.TUNDRA = GetTundra.getTundra();
        this.CGRASS = GetColdPlains.getPlains();
        this.GRASS = GetPlains.getPlains();
        this.SGRASS = GetWarmPlains.getPlains();
        this.SAVANNA = GetSavanna.getSavanna();
        this.TAIGA = GetTaiga.getTaiga();
        this.PARK = GetPark.getPark();
        this.FOREST = GetForest.getForest();
        this.SFOREST = GetWarmForest.getForest();
        this.TFOREST = GetHotForest.getForest();
        this.JUNGLE = GetJungle.getJungle();
        this.DESERT = GetDesert.getDesert();
        this.SCRUB = GetChaparral.getChaparral();
        this.ALPINE = GetAlpine.getAlpine();
        this.FORESTb = GetCoolForest.getForest();
        this.GRASSb = GetCoolPlains.getPlains();
        this.PARKb = GetCoolPark.getPark();
        this.RIVER = GetRiver.getRiver();
        this.BEACH = GetBeach.getBeach();
        if (ConfigHandler.useBoP || ConfigHandler.useBoPTable) {
            this.makeModdedTable();
        } else {
            this.makeVanillaTable();
        }
        land.init(this.table);
    }

    public void makeVanillaTable() {
        this.table = new IBiomeSpecifier[]{this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TAIGA, this.TAIGA, this.TAIGA, this.TAIGA, this.TAIGA, this.TAIGA, this.TAIGA, this.TAIGA, this.TUNDRA, this.CGRASS, this.TAIGA, this.TAIGA, this.TAIGA, this.TAIGA, this.TAIGA, this.TAIGA, this.TAIGA, this.TAIGA, this.CGRASS, this.CGRASS, this.TAIGA, this.TAIGA, this.TAIGA, this.TAIGA, this.TAIGA, this.TAIGA, this.TAIGA, this.TAIGA, this.CGRASS, this.CGRASS, this.TAIGA, this.TAIGA, this.TAIGA, this.TAIGA, this.TAIGA, this.TAIGA, this.TAIGA, this.TAIGA, this.CGRASS, this.CGRASS, this.TAIGA, this.TAIGA, this.TAIGA, this.TAIGA, this.TAIGA, this.TAIGA, this.TAIGA, this.TAIGA, this.GRASS, this.GRASS, this.GRASS, this.GRASS, this.PARK, this.FOREST, this.FOREST, this.FOREST, this.FOREST, this.FOREST, this.SCRUB, this.GRASS, this.GRASS, this.GRASS, this.PARK, this.FOREST, this.FOREST, this.FOREST, this.FOREST, this.FOREST, this.SCRUB, this.GRASS, this.GRASS, this.GRASS, this.PARK, this.FOREST, this.FOREST, this.FOREST, this.FOREST, this.FOREST, this.DESERT, this.SCRUB, this.GRASS, this.GRASS, this.PARK, this.FOREST, this.FOREST, this.FOREST, this.FOREST, this.FOREST, this.DESERT, this.DESERT, this.SCRUB, this.GRASS, this.PARK, this.FOREST, this.FOREST, this.FOREST, this.FOREST, this.FOREST, this.DESERT, this.DESERT, this.DESERT, this.SCRUB, this.SGRASS, this.SFOREST, this.SFOREST, this.SFOREST, this.SFOREST, this.SFOREST, this.DESERT, this.DESERT, this.DESERT, this.SCRUB, this.SGRASS, this.SFOREST, this.SFOREST, this.SFOREST, this.SFOREST, this.JUNGLE, this.DESERT, this.DESERT, this.DESERT, this.SCRUB, this.SGRASS, this.SFOREST, this.SFOREST, this.SFOREST, this.SFOREST, this.JUNGLE, this.DESERT, this.DESERT, this.DESERT, this.SCRUB, this.SGRASS, this.SFOREST, this.SFOREST, this.SFOREST, this.JUNGLE, this.JUNGLE, this.DESERT, this.DESERT, this.DESERT, this.SCRUB, this.SGRASS, this.SFOREST, this.SFOREST, this.JUNGLE, this.JUNGLE, this.JUNGLE, this.DESERT, this.DESERT, this.SAVANNA, this.SAVANNA, this.TFOREST, this.TFOREST, this.JUNGLE, this.JUNGLE, this.JUNGLE, this.JUNGLE, this.DESERT, this.SAVANNA, this.SAVANNA, this.SAVANNA, this.TFOREST, this.JUNGLE, this.JUNGLE, this.JUNGLE, this.JUNGLE, this.JUNGLE, this.DESERT, this.SAVANNA, this.SAVANNA, this.SAVANNA, this.TFOREST, this.JUNGLE, this.JUNGLE, this.JUNGLE, this.JUNGLE, this.JUNGLE, this.DESERT, this.SAVANNA, this.SAVANNA, this.TFOREST, this.TFOREST, this.JUNGLE, this.JUNGLE, this.JUNGLE, this.JUNGLE, this.JUNGLE, this.DESERT, this.SAVANNA, this.TFOREST, this.TFOREST, this.JUNGLE, this.JUNGLE, this.JUNGLE, this.JUNGLE, this.JUNGLE, this.JUNGLE};
    }

    public void makeModdedTable() {
        this.table = new IBiomeSpecifier[]{this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TAIGA, this.TAIGA, this.TAIGA, this.TAIGA, this.TAIGA, this.TAIGA, this.TAIGA, this.TAIGA, this.TUNDRA, this.CGRASS, this.TAIGA, this.TAIGA, this.TAIGA, this.TAIGA, this.TAIGA, this.TAIGA, this.TAIGA, this.TAIGA, this.CGRASS, this.CGRASS, this.TAIGA, this.TAIGA, this.TAIGA, this.TAIGA, this.TAIGA, this.TAIGA, this.TAIGA, this.TAIGA, this.CGRASS, this.CGRASS, this.TAIGA, this.TAIGA, this.TAIGA, this.TAIGA, this.TAIGA, this.TAIGA, this.TAIGA, this.TAIGA, this.GRASSb, this.GRASSb, this.GRASSb, this.GRASSb, this.PARKb, this.FORESTb, this.FORESTb, this.FORESTb, this.FORESTb, this.FORESTb, this.GRASSb, this.GRASSb, this.GRASSb, this.GRASSb, this.PARKb, this.FORESTb, this.FORESTb, this.FORESTb, this.FORESTb, this.FORESTb, this.GRASS, this.GRASSb, this.GRASSb, this.GRASSb, this.PARKb, this.FORESTb, this.FORESTb, this.FORESTb, this.FORESTb, this.FORESTb, this.GRASS, this.GRASS, this.GRASSb, this.GRASSb, this.PARKb, this.FORESTb, this.FORESTb, this.FORESTb, this.FORESTb, this.FORESTb, this.GRASS, this.GRASS, this.GRASS, this.GRASS, this.PARK, this.FOREST, this.FOREST, this.FOREST, this.FOREST, this.FOREST, this.SCRUB, this.GRASS, this.GRASS, this.GRASS, this.PARK, this.FOREST, this.FOREST, this.FOREST, this.FOREST, this.FOREST, this.DESERT, this.SCRUB, this.GRASS, this.GRASS, this.PARK, this.FOREST, this.FOREST, this.FOREST, this.FOREST, this.FOREST, this.DESERT, this.DESERT, this.SCRUB, this.GRASS, this.PARK, this.FOREST, this.FOREST, this.FOREST, this.FOREST, this.FOREST, this.DESERT, this.DESERT, this.DESERT, this.SCRUB, this.SGRASS, this.SFOREST, this.SFOREST, this.SFOREST, this.SFOREST, this.SFOREST, this.DESERT, this.DESERT, this.DESERT, this.SCRUB, this.SGRASS, this.SFOREST, this.SFOREST, this.SFOREST, this.SFOREST, this.JUNGLE, this.DESERT, this.DESERT, this.DESERT, this.SCRUB, this.SGRASS, this.SFOREST, this.SFOREST, this.SFOREST, this.SFOREST, this.JUNGLE, this.DESERT, this.DESERT, this.DESERT, this.SCRUB, this.SGRASS, this.SFOREST, this.SFOREST, this.SFOREST, this.JUNGLE, this.JUNGLE, this.DESERT, this.DESERT, this.DESERT, this.SCRUB, this.SGRASS, this.SFOREST, this.SFOREST, this.JUNGLE, this.JUNGLE, this.JUNGLE, this.DESERT, this.DESERT, this.SAVANNA, this.SAVANNA, this.TFOREST, this.TFOREST, this.JUNGLE, this.JUNGLE, this.JUNGLE, this.JUNGLE, this.DESERT, this.SAVANNA, this.SAVANNA, this.SAVANNA, this.TFOREST, this.JUNGLE, this.JUNGLE, this.JUNGLE, this.JUNGLE, this.JUNGLE, this.DESERT, this.SAVANNA, this.SAVANNA, this.TFOREST, this.JUNGLE, this.JUNGLE, this.JUNGLE, this.JUNGLE, this.JUNGLE, this.JUNGLE, this.DESERT, this.SAVANNA, this.TFOREST, this.JUNGLE, this.JUNGLE, this.JUNGLE, this.JUNGLE, this.JUNGLE, this.JUNGLE, this.JUNGLE};
    }

    public void makeEquatorTable() {
        this.table = new IBiomeSpecifier[]{this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TAIGA, this.TAIGA, this.TAIGA, this.TAIGA, this.TAIGA, this.TAIGA, this.TAIGA, this.TAIGA, this.CGRASS, this.CGRASS, this.TAIGA, this.TAIGA, this.TAIGA, this.TAIGA, this.TAIGA, this.TAIGA, this.TAIGA, this.TAIGA, this.GRASSb, this.GRASSb, this.GRASSb, this.GRASSb, this.PARKb, this.FORESTb, this.FORESTb, this.FORESTb, this.FORESTb, this.FORESTb, this.GRASSb, this.GRASSb, this.GRASSb, this.GRASSb, this.PARKb, this.FORESTb, this.FORESTb, this.FORESTb, this.FORESTb, this.FORESTb, this.GRASS, this.GRASS, this.GRASS, this.GRASS, this.PARK, this.FOREST, this.FOREST, this.FOREST, this.FOREST, this.FOREST, this.SCRUB, this.SCRUB, this.GRASS, this.GRASS, this.PARK, this.FOREST, this.FOREST, this.FOREST, this.FOREST, this.FOREST, this.DESERT, this.DESERT, this.SCRUB, this.GRASS, this.PARK, this.FOREST, this.FOREST, this.FOREST, this.FOREST, this.FOREST, this.DESERT, this.DESERT, this.DESERT, this.SCRUB, this.SGRASS, this.SFOREST, this.SFOREST, this.SFOREST, this.SFOREST, this.SFOREST, this.DESERT, this.DESERT, this.DESERT, this.SCRUB, this.SGRASS, this.SFOREST, this.SFOREST, this.SFOREST, this.SFOREST, this.JUNGLE, this.DESERT, this.SAVANNA, this.SAVANNA, this.SAVANNA, this.TFOREST, this.JUNGLE, this.JUNGLE, this.JUNGLE, this.JUNGLE, this.JUNGLE, this.DESERT, this.SAVANNA, this.SAVANNA, this.TFOREST, this.JUNGLE, this.JUNGLE, this.JUNGLE, this.JUNGLE, this.JUNGLE, this.JUNGLE, this.DESERT, this.SAVANNA, this.SAVANNA, this.SAVANNA, this.TFOREST, this.JUNGLE, this.JUNGLE, this.JUNGLE, this.JUNGLE, this.JUNGLE, this.DESERT, this.DESERT, this.DESERT, this.SCRUB, this.SGRASS, this.SFOREST, this.SFOREST, this.SFOREST, this.SFOREST, this.JUNGLE, this.DESERT, this.DESERT, this.DESERT, this.SCRUB, this.SGRASS, this.SFOREST, this.SFOREST, this.SFOREST, this.SFOREST, this.SFOREST, this.DESERT, this.DESERT, this.SCRUB, this.GRASS, this.PARK, this.FOREST, this.FOREST, this.FOREST, this.FOREST, this.FOREST, this.SCRUB, this.SCRUB, this.GRASS, this.GRASS, this.PARK, this.FOREST, this.FOREST, this.FOREST, this.FOREST, this.FOREST, this.GRASS, this.GRASS, this.GRASS, this.GRASS, this.PARK, this.FOREST, this.FOREST, this.FOREST, this.FOREST, this.FOREST, this.GRASSb, this.GRASSb, this.GRASSb, this.GRASSb, this.PARKb, this.FORESTb, this.FORESTb, this.FORESTb, this.FORESTb, this.FORESTb, this.GRASSb, this.GRASSb, this.GRASSb, this.GRASSb, this.PARKb, this.FORESTb, this.FORESTb, this.FORESTb, this.FORESTb, this.FORESTb, this.CGRASS, this.CGRASS, this.TAIGA, this.TAIGA, this.TAIGA, this.TAIGA, this.TAIGA, this.TAIGA, this.TAIGA, this.TAIGA, this.TUNDRA, this.TUNDRA, this.TAIGA, this.TAIGA, this.TAIGA, this.TAIGA, this.TAIGA, this.TAIGA, this.TAIGA, this.TAIGA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA, this.TUNDRA};
    }

    public static class LandBiomeTable
    implements IBiomeSpecifier {
        private IBiomeSpecifier[] table;

        LandBiomeTable() {
        }

        void init(IBiomeSpecifier[] t) {
            this.table = t;
        }

        @Override
        public long getBiome(ChunkTile tile) {
            return this.table[tile.getTemp() * 10 + tile.getWet()].getBiome(tile);
        }

        @Override
        public boolean isEmpty() {
            return this.table == null;
        }
    }
}

