/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.climaticbiome.generation.biome.biomes;

import jaredbgreat.climaticbiome.compat.userdef.DefReader;
import jaredbgreat.climaticbiome.generation.biome.BiomeList;
import jaredbgreat.climaticbiome.generation.biome.IBiomeSpecifier;
import jaredbgreat.climaticbiome.generation.biome.LeafBiome;
import jaredbgreat.climaticbiome.generation.biome.NoiseDoubleBiome;
import jaredbgreat.climaticbiome.generation.mapgenerator.ChunkTile;

public class GetAlpine
implements IBiomeSpecifier {
    private static GetAlpine alpine;
    BiomeList cold;
    BiomeList wet;
    BiomeList dry;
    BiomeList warmwet;
    BiomeList warmdry;
    BiomeList hotwet;
    BiomeList hotdry;

    private GetAlpine() {
        this.init();
    }

    public void init() {
        this.cold = new BiomeList();
        this.wet = new BiomeList();
        this.dry = new BiomeList();
        this.warmwet = new BiomeList();
        this.warmdry = new BiomeList();
        this.hotwet = new BiomeList();
        this.hotdry = new BiomeList();
        DefReader.readBiomeData(this.cold, "AplineCold.cfg");
        DefReader.readBiomeData(this.wet, "AplineWet.cfg");
        DefReader.readBiomeData(this.dry, "AplineDry.cfg");
        DefReader.readBiomeData(this.warmwet, "AplineWetWarm.cfg");
        DefReader.readBiomeData(this.warmdry, "AplineDryWarm.cfg");
        DefReader.readBiomeData(this.hotwet, "AplineWetHot.cfg");
        DefReader.readBiomeData(this.hotdry, "AplineDryHot.cfg");
        if (this.wet.isEmpty()) {
            this.wet.addItem(new LeafBiome(34L));
            this.wet.addItem(new LeafBiome(162L));
            this.wet.addItem(new NoiseDoubleBiome(34L, 5, 162L));
        }
        if (this.dry.isEmpty()) {
            this.dry.addItem(new LeafBiome(3L));
            this.dry.addItem(new LeafBiome(131L));
            this.dry.addItem(new NoiseDoubleBiome(3L, 5, 131L));
        }
        if (this.cold.isEmpty()) {
            this.cold.addItem(new LeafBiome(13L));
        }
        if (this.warmwet.isEmpty()) {
            this.warmwet = this.wet;
        }
        if (this.warmdry.isEmpty()) {
            this.warmdry = this.dry;
        }
        if (this.hotwet.isEmpty()) {
            this.hotwet = this.warmwet;
        }
        if (this.hotdry.isEmpty()) {
            this.hotdry = this.warmwet;
        }
    }

    @Override
    public long getBiome(ChunkTile tile) {
        tile.setMountainous();
        boolean plus = tile.getBiomeSeed() % 7 < tile.getWet();
        tile.nextBiomeSeed();
        int t = tile.getTemp();
        if (t < 8) {
            return this.cold.getBiome(tile);
        }
        if (t < 15) {
            if (plus) {
                return this.wet.getBiome(tile);
            }
            return this.dry.getBiome(tile);
        }
        if (t < 20) {
            if (plus) {
                return this.warmwet.getBiome(tile);
            }
            return this.warmdry.getBiome(tile);
        }
        if (plus) {
            return this.hotwet.getBiome(tile);
        }
        return this.hotdry.getBiome(tile);
    }

    public static GetAlpine getAlpine() {
        if (alpine == null) {
            alpine = new GetAlpine();
        }
        return alpine;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }
}

