/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.climaticbiome.generation.biome.biomes;

import jaredbgreat.climaticbiome.compat.userdef.DefReader;
import jaredbgreat.climaticbiome.generation.biome.BiomeClimateTable;
import jaredbgreat.climaticbiome.generation.biome.BiomeList;
import jaredbgreat.climaticbiome.generation.biome.IBiomeSpecifier;
import jaredbgreat.climaticbiome.generation.biome.NoiseSpecialBiome;
import jaredbgreat.climaticbiome.generation.biome.biomes.GetVolcano;
import jaredbgreat.climaticbiome.generation.mapgenerator.ChunkTile;

public class GetIslands
implements IBiomeSpecifier {
    private static GetIslands islands;
    private static boolean volcanicIslands;
    BiomeList frozen;
    BiomeList cold;
    BiomeList cool;
    BiomeList warm;
    BiomeList hot;
    BiomeList desert;
    IBiomeSpecifier basic;
    private boolean hasfr = true;
    private boolean hascold = true;
    private boolean hascool = true;
    private boolean haswarm = true;
    private boolean hashot = true;
    private boolean hasdesert = true;

    private GetIslands() {
        this.init();
    }

    public void init() {
        this.frozen = new BiomeList();
        this.cold = new BiomeList();
        this.cool = new BiomeList();
        this.warm = new BiomeList();
        this.hot = new BiomeList();
        this.desert = new BiomeList();
        this.basic = BiomeClimateTable.getLandTable();
        DefReader.readBiomeData(this.frozen, "SpecialIslandFrozen.cfg");
        DefReader.readBiomeData(this.cold, "SpecialIslandCold.cfg");
        DefReader.readBiomeData(this.cool, "SpecialIslandCool.cfg");
        DefReader.readBiomeData(this.warm, "SpecialIslandWarm.cfg");
        DefReader.readBiomeData(this.hot, "SpecialIslandTropical.cfg");
        DefReader.readBiomeData(this.desert, "SpecialIslandDesert.cfg");
        if (volcanicIslands) {
            GetIslands.addVolcanicIslands(this.frozen, this.cold, this.cool, this.warm, this.hot, this.desert);
        }
    }

    @Override
    public long getBiome(ChunkTile tile) {
        tile.setVanilla();
        tile.nextBiomeSeed();
        int seed = tile.getBiomeSeed();
        int temp = tile.getTemp();
        tile.nextBiomeSeed();
        if (temp < 4) {
            if (seed % 4 < this.frozen.size()) {
                return this.frozen.getBiome(tile.nextBiomeSeed());
            }
            return this.basic.getBiome(tile.nextBiomeSeed());
        }
        if (temp < 7) {
            if (seed % 4 < this.cold.size()) {
                return this.cold.getBiome(tile.nextBiomeSeed());
            }
            return this.basic.getBiome(tile.nextBiomeSeed());
        }
        if (temp < 13) {
            if (seed % 4 < this.cool.size()) {
                return this.cool.getBiome(tile.nextBiomeSeed());
            }
            return this.basic.getBiome(tile.nextBiomeSeed());
        }
        if (temp < 19) {
            if (tile.getWet() < 4) {
                if (seed % 4 < this.desert.size()) {
                    return this.desert.getBiome(tile.nextBiomeSeed());
                }
                return this.basic.getBiome(tile.nextBiomeSeed());
            }
            if (seed % 4 < this.warm.size()) {
                return this.warm.getBiome(tile.nextBiomeSeed());
            }
            return this.basic.getBiome(tile.nextBiomeSeed());
        }
        if (tile.getWet() < 2) {
            if (seed % 4 < this.desert.size()) {
                return this.desert.getBiome(tile.nextBiomeSeed());
            }
            return this.basic.getBiome(tile.nextBiomeSeed());
        }
        if (seed % 4 < this.hot.size()) {
            return this.hot.getBiome(tile.nextBiomeSeed());
        }
        return this.basic.getBiome(tile.nextBiomeSeed());
    }

    public static GetIslands getIslands() {
        if (islands == null) {
            islands = new GetIslands();
        }
        return islands;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    public static void addVolcanicIslands(BiomeList frozen, BiomeList cold, BiomeList cool, BiomeList warm, BiomeList hot, BiomeList desert) {
        frozen.addItem(new NoiseSpecialBiome(BiomeClimateTable.getLandTable(), 6, GetVolcano.getVolcanoes()));
        cold.addItem(new NoiseSpecialBiome(BiomeClimateTable.getLandTable(), 6, GetVolcano.getVolcanoes()));
        cool.addItem(new NoiseSpecialBiome(BiomeClimateTable.getLandTable(), 6, GetVolcano.getVolcanoes()));
        hot.addItem(new NoiseSpecialBiome(BiomeClimateTable.getLandTable(), 6, GetVolcano.getVolcanoes()));
        desert.addItem(new NoiseSpecialBiome(BiomeClimateTable.getLandTable(), 6, GetVolcano.getVolcanoes()));
        warm.addItem(new NoiseSpecialBiome(BiomeClimateTable.getLandTable(), 6, GetVolcano.getVolcanoes()));
    }

    public static void setVolcanicIslands(boolean in) {
        volcanicIslands = in;
    }

    static {
        volcanicIslands = true;
    }
}

