/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.climaticbiome.generation.biome.biomes;

import jaredbgreat.climaticbiome.biomes.ModBiomes;
import jaredbgreat.climaticbiome.compat.userdef.DefReader;
import jaredbgreat.climaticbiome.configuration.ClimaticWorldSettings;
import jaredbgreat.climaticbiome.generation.biome.BiomeClimateTable;
import jaredbgreat.climaticbiome.generation.biome.BiomeList;
import jaredbgreat.climaticbiome.generation.biome.IBiomeSpecifier;
import jaredbgreat.climaticbiome.generation.biome.LeafBiome;
import jaredbgreat.climaticbiome.generation.biome.biomes.GetBeach;
import jaredbgreat.climaticbiome.generation.biome.biomes.GetIslands;
import jaredbgreat.climaticbiome.generation.mapgenerator.ChunkTile;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeBeach;

public class GetOcean
implements IBiomeSpecifier {
    private ClimaticWorldSettings settings;
    private static GetOcean oceans;
    private int nearEdge;
    private int farEdge;
    BiomeList frozen;
    BiomeList cold;
    BiomeList cool;
    BiomeList warm;
    BiomeList hot;
    BiomeList dfrozen;
    BiomeList dcold;
    BiomeList dcool;
    BiomeList dwarm;
    BiomeList dhot;
    IBiomeSpecifier islands1;
    IBiomeSpecifier islands2;
    IBiomeSpecifier beaches;
    long coasts;
    long fcoasts;

    private GetOcean(ClimaticWorldSettings settings) {
        this.settings = settings;
        this.nearEdge = 5 + settings.regionSize.whole;
        this.farEdge = 256 * settings.regionSize.whole - 6 - settings.regionSize.whole;
        this.init();
    }

    public void init() {
        this.coasts = BiomeBeach.func_185362_a((Biome)ModBiomes.coast);
        this.fcoasts = BiomeBeach.func_185362_a((Biome)ModBiomes.frozenCoast);
        this.frozen = new BiomeList();
        this.cold = new BiomeList();
        this.cool = new BiomeList();
        this.warm = new BiomeList();
        this.hot = new BiomeList();
        this.dfrozen = new BiomeList();
        this.dcold = new BiomeList();
        this.dcool = new BiomeList();
        this.dwarm = new BiomeList();
        this.dhot = new BiomeList();
        this.islands1 = BiomeClimateTable.getLandTable();
        this.islands2 = GetIslands.getIslands();
        this.beaches = GetBeach.getBeach();
        DefReader.readBiomeData(this.frozen, "OceanFrozen.cfg");
        DefReader.readBiomeData(this.cold, "OceanCold.cfg");
        DefReader.readBiomeData(this.cool, "OceanCool.cfg");
        DefReader.readBiomeData(this.warm, "OceanWarm.cfg");
        DefReader.readBiomeData(this.hot, "OceanHot.cfg");
        DefReader.readBiomeData(this.dfrozen, "DeepOceanFrozen.cfg");
        DefReader.readBiomeData(this.dcold, "DeepOceanCold.cfg");
        DefReader.readBiomeData(this.dcool, "DeepOceanCool.cfg");
        DefReader.readBiomeData(this.dwarm, "DeepOceanWarm.cfg");
        DefReader.readBiomeData(this.dhot, "DeepOceanHot.cfg");
        if (this.warm.isEmpty()) {
            this.warm.addItem(new LeafBiome(0L));
        }
        if (this.hot.isEmpty()) {
            this.hot.addItem(new LeafBiome(0L));
        }
        if (this.dwarm.isEmpty()) {
            this.dwarm.addItem(new LeafBiome(24L));
        }
        if (this.dhot.isEmpty()) {
            this.dhot.addItem(new LeafBiome(24L));
        }
        if (this.cool.isEmpty()) {
            this.cool.addItem(new LeafBiome(0L));
        }
        if (this.dcool.isEmpty()) {
            this.dcool.addItem(new LeafBiome(24L));
        }
        if (this.frozen.isEmpty()) {
            this.frozen.addItem(new LeafBiome(10L));
        }
        if (this.dfrozen.isEmpty()) {
            this.dfrozen.addItem(new LeafBiome(10L));
        }
        this.fixOceans();
    }

    @Override
    public long getBiome(ChunkTile tile) {
        tile.setVanilla();
        int temp = tile.getTemp();
        int seed = tile.getBiomeSeed();
        int iceNoise = tile.getNoise();
        if (tile.isBeach() && !tile.isRiver() && !this.swampy(tile)) {
            tile.setSteep();
            if (iceNoise / 2 - temp > -1) {
                return this.fcoasts;
            }
            return this.coasts;
        }
        tile.nextBiomeSeed();
        if (this.settings.addIslands && seed % 5 == 0 && this.notNearEdge(tile)) {
            int noise = tile.getNoise();
            if (seed % 31 == 0) {
                if (tile.getTemp() > 9 && tile.getTemp() < 19 && tile.getWet() > 3) {
                    if (noise < 5) {
                        return 14L;
                    }
                    if (noise < 7) {
                        return 15L;
                    }
                }
                return 0L;
            }
            if (this.settings.addIslands && (seed & 1) == 0) {
                if (noise > 4 + seed % 3) {
                    return this.islands1.getBiome(tile.nextBiomeSeed());
                }
            } else if (this.settings.addIslands && noise > seed % 3) {
                return this.islands2.getBiome(tile.nextBiomeSeed());
            }
            return this.getForIsland(tile);
        }
        if (tile.getHeight() < 0.2) {
            return this.getDeepOcean(tile, temp, iceNoise);
        }
        return this.getShallowOcean(tile, temp, iceNoise);
    }

    public long getDeepOcean(ChunkTile tile, int temp, int iceNoise) {
        if (iceNoise / 2 - temp > -1) {
            return this.dfrozen.getBiome(tile);
        }
        if (temp < 7) {
            return this.dcold.getBiome(tile);
        }
        if (temp < 13) {
            return this.dcool.getBiome(tile);
        }
        if (temp < 19) {
            return this.dwarm.getBiome(tile);
        }
        return this.dhot.getBiome(tile);
    }

    public long getShallowOcean(ChunkTile tile, int temp, int iceNoise) {
        if (iceNoise / 2 - temp > -1) {
            return this.frozen.getBiome(tile);
        }
        if (temp < 7) {
            return this.cold.getBiome(tile);
        }
        if (temp < 13) {
            return this.cool.getBiome(tile);
        }
        if (temp < 19) {
            return this.warm.getBiome(tile);
        }
        return this.hot.getBiome(tile);
    }

    public static GetOcean getOcean(ClimaticWorldSettings settings) {
        if (oceans == null) {
            oceans = new GetOcean(settings);
        }
        return oceans;
    }

    public static GetOcean getOceanForIslands() {
        return oceans;
    }

    private void fixOceans() {
        if (this.warm.isEmpty()) {
            this.warm = this.cool;
        }
        if (this.hot.isEmpty()) {
            this.hot = this.warm;
        }
        if (this.cold.isEmpty()) {
            this.cold = this.cool;
        }
        if (this.frozen.isEmpty()) {
            this.frozen = this.cold;
        }
        if (this.dcool.isEmpty()) {
            this.dcool = this.cool;
        }
        if (this.dwarm.isEmpty()) {
            this.dwarm = this.dcool;
        }
        if (this.dhot.isEmpty()) {
            this.dhot = this.dwarm;
        }
        if (this.dcold.isEmpty()) {
            this.dcold = this.dcool;
        }
        if (this.dfrozen.isEmpty()) {
            this.dfrozen = this.dcold;
        }
    }

    public long getForIsland(ChunkTile tile) {
        return this.getShallowOcean(tile, tile.getTemp(), tile.getNoise());
    }

    private boolean notNearEdge(ChunkTile tile) {
        int x = tile.getX();
        int z = tile.getZ();
        return x > this.nearEdge && x < this.farEdge && z > this.nearEdge && z < this.farEdge;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    private boolean swampy(ChunkTile tile) {
        return tile.getTemp() > 7 && (double)(tile.getWet() - tile.getVal()) - tile.getHeight() > 0.0;
    }
}

