/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.climaticbiome.generation.biome.biomes;

import jaredbgreat.climaticbiome.compat.userdef.DefReader;
import jaredbgreat.climaticbiome.generation.biome.BiomeList;
import jaredbgreat.climaticbiome.generation.biome.IBiomeSpecifier;
import jaredbgreat.climaticbiome.generation.biome.biomes.GetCoolForest;
import jaredbgreat.climaticbiome.generation.biome.biomes.GetCoolPark;
import jaredbgreat.climaticbiome.generation.biome.biomes.GetCoolPlains;
import jaredbgreat.climaticbiome.generation.biome.biomes.GetForest;
import jaredbgreat.climaticbiome.generation.biome.biomes.GetPlains;
import jaredbgreat.climaticbiome.generation.mapgenerator.ChunkTile;

public class GetPark
implements IBiomeSpecifier {
    private static GetPark pland;
    private BiomeList parks;
    private GetPlains plains;
    private GetForest woods;

    private GetPark() {
        this.init();
    }

    public void init() {
        this.parks = new BiomeList();
        this.plains = GetPlains.getPlains();
        this.woods = GetForest.getForest();
        DefReader.readBiomeData(this.parks, "Parkland.cfg");
        this.parks.addItem(this.woods);
        this.parks.addItem(this.plains);
    }

    @Override
    public long getBiome(ChunkTile tile) {
        int seed = tile.getBiomeSeed();
        if (this.parks.isEmpty() || seed % 7 == 0) {
            if ((seed & 1) == 0) {
                tile.nextBiomeSeed();
                return this.woods.getBiome(tile);
            }
            tile.nextBiomeSeed();
            return this.plains.getBiome(tile);
        }
        tile.nextBiomeSeed();
        return this.parks.getBiome(tile);
    }

    public static GetPark getPark() {
        if (pland == null) {
            pland = new GetPark();
        }
        return pland;
    }

    public void collapseCoole() {
        this.parks.merge(GetCoolPark.getPark().getList());
        this.parks.remove(GetCoolForest.getForest());
        this.parks.remove(GetCoolPlains.getPlains());
    }

    @Override
    public boolean isEmpty() {
        return false;
    }
}

