/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.climaticbiome.generation.cache;

import jaredbgreat.climaticbiome.generation.cache.Coords;
import jaredbgreat.climaticbiome.generation.cache.ICachable;
import jaredbgreat.climaticbiome.generation.cache.MutableCoords;

public class Cache<T extends ICachable> {
    private T[] data;
    private final int minSize;
    private int capacity;
    private int lowLimit;
    private int length;

    public Cache(int size) {
        this.data = new ICachable[size];
        this.minSize = size;
        this.capacity = size * 3 / 4;
        this.lowLimit = (size - this.minSize) * 3 / 16;
        this.length = 0;
    }

    public Cache() {
        this.data = new ICachable[16];
        this.minSize = 16;
        this.capacity = 12;
        this.lowLimit = 0;
        this.length = 0;
    }

    public void add(T item) {
        int bucket = (item.getCoords().hashCode() & Integer.MAX_VALUE) % this.data.length;
        for (int offset = 0; offset < this.data.length; ++offset) {
            int slot = (bucket + offset) % this.data.length;
            if (this.data[slot] == null) {
                this.data[slot] = item;
                this.data[slot].use();
                if (++this.length > this.capacity) {
                    this.grow();
                }
                return;
            }
            if (!this.data[slot].equals(item)) continue;
            this.data[slot].use();
            return;
        }
    }

    public T get(Coords coords) {
        int bucket = (coords.hashCode() & Integer.MAX_VALUE) % this.data.length;
        for (int offset = 0; offset < this.data.length; ++offset) {
            int slot = (bucket + offset) % this.data.length;
            if (this.data[slot] == null) {
                return null;
            }
            if (!this.data[slot].getCoords().equals(coords)) continue;
            this.data[slot].use();
            return this.data[slot];
        }
        return null;
    }

    public T get(MutableCoords coords) {
        int bucket = (coords.hashCode() & Integer.MAX_VALUE) % this.data.length;
        for (int offset = 0; offset < this.data.length; ++offset) {
            int slot = (bucket + offset) % this.data.length;
            if (this.data[slot] == null) {
                return null;
            }
            if (!this.data[slot].getCoords().equals(coords)) continue;
            this.data[slot].use();
            return this.data[slot];
        }
        return null;
    }

    public T get(int x, int z) {
        int bucket = (Coords.hashCoords(x, z) & Integer.MAX_VALUE) % this.data.length;
        for (int offset = 0; offset < this.data.length; ++offset) {
            int slot = (bucket + offset) % this.data.length;
            if (this.data[slot] == null) {
                return null;
            }
            if (!this.data[slot].getCoords().equals(x, z)) continue;
            this.data[slot].use();
            return this.data[slot];
        }
        return null;
    }

    public boolean contains(Coords coords) {
        int bucket = (coords.hashCode() & Integer.MAX_VALUE) % this.data.length;
        for (int offset = 0; offset < this.data.length; ++offset) {
            int slot = (bucket + offset) % this.data.length;
            if (this.data[slot] == null) {
                return false;
            }
            if (!this.data[slot].getCoords().equals(coords)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(int x, int z) {
        int bucket = (Coords.hashCoords(x, z) & Integer.MAX_VALUE) % this.data.length;
        for (int offset = 0; offset < this.data.length; ++offset) {
            int slot = (bucket + offset) % this.data.length;
            if (this.data[slot] == null) {
                return false;
            }
            if (!this.data[slot].getCoords().equals(x, z)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(T in) {
        Coords coords = in.getCoords();
        int bucket = (coords.hashCode() & Integer.MAX_VALUE) % this.data.length;
        for (int offset = 0; offset <= this.data.length; ++offset) {
            int slot = (bucket + offset) % this.data.length;
            if (this.data[slot] == null) {
                return false;
            }
            if (!this.data[slot].getCoords().equals(coords)) continue;
            return true;
        }
        return false;
    }

    private void grow() {
        T[] old = this.data;
        this.data = new ICachable[old.length * 3 / 2];
        for (int i = 0; i < old.length; ++i) {
            if (old[i] == null) continue;
            this.rebucket(old[i]);
        }
        this.capacity = this.data.length * 3 / 4;
        this.lowLimit = (this.data.length - this.minSize) * 3 / 16;
    }

    private void shrink() {
        T[] old = this.data;
        this.data = new ICachable[Math.max(old.length / 2, this.minSize)];
        for (int i = 0; i < old.length; ++i) {
            if (old[i] == null) continue;
            this.rebucket(old[i]);
        }
        this.capacity = this.data.length * 3 / 4;
        this.lowLimit = (this.data.length - this.minSize) * 3 / 16;
    }

    private void rebucket(T item) {
        int bucket = (item.getCoords().hashCode() & Integer.MAX_VALUE) % this.data.length;
        for (int offset = 0; offset <= this.data.length; ++offset) {
            int slot = (bucket + offset) % this.data.length;
            if (this.data[slot] != null && !this.data[slot].equals(item)) continue;
            this.data[slot] = item;
            return;
        }
    }

    public void cleanup() {
        int startSize = this.data.length;
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] == null || !this.data[i].isOldData()) continue;
            this.data[i] = null;
            --this.length;
        }
        if (this.length < this.lowLimit) {
            this.shrink();
        } else if (this.data.length != startSize) {
            T[] old = this.data;
            this.data = new ICachable[this.data.length];
            for (int i = 0; i < this.length; ++i) {
                if (old[i] == null) continue;
                this.rebucket(old[i]);
            }
        }
    }
}

