/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.climaticbiome.generation.chunk;

public class BasinNode {
    final int x;
    final int z;
    final double strength;
    final double value;

    public BasinNode(int x, int y, double value, double decay) {
        this.x = x;
        this.z = y;
        this.value = value;
        this.strength = decay;
    }

    public double getWeaknessAt(double atx, double aty) {
        double xdisplace = (double)this.x + 1.0 - atx;
        double ydisplace = (double)this.z + 1.0 - aty;
        return Math.max(xdisplace * xdisplace + ydisplace * ydisplace, 1.0);
    }

    public static double summateEffect(BasinNode[] n, int x, int z) {
        double effect = 0.0;
        double sum = 0.0;
        for (int i = 0; i < n.length; ++i) {
            double weakness = n[i].getWeaknessAt(x, z);
            double power = n[i].strength / (weakness * weakness);
            sum += power;
            effect += n[i].value * power;
        }
        return effect / sum;
    }

    public String toString() {
        return "    [x=" + this.x + ", z=" + this.z + ", val=" + this.value + ", strength=" + this.strength + "] ";
    }

    public String briefString() {
        return "    [x=" + this.x + ", z=" + this.z + "] ";
    }
}

