/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.climaticbiome.generation.chunk;

import jaredbgreat.climaticbiome.generation.ClimaticBiomeProvider;
import jaredbgreat.climaticbiome.generation.chunk.HeightMapManager;
import jaredbgreat.climaticbiome.util.SpatialHash;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.ChunkGeneratorOverworld;

public class ChunkGenClimaticRealistic
extends ChunkGeneratorOverworld {
    private static final IBlockState WATER = Blocks.field_150355_j.func_176223_P();
    private final SpatialHash sprandom;
    private final HeightMapManager heightMapManager;
    private final World world;

    public ChunkGenClimaticRealistic(World worldIn, long seed, boolean mapFeaturesEnabledIn, String generatorOptions) {
        super(worldIn, seed, mapFeaturesEnabledIn, generatorOptions);
        this.sprandom = new SpatialHash(seed);
        this.heightMapManager = new HeightMapManager();
        this.world = worldIn;
    }

    public void func_185976_a(int x, int z, ChunkPrimer primer) {
        int[][] heightmap = this.getHeihtmapForChunk(x, z, this.sprandom);
        for (int i = 0; i < 16; ++i) {
            for (int k = 0; k < 16; ++k) {
                int h = heightmap[0][i * 16 + k];
                for (int j = 0; j < 256; ++j) {
                    if (j < h) {
                        primer.func_177855_a(i, j, k, field_185982_a);
                        continue;
                    }
                    if (j >= 63) continue;
                    primer.func_177855_a(i, j, k, WATER);
                }
            }
        }
    }

    private int[][] getHeihtmapForChunk(int x, int z, SpatialHash rand) {
        ClimaticBiomeProvider provider = (ClimaticBiomeProvider)this.world.func_72959_q();
        return this.heightMapManager.getChunkHieghts(x, z, rand, provider.getTerrainBiomeGen(x, z));
    }
}

