/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.climaticbiome.generation.chunk;

import jaredbgreat.climaticbiome.generation.cache.AbstractWeaklyCacheable;
import jaredbgreat.climaticbiome.generation.chunk.HeightMapManager;
import jaredbgreat.climaticbiome.util.HeightNoiseMap;
import jaredbgreat.climaticbiome.util.ModMath;
import jaredbgreat.climaticbiome.util.SpatialHash;

public class HeightMapArea
extends AbstractWeaklyCacheable {
    public static final int CSIZE = 8;
    public static final int BSIZE = 128;
    public static final int SCALE = 192;
    private final float[][] heightMap;

    public HeightMapArea(int x, int z, SpatialHash rand, HeightMapManager manager) {
        super(x, z, manager.getCache());
        HeightNoiseMap noise = new HeightNoiseMap(128, 128, 128, 192.0f);
        this.heightMap = noise.process(rand, x * 128, z * 128);
    }

    public int[][] getChunkHieghts(int x, int z, float[] biomeData) {
        int[][] out = new int[4][256];
        int startx = ModMath.modRight(x, 8) * 16;
        int startz = ModMath.modRight(z, 8) * 16;
        int endx = startx + 16;
        int endz = startz + 16;
        int ix = 0;
        int jz = 0;
        int i = startx;
        while (i < endx) {
            jz = 0;
            int j = startz;
            while (j < endz) {
                int index = ix * 16 + jz;
                out[0][index] = (int)(this.heightMap[i][j] * biomeData[index + 256] + biomeData[index] * 20.0f + 64.0f);
                ++j;
                ++jz;
            }
            ++i;
            ++ix;
        }
        return out;
    }

    public static void statArray(float[][] in, String name) {
        int j;
        int i;
        float min = Float.NEGATIVE_INFINITY;
        float max = Float.POSITIVE_INFINITY;
        float sum = 0.0f;
        float avg = 0.0f;
        float std = 0.0f;
        int num = 0;
        for (i = 0; i < in.length; ++i) {
            for (j = 0; j < in[i].length; ++j) {
                ++num;
                if (in[i][j] > min) {
                    min = in[i][j];
                }
                if (in[i][j] < max) {
                    max = in[i][j];
                }
                sum += in[i][j];
            }
        }
        avg = sum / (float)num;
        for (i = 0; i < in.length; ++i) {
            for (j = 0; j < in[i].length; ++j) {
                float tmp = in[i][j] - avg;
                std += tmp * tmp;
            }
        }
        std /= (float)num;
        std = (float)Math.sqrt(std);
        System.out.println();
        System.out.println("****************");
        System.out.println("Array Name: " + name);
        System.out.println("N = " + num);
        System.out.println("Minimum = " + min);
        System.out.println("Maximum = " + max);
        System.out.println("Total = " + sum);
        System.out.println("Mean = " + avg);
        System.out.println("Standard Deviation = " + std);
        System.out.println("****************");
        System.out.println();
    }

    public static void statArray(double[][] in, String name) {
        int j;
        int i;
        double min = Double.NEGATIVE_INFINITY;
        double max = Double.POSITIVE_INFINITY;
        float sum = 0.0f;
        float avg = 0.0f;
        float std = 0.0f;
        int num = 0;
        for (i = 0; i < in.length; ++i) {
            for (j = 0; j < in[i].length; ++j) {
                ++num;
                if (in[i][j] > min) {
                    min = in[i][j];
                }
                if (in[i][j] < max) {
                    max = in[i][j];
                }
                sum = (float)((double)sum + in[i][j]);
            }
        }
        avg = sum / (float)num;
        for (i = 0; i < in.length; ++i) {
            for (j = 0; j < in[i].length; ++j) {
                double tmp = in[i][j] - (double)avg;
                std = (float)((double)std + tmp * tmp);
            }
        }
        std /= (float)num;
        std = (float)Math.sqrt(std);
        System.out.println();
        System.out.println("****************");
        System.out.println("Array Name: " + name);
        System.out.println("N = " + num);
        System.out.println("Minimum = " + min);
        System.out.println("Maximum = " + max);
        System.out.println("Total = " + sum);
        System.out.println("Mean = " + avg);
        System.out.println("Standard Deviation = " + std);
        System.out.println("****************");
        System.out.println();
    }
}

