/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.climaticbiome.generation.map;

import jaredbgreat.climaticbiome.configuration.ClimaticWorldSettings;
import jaredbgreat.climaticbiome.generation.map.IMapRegistry;
import jaredbgreat.climaticbiome.util.Logging;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import net.minecraft.world.World;

public abstract class AbstractMapRegistry
implements IMapRegistry {
    static final String SETTINGS = "settings";
    ClimaticWorldSettings settings;
    World world;
    File savedir = null;
    boolean cansave = true;
    File settingsDir = null;
    File settingsFile = null;
    boolean perworld = true;
    boolean pwtodo = true;
    boolean noFakes;

    public AbstractMapRegistry(World w) {
        this.world = w;
        this.findSaveDir();
        this.readSettings();
    }

    @Override
    public void findSaveDir() {
        if (this.world == null || this.world.func_73046_m() == null) {
            this.cansave = false;
            return;
        }
        if (this.world.func_73046_m().func_71262_S()) {
            this.savedir = this.world.func_73046_m().func_71209_f("world" + File.separator + "ClimaticMaps" + File.separator + "Dim" + this.world.field_73011_w.getDimension());
            this.settingsDir = this.world.func_73046_m().func_71209_f("world" + File.separator + "ClimaticMaps" + File.separator + SETTINGS);
            this.settingsFile = this.world.func_73046_m().func_71209_f("world" + File.separator + "ClimaticMaps" + File.separator + SETTINGS + File.separator + "dim" + this.world.field_73011_w.getDimension() + ".json");
        } else {
            this.savedir = new File(this.world.func_72860_G().func_75765_b().toString() + File.separator + "ClimaticMaps" + File.separator + "Dim" + this.world.field_73011_w.getDimension());
            this.settingsDir = new File(this.world.func_72860_G().func_75765_b().toString() + File.separator + "ClimaticMaps" + File.separator + SETTINGS);
            this.settingsFile = new File(this.world.func_72860_G().func_75765_b().toString() + File.separator + "ClimaticMaps" + File.separator + SETTINGS + File.separator + "dim" + this.world.field_73011_w.getDimension() + ".json");
        }
        this.cansave = this.savedir != null;
        boolean bl = this.perworld = this.settingsDir != null && this.settingsFile != null;
        if (this.cansave && !this.savedir.exists()) {
            this.savedir.mkdirs();
            boolean bl2 = this.cansave = this.savedir.exists() && this.savedir.isDirectory();
        }
        if (this.perworld && !this.settingsDir.exists()) {
            this.settingsDir.mkdirs();
            this.perworld = this.settingsDir.exists() && this.settingsDir.isDirectory();
        }
    }

    File getSaveFile(int x, int z) {
        if (this.savedir == null) {
            this.findSaveDir();
        }
        if (this.savedir == null) {
            this.cansave = false;
            return null;
        }
        return new File(this.savedir.toString() + File.separator + "X" + x + "Z" + z + ".cbmap");
    }

    File getSaveTerrain(int x, int z) {
        if (this.savedir == null) {
            this.findSaveDir();
        }
        if (this.savedir == null) {
            this.cansave = false;
            return null;
        }
        return new File(this.savedir.toString() + File.separator + "X" + x + "Z" + z + ".cbter");
    }

    void readSettings() {
        this.settings = ClimaticWorldSettings.getQueued();
        if (this.settingsFile == null) {
            return;
        }
        if (this.settingsFile.exists()) {
            if (this.settingsFile.isFile()) {
                try {
                    BufferedReader fs = new BufferedReader(new FileReader(this.settingsFile));
                    String json = fs.readLine();
                    if (json != null) {
                        this.settings = this.settings.fromJsonString(json);
                    }
                    fs.close();
                    this.pwtodo = false;
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                Logging.logError("Settings file \"" + this.settingsFile + "\" is not a valid file!");
            }
        } else if (!this.world.field_72995_K) {
            try {
                BufferedWriter fs = new BufferedWriter(new FileWriter(this.settingsFile));
                fs.append(this.settings.toJsonString());
                fs.close();
                this.pwtodo = false;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.settings.applySettings();
    }

    class Hasher {
        int hash = 0;
        int count = 0;

        Hasher() {
        }

        public void next(int b) {
            this.hash ^= (b & 0xFF) << 8 * this.count;
            this.hash ^= this.hash << 13;
            this.hash ^= this.hash >> 5;
            this.hash ^= this.hash << 17;
            ++this.count;
            this.count %= 4;
        }

        public int getHash() {
            return this.hash;
        }
    }
}

