/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.climaticbiome.generation.map;

import jaredbgreat.climaticbiome.generation.cache.AbstractCachable;
import jaredbgreat.climaticbiome.generation.map.RegionMap;

public class JEIDRegionMap
extends AbstractCachable {
    public final int dataSize;
    public final int cWidth;
    public final int bWidth;
    final int[] data;
    static int n = 0;

    public JEIDRegionMap(int x, int z, int width) {
        super(x, z);
        this.cWidth = width;
        this.bWidth = width * 16;
        this.dataSize = width * width;
        this.data = new int[this.dataSize];
        ++n;
    }

    public void finalize() throws Throwable {
        --n;
        super.finalize();
    }

    public int getBiome(int x, int z) {
        return this.data[x * this.cWidth + z] & 0xFF;
    }

    public int getSubBiomeId(int x, int z) {
        return (this.data[x * this.cWidth + z] & 0xFF00) >> 8;
    }

    public int getFullBiome(int x, int z) {
        return this.data[x * this.cWidth + z];
    }

    public void setBiomeExpress(int biome, int i) {
        this.data[i] = biome;
    }

    int[] getData() {
        return this.data;
    }

    public int hashCode() {
        return this.getCoords().hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof RegionMap) {
            return this.getCoords().equals(((RegionMap)other).getCoords());
        }
        return false;
    }

    public int otherHash() {
        int hash = 0;
        int count = 0;
        for (int i = 0; i < this.data.length; ++i) {
            for (int j = 0; j < 2; ++j) {
                int longbyte = this.data[i] >> j * 8 & 0xFF;
                hash ^= longbyte << 8 * count;
                hash ^= hash << 13;
                hash ^= hash >> 5;
                hash ^= hash << 17;
                ++count;
                count %= 4;
            }
        }
        return hash;
    }

    public static int otherHash(short[] in) {
        int hash = 0;
        int count = 0;
        for (int i = 0; i < in.length; ++i) {
            for (int j = 0; j < 2; ++j) {
                int longbyte = in[i] >> j * 8 & 0xFF;
                hash ^= longbyte << 8 * count;
                hash ^= hash << 13;
                hash ^= hash >> 5;
                hash ^= hash << 17;
                ++count;
                count %= 4;
            }
        }
        return hash;
    }
}

