/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.climaticbiome.generation.map;

import jaredbgreat.climaticbiome.biomes.SubBiome;
import jaredbgreat.climaticbiome.biomes.SubBiomeRegistry;
import jaredbgreat.climaticbiome.generation.cache.Cache;
import jaredbgreat.climaticbiome.generation.cache.Coords;
import jaredbgreat.climaticbiome.generation.chunk.BasinNode;
import jaredbgreat.climaticbiome.generation.map.AbstractMapRegistry;
import jaredbgreat.climaticbiome.generation.map.IMapRegistry;
import jaredbgreat.climaticbiome.generation.map.RegionMap;
import jaredbgreat.climaticbiome.generation.mapgenerator.BiomeBasin;
import jaredbgreat.climaticbiome.generation.mapgenerator.MapMaker;
import jaredbgreat.climaticbiome.generation.mapgenerator.TerrainPrimer;
import jaredbgreat.climaticbiome.util.ModMath;
import jaredbgreat.climaticbiome.util.SpatialHash;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Random;
import net.minecraft.init.Biomes;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class MapRegistry
extends AbstractMapRegistry
implements IMapRegistry {
    private static final String SETTINGS = "settings";
    private final Cache<RegionMap> data;
    private final SubBiomeRegistry subbiomes;
    private final boolean altChunks;
    private final SpatialHash chunkNoise;
    private final SpatialHash regionNoise;
    private final SpatialHash biomeNoise;
    private int dataSize;
    private int cWidth;
    private int bWidth;
    private int cOffset;
    private int bOffset;
    private final MapMaker maker;

    public MapRegistry(long seed, World w, boolean altChunks) {
        super(w);
        this.altChunks = altChunks;
        this.cWidth = 256 * this.settings.regionSize.whole;
        this.bWidth = this.cWidth * 16;
        this.dataSize = this.cWidth * this.cWidth;
        this.cOffset = this.cWidth / 2;
        this.bOffset = this.bWidth / 2;
        this.data = new Cache();
        this.subbiomes = SubBiomeRegistry.getSubBiomeRegistry();
        Random random = new Random(seed);
        this.chunkNoise = new SpatialHash(random.nextLong(), random.nextLong());
        this.regionNoise = new SpatialHash(random.nextLong(), random.nextLong());
        this.biomeNoise = new SpatialHash(random.nextLong(), random.nextLong());
        this.maker = new MapMaker(this.chunkNoise, this.regionNoise, this.biomeNoise, this.settings);
    }

    private RegionMap getMap(int x, int z) {
        RegionMap out = this.data.get(x, z);
        if (out == null) {
            out = new RegionMap(x, z, this.cWidth);
            this.readMap(out);
            this.data.add(out);
        }
        return out;
    }

    private RegionMap getMapFromChunkCoord(int x, int z) {
        return this.getMap(Math.floorDiv(x + this.cOffset, this.cWidth), Math.floorDiv(z + this.cOffset, this.cWidth));
    }

    @Override
    public int chunkToMap(int c) {
        return (c + this.cOffset) / this.cWidth;
    }

    @Override
    public int blockToMap(int c) {
        return (c + this.bOffset) / this.bWidth;
    }

    private void initializeMap(RegionMap map) {
        this.maker.generate(map, this.world, this.altChunks);
        if (this.cansave) {
            this.writeMap(map);
        }
    }

    private void readMap(RegionMap map) {
        Coords coords = map.getCoords();
        int x = coords.getX();
        int z = coords.getZ();
        if (!this.cansave) {
            return;
        }
        File file = this.getSaveFile(x, z);
        int[] data = map.getData();
        if (file != null && file.exists()) {
            try {
                FileInputStream fs = new FileInputStream(file);
                int i = 0;
                while (i < this.dataSize) {
                    data[i] = (short)fs.read();
                    int n = i++;
                    data[n] = data[n] | fs.read() << 8;
                }
                fs.close();
                if (this.altChunks) {
                    this.readTerrainData(data, x, z);
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.initializeMap(map);
        }
    }

    private void readTerrainData(int[] data, int x, int z) {
        File file = this.getSaveTerrain(x, z);
        if (file != null && file.exists()) {
            try {
                FileInputStream fs = new FileInputStream(file);
                int i = 0;
                while (i < this.dataSize) {
                    int n = i;
                    data[n] = data[n] | fs.read() << 16;
                    int n2 = i++;
                    data[n2] = data[n2] | fs.read() << 24;
                }
                fs.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            TerrainPrimer.makeFromVanilla(data);
            this.writeTerrainData(data, x, z);
        }
    }

    private void writeMap(RegionMap map) {
        int z;
        Coords coords = map.getCoords();
        int x = coords.getX();
        File file = this.getSaveFile(x, z = coords.getZ());
        if (file != null && !file.exists()) {
            int[] data = map.getData();
            try {
                FileOutputStream fs = new FileOutputStream(file);
                for (int i = 0; i < this.dataSize; ++i) {
                    fs.write(data[i] & 0xFF);
                    fs.write((data[i] & 0xFF00) >> 8);
                }
                fs.close();
                if (this.altChunks) {
                    this.writeTerrainData(data, x, z);
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void writeTerrainData(int[] data, int x, int z) {
        File file = this.getSaveTerrain(x, z);
        if (file != null && !file.exists()) {
            try {
                FileOutputStream fs = new FileOutputStream(file);
                for (int i = 0; i < this.dataSize; ++i) {
                    fs.write((data[i] & 0xFF0000) >> 16);
                    fs.write((data[i] & 0xFF000000) >>> 24);
                }
                fs.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private int getBiomeIDChunk(int x, int z) {
        return this.getMapFromChunkCoord(x, z).getBiome(ModMath.modRight(x + this.cOffset, this.cWidth), ModMath.modRight(z + this.cOffset, this.cWidth));
    }

    private int getGenIDChunk(int x, int z) {
        return this.getMapFromChunkCoord(x, z).getFullBiome(ModMath.modRight(x + this.cOffset, this.cWidth), ModMath.modRight(z + this.cOffset, this.cWidth));
    }

    @Override
    public Biome getBiomeChunk(int x, int z) {
        return this.getFullBiome(this.getMapFromChunkCoord(x, z).getBiome(ModMath.modRight(x + this.cOffset, this.cWidth), ModMath.modRight(z + this.cOffset, this.cWidth) & 0xFF));
    }

    @Override
    public Biome[] getChunkBiomeGrid(int x, int z, Biome[] in) {
        int i;
        int[] tiles = new int[9];
        BiomeBasin[][] basins = new BiomeBasin[3][3];
        for (i = 0; i < tiles.length; ++i) {
            int x1 = i / 3;
            int z1 = i % 3;
            int x2 = x + x1;
            int z2 = z + z1;
            tiles[i] = this.getBiomeIDChunk(x2, z2);
            basins[i / 3][i % 3] = new BiomeBasin(x1 * 16 + this.chunkNoise.intFor(x2, z2, 10) % 16, z1 * 16 + this.chunkNoise.intFor(x2, z2, 11) % 16, tiles[i], 1.0 + this.chunkNoise.doubleFor(x2, z2, 12));
        }
        for (i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                in[j * 16 + i] = Biome.func_180276_a((int)BiomeBasin.summateEffect(basins, 16 + i, 16 + j), (Biome)Biomes.field_180279_ad);
            }
        }
        return in;
    }

    private Biome[] getBiomeGrid(int x, int z, int h, int w) {
        int i;
        int ch = (h - 1) / 16 + 3;
        int cw = (w - 1) / 16 + 3;
        int numc = ch * cw;
        Biome[] out = new Biome[h * w];
        int[] tiles = new int[numc];
        BiomeBasin[][] basins = new BiomeBasin[ch][cw];
        for (i = 0; i < tiles.length; ++i) {
            int x1 = i / cw;
            int z1 = i % cw;
            int x2 = x + x1;
            int z2 = z + z1;
            tiles[i] = this.getBiomeIDChunk(x2, z2);
            basins[x1][z1] = new BiomeBasin(x1 * 16 + this.chunkNoise.intFor(x2, z2, 10) % 16, z1 * 16 + this.chunkNoise.intFor(x2, z2, 11) % 16, tiles[i], 1.0 + this.chunkNoise.doubleFor(x2, z2, 12));
        }
        for (i = 0; i < w; ++i) {
            for (int j = 0; j < h; ++j) {
                out[j * w + i] = Biome.func_180276_a((int)BiomeBasin.summateEffect(basins, 16 + i, 16 + j), (Biome)Biomes.field_180279_ad);
            }
        }
        return out;
    }

    @Override
    public Biome[] getUnalignedBiomeGrid(int x, int z, int h, int w, Biome[] in) {
        int hOff = ModMath.modRight(x, 16);
        int wOff = ModMath.modRight(z, 16);
        int h1 = h + hOff;
        int w1 = w + wOff;
        int h2 = h1 + (16 - h1 % 16);
        int w2 = w1 + (16 - w1 % 16);
        Biome[] tmp = this.getBiomeGrid(x / 16, z / 16, h2, w2);
        for (int i = 0; i < h; ++i) {
            for (int j = 0; j < w; ++j) {
                in[j * w + i] = tmp[(j + hOff) * w2 + wOff + i];
            }
        }
        return in;
    }

    private Biome getFullBiome(int id) {
        if (id < 256) {
            return Biome.func_180276_a((int)id, (Biome)Biomes.field_180279_ad);
        }
        SubBiome out = this.subbiomes.get(id);
        if (this.noFakes || out == null) {
            out = Biome.func_180276_a((int)(id & 0xFF), (Biome)Biomes.field_180279_ad);
        }
        return out;
    }

    @Override
    public Biome[] getChunkBiomeGen(int x, int z, Biome[] in) {
        int i;
        int[] tiles = new int[9];
        BiomeBasin[][] basins = new BiomeBasin[3][3];
        for (i = 0; i < tiles.length; ++i) {
            int x1 = i / 3;
            int z1 = i % 3;
            int x2 = x + x1;
            int z2 = z + z1;
            tiles[i] = this.getGenIDChunk(x2, z2);
            basins[i / 3][i % 3] = new BiomeBasin(x1 * 16 + this.chunkNoise.intFor(x2, z2, 10) % 16, z1 * 16 + this.chunkNoise.intFor(x2, z2, 11) % 16, tiles[i], 1.0 + this.chunkNoise.doubleFor(x2, z2, 12));
        }
        for (i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                in[j * 16 + i] = this.getFullBiome(BiomeBasin.summateEffect(basins, 16 + i, 16 + j));
            }
        }
        return in;
    }

    private Biome[] getBiomeGenGrid(int x, int z, int h, int w) {
        int i;
        int ch = (h - 1) / 16 + 3;
        int cw = (w - 1) / 16 + 3;
        int numc = ch * cw;
        Biome[] out = new Biome[h * w];
        int[] tiles = new int[numc];
        BiomeBasin[][] basins = new BiomeBasin[ch][cw];
        for (i = 0; i < tiles.length; ++i) {
            int x1 = i / cw;
            int z1 = i % cw;
            int x2 = x + x1;
            int z2 = z + z1;
            tiles[i] = this.getGenIDChunk(x2, z2);
            basins[x1][z1] = new BiomeBasin(x1 * 16 + this.chunkNoise.intFor(x2, z2, 10) % 16, z1 * 16 + this.chunkNoise.intFor(x2, z2, 11) % 16, tiles[i], 1.0 + this.chunkNoise.doubleFor(x2, z2, 12));
        }
        for (i = 0; i < w; ++i) {
            for (int j = 0; j < h; ++j) {
                out[j * w + i] = this.getFullBiome(BiomeBasin.summateEffect(basins, 16 + i, 16 + j));
            }
        }
        return out;
    }

    @Override
    public float[] getTerrainBiomeGen(int x, int z, float[] in) {
        int i;
        BasinNode[] heights = new BasinNode[49];
        BasinNode[] scales = new BasinNode[49];
        for (i = 0; i < 49; ++i) {
            int x1 = i / 7;
            int z1 = i % 7;
            int x2 = x + x1;
            int z2 = z + z1;
            heights[i] = new BasinNode(x1 * 16 + this.chunkNoise.intFor(x2, z2, 10) % 16, z1 * 16 + this.chunkNoise.intFor(x2, z2, 11) % 16, this.getBaseHeight(x2, z2), 1.0 + this.chunkNoise.doubleFor(x2, z2, 12));
            scales[i] = new BasinNode(x1 * 16 + this.chunkNoise.intFor(x2, z2, 10) % 16, z1 * 16 + this.chunkNoise.intFor(x2, z2, 11) % 16, this.getHeightScale(x2, z2), 1.0 + this.chunkNoise.doubleFor(x2, z2, 12));
        }
        for (i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                in[i * 16 + j] = (float)BasinNode.summateEffect(heights, 16 + i, 16 + j);
                in[i * 16 + j + 256] = (float)BasinNode.summateEffect(scales, 16 + i, 16 + j);
            }
        }
        return in;
    }

    @Override
    public float getBaseHeight(int x, int z) {
        return this.getMapFromChunkCoord(x, z).getBaseHeight(ModMath.modRight(x + this.cOffset, this.cWidth), ModMath.modRight(z + this.cOffset, this.cWidth));
    }

    @Override
    public float getHeightScale(int x, int z) {
        return this.getMapFromChunkCoord(x, z).getHeightScale(ModMath.modRight(x + this.cOffset, this.cWidth), ModMath.modRight(z + this.cOffset, this.cWidth));
    }

    @Override
    public float[] getHeightData(int x, int z) {
        return this.getMapFromChunkCoord(x, z).getHeightData(ModMath.modRight(x + this.cOffset, this.cWidth), ModMath.modRight(z + this.cOffset, this.cWidth));
    }

    @Override
    public void cleanCaches() {
        this.data.cleanup();
    }
}

