/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.climaticbiome.generation.map;

import jaredbgreat.climaticbiome.generation.cache.AbstractCachable;
import jaredbgreat.climaticbiome.generation.map.IRegionMap;

public class NewRegionMap
extends AbstractCachable
implements IRegionMap {
    public final int dataSize;
    public final int cWidth;
    public final int bWidth;
    final long[] data;
    static int n = 0;

    public NewRegionMap(int x, int z, int width) {
        super(x, z);
        this.cWidth = width;
        this.bWidth = width * 16;
        this.dataSize = width * width;
        this.data = new long[this.dataSize];
        ++n;
    }

    public long getBiome(int x, int z) {
        return this.data[x * this.cWidth + z] & 0xFFFFFFFFL;
    }

    public long getFullBiome(int x, int z) {
        return this.data[x * this.cWidth + z] & 0xFFFFFFFFFFL;
    }

    @Override
    public void setBiomeExpress(long biome, int i) {
        this.data[i] = biome;
    }

    long[] getData() {
        return this.data;
    }

    @Override
    public int hashCode() {
        return this.getCoords().hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof IRegionMap) {
            return this.getCoords().equals(((NewRegionMap)other).getCoords());
        }
        return false;
    }

    @Override
    public int otherHash() {
        int hash = 0;
        int count = 0;
        for (int i = 0; i < this.data.length; ++i) {
            for (int j = 0; j < 5; ++j) {
                long longbyte = this.data[i] >> j * 8 & 0xFFL;
                hash = (int)((long)hash ^ longbyte << 8 * count);
                hash ^= hash << 13;
                hash ^= hash >> 5;
                hash ^= hash << 17;
                ++count;
                count %= 4;
            }
        }
        return hash;
    }

    public static int otherHash(long[] in) {
        int hash = 0;
        int count = 0;
        for (int i = 0; i < in.length; ++i) {
            for (int j = 0; j < 5; ++j) {
                long longbyte = in[i] >> j * 8 & 0xFFL;
                hash = (int)((long)hash ^ longbyte << 8 * count);
                hash ^= hash << 13;
                hash ^= hash >> 5;
                hash ^= hash << 17;
                ++count;
                count %= 4;
            }
        }
        return hash;
    }

    @Override
    public float getBaseHeight(int x, int z) {
        return (float)((this.data[x * this.cWidth + z] & 0xFF0000000000L) >> 40) / 32.0f - 4.0f;
    }

    @Override
    public float getHeightScale(int x, int z) {
        return (float)((this.data[x * this.cWidth + z] & 0xFF000000000000L) >>> 48) / 32.0f - 4.0f;
    }

    public float[] getHeightData(int x, int z) {
        return new float[]{this.getBaseHeight(x, z), this.getHeightScale(x, z)};
    }

    @Override
    public void setTerrainExpress(int terrain, int i) {
        int n = i;
        this.data[n] = this.data[n] | (long)terrain << 40;
    }
}

